/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsObjectLabelProvider;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.ArtifactEditor;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class EditEnumeratedArtifact
extends XNavigateItemAction {
    private static final String TITLE = "Edit Enumerated Artifact";

    public EditEnumeratedArtifact() {
        super(TITLE, (KeyedImage)FrameworkImage.GEAR, new XNavItemCat[]{XNavigateItem.DEFINE_ADMIN, XNavItemCat.OSEE_ADMIN});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        ArrayList arts = new ArrayList();
        arts.addAll(Collections.castAll((Collection)AtsApiService.get().getQueryService().getArtifacts(CoreArtifactTypes.OseeTypeEnum)));
        if (arts.isEmpty()) {
            AWorkbench.popup((String)"Warning", (String)"No Enumerated Artifact(s) Found.");
        } else {
            FilteredTreeDialog dialog = new FilteredTreeDialog(TITLE, "Select Enumerated Artifact to edit.", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new AtsObjectLabelProvider(false, true));
            dialog.setInput(arts);
            dialog.setMultiSelect(false);
            if (dialog.open() == 0) {
                Artifact selectedArt = (Artifact)dialog.getSelectedFirst();
                ArtifactEditor.editArtifact((Artifact)selectedArt);
            }
        }
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE_ADMIN, XNavItemCat.OSEE_ADMIN);
    }
}

