/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryCheckDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class RevertDuplicateAtsTransitionByIdAction
extends Action {
    public RevertDuplicateAtsTransitionByIdAction() {
        super("Revert Duplicate ATS Transition by ID");
        this.setToolTipText(this.getText());
    }

    public void run() {
        String title = this.getText();
        final EntryCheckDialog dialog = new EntryCheckDialog(title, "Enter ATS Ids", "Persist");
        if (dialog.open() == 0) {
            final boolean persist = dialog.isChecked();
            AbstractOperation operation = new AbstractOperation(title, "org.eclipse.osee.ats.ide"){

                protected void doWork(IProgressMonitor monitor) throws Exception {
                    LinkedList<String> atsIds = new LinkedList<String>();
                    LinkedList<ArtifactId> artIds = new LinkedList<ArtifactId>();
                    String[] stringArray = dialog.getEntry().split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        if (Strings.isNumeric((String)(id = id.replaceAll(" ", "")))) {
                            artIds.add(ArtifactId.valueOf((String)id));
                        } else {
                            atsIds.add(id);
                        }
                        ++n2;
                    }
                    XResultData results = new XResultData();
                    SkynetTransaction trans = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)this.getName());
                    boolean changed = false;
                    for (Artifact art : ArtifactQuery.getArtifactListFrom(artIds, (BranchId)AtsApiService.get().getAtsBranch())) {
                        results.logf("\n\nReverting transition for %s\n\n", new Object[]{art.toStringWithId()});
                        if (RevertDuplicateAtsTransitionByIdAction.revertTransition(art, results, persist, trans)) {
                            changed = true;
                            continue;
                        }
                        results.log("Nothing to change.");
                    }
                    if (!atsIds.isEmpty()) {
                        for (Artifact art : ArtifactQuery.getArtifactListFromAttributeValues((AttributeTypeId)AtsAttributeTypes.AtsId, atsIds, (BranchId)AtsApiService.get().getAtsBranch(), (int)50)) {
                            results.logf("\n\nReverting transition for %s\n\n", new Object[]{art.toStringWithId()});
                            if (RevertDuplicateAtsTransitionByIdAction.revertTransition(art, results, persist, trans)) {
                                changed = true;
                                continue;
                            }
                            results.log("Nothing to change");
                        }
                    }
                    if (persist && !results.isErrors() && changed) {
                        trans.execute();
                    }
                    if (!changed) {
                        results.error("Nothing changed");
                    }
                    XResultDataUI.report((XResultData)results, (String)this.getName());
                    if (results.isErrors()) {
                        AWorkbench.popup((String)"Errors found, search Error in results.  Restart before re-running if you persisted");
                    }
                }
            };
            Operations.executeAsJob((IOperation)operation, (boolean)true);
        }
    }

    protected static boolean revertTransition(Artifact art, XResultData results, boolean persist, SkynetTransaction persistTransaction) {
        List attributes = null;
        for (AttributeTypeId attributeTypeId : Arrays.asList(AtsAttributeTypes.CompletedDate, AtsAttributeTypes.CancelledDate)) {
            attributes = art.getAttributes(attributeTypeId);
            if (attributes.size() > 1) break;
        }
        if (attributes == null || attributes.isEmpty()) {
            results.errorf("Unable to find duplicate completed/cancelled dates for artifact %s", new Object[]{art.toStringWithId()});
            return false;
        }
        TransactionToken trans1 = null;
        TransactionToken trans2 = null;
        for (Attribute attr : attributes) {
            TransactionToken transId = TransactionManager.getTransaction((BranchToken)art.getBranch(), (Attribute)attr);
            if (trans1 == null) {
                trans1 = transId;
                continue;
            }
            trans2 = transId;
        }
        if (trans1 == null || trans2 == null) {
            return false;
        }
        TransactionToken transactionToken = trans1.getId() < trans2.getId() ? trans1 : trans2;
        TransactionToken lateTrans = trans2.getId() < trans1.getId() ? trans1 : trans2;
        Conditions.assertNotNull((Object)transactionToken, (String)"Can not find early transaction", (Object[])new Object[0]);
        Conditions.assertNotNull((Object)lateTrans, (String)"Can not find late transaction", (Object[])new Object[0]);
        return TransactionManager.revertArtifactFromTransaction((Artifact)art, (TransactionId)lateTrans, (XResultData)results, (boolean)persist, (SkynetTransaction)persistTransaction);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.TASK);
    }
}

