/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.revision.ChangeData;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class ShowBranchChangeDataAction
extends AbstractAtsAction {
    private final AbstractWorkflowArtifact awa;

    public ShowBranchChangeDataAction(AbstractWorkflowArtifact awa) {
        super("Show Branch Change Data Report");
        this.awa = awa;
        this.setToolTipText("Show computed change data from Branch; should be same as what's shown in change report");
    }

    @Override
    public void runWithException() {
        if (!this.awa.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            AWorkbench.popup((String)"Only valid for Team Workflow artifacts");
            return;
        }
        TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)this.awa;
        if (!AtsApiService.get().getBranchService().isWorkingBranchInWork((IAtsTeamWorkflow)teamArt) && !AtsApiService.get().getBranchService().isWorkingBranchEverCommitted((IAtsTeamWorkflow)teamArt)) {
            AWorkbench.popup((String)"Working branch never created or committed.");
            return;
        }
        XResultData result = new XResultData();
        ChangeData changeData = AtsApiService.get().getBranchServiceIde().getChangeDataFromEarliestTransactionId(teamArt);
        result.log("Number of changes " + changeData.getChanges().size() + "\n");
        for (Change change : changeData.getChanges()) {
            result.log(String.format("Change [%s]", change));
        }
        XResultDataUI.report((XResultData)result, (String)String.format("Branch Change Data Report [%s]", new Object[]{this.awa}));
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.WORKFLOW);
    }

    public static boolean isApplicable(AbstractWorkflowArtifact awa) {
        return awa.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow});
    }
}

