/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class ShowSprintsAction
extends AbstractAtsAction {
    private final IAgileBacklog backlog;
    private final AtsApi atsApi;

    public ShowSprintsAction(IAgileBacklog backlog) {
        this.backlog = backlog;
        this.setText("Show Open Sprints");
        this.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_SPRINT)));
        this.atsApi = AtsApiService.get();
    }

    @Override
    public void runWithException() {
        IAgileTeam agileTeam = this.atsApi.getAgileService().getAgileTeamFromBacklog(this.backlog);
        Collection sprints = this.atsApi.getAgileService().getAgileSprints(agileTeam);
        ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>();
        for (IAgileSprint sprint : sprints) {
            if (!sprint.isInWork()) continue;
            workItems.add((IAtsWorkItem)sprint);
        }
        WorldEditor.open("Open Sprints", workItems);
    }
}

