/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.jira;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.jira.JiraSearch;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class SearchJiraStoryAction
extends AbstractAtsAction {
    private final ISelectedAtsArtifacts selectedAtsArtifacts;

    public SearchJiraStoryAction(ISelectedAtsArtifacts selectedAtsArtifacts) {
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        this.setToolTipText("Search Related JIRA Story");
    }

    @Override
    public void runWithException() {
        XResultData rd = new XResultData();
        rd.log(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "\n");
        Artifact wfArt = this.selectedAtsArtifacts.getSelectedWorkflowArtifacts().iterator().next();
        IAtsWorkItem workItem = AtsApiService.get().getWorkItemService().getWorkItem((ArtifactToken)wfArt);
        rd.log("Team Workflow: " + workItem.toStringWithAtsId() + "\n");
        if (!workItem.isTeamWorkflow()) {
            AWorkbench.popup((String)"Must be Team Workflow");
            return;
        }
        try {
            JiraSearch srch = AtsApiService.get().getJiraService().search(workItem);
            rd.log("\n\n" + srch + "\n\n" + srch.getRd().toString());
        }
        catch (Exception ex) {
            rd.log(Lib.exceptionToString((Exception)ex));
        }
        XResultDataUI.report((XResultData)rd, (String)((Object)((Object)this)).getClass().getSimpleName());
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.JIRA_SEARCH);
    }
}

