/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.task;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.create.TasksFromAction;
import org.eclipse.osee.ats.api.util.AtsConstants;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class RestoreTasksFromActions
extends AbstractAtsAction {
    private final Collection<TaskArtifact> tasks;
    private ISelectedAtsArtifacts selectedAtsArtifacts;

    public RestoreTasksFromActions(Collection<TaskArtifact> tasks) {
        super(AtsConstants.RestoreTasksFromActions.name());
        this.tasks = tasks;
    }

    public RestoreTasksFromActions(ISelectedAtsArtifacts selectedAtsArtifacts) {
        super(AtsConstants.RestoreTasksFromActions.name());
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        this.tasks = null;
    }

    private Collection<TaskArtifact> getTasks() {
        if (this.tasks != null) {
            return this.tasks;
        }
        return this.selectedAtsArtifacts.getSelectedTaskArtifacts();
    }

    @Override
    public void run() {
        Collection<TaskArtifact> useTasks = this.getTasks();
        if (useTasks.isEmpty()) {
            AWorkbench.popup((String)"Task(s) Must Be Selected");
            return;
        }
        AtsApiIde atsApi = AtsApiService.get();
        for (TaskArtifact task : useTasks) {
            if (!task.isCompletedOrCancelled()) continue;
            AWorkbench.popup((String)"Can't restore actions from off Completed/Cancelled tasks");
            return;
        }
        String msg = "This operation will:\n\n1. Look for a Team Workflow that created each task.\n2. Transition the related Team Workflow to the state it was previously in.\n3. Auto-add to configured Goals if not already a member.\n4. Task will remain untouched.";
        if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getText(), (String)msg)) {
            TasksFromAction tfa = new TasksFromAction();
            tfa.setCreatedBy(atsApi.getUserService().getCurrentUser().getArtifactId());
            for (IAtsTask iAtsTask : useTasks) {
                tfa.getSourceTasks().add(iAtsTask.getArtifactToken());
            }
            tfa = atsApi.getServerEndpoints().getTaskEp().restore(tfa);
            XResultDataUI.report((XResultData)tfa.getRd(), (String)this.getText());
            if (tfa.getRd().isSuccess()) {
                ArrayList<IAtsTeamWorkflow> arrayList = new ArrayList<IAtsTeamWorkflow>();
                for (ArtifactToken task : tfa.getSourceTasks()) {
                    Collection related = atsApi.getRelationResolver().getRelated((ArtifactId)task, AtsRelationTypes.Derive_From);
                    if (related.size() != 1 || !((ArtifactToken)related.iterator().next()).isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
                    arrayList.add(atsApi.getWorkItemService().getTeamWf((ArtifactToken)related.iterator().next()));
                }
                atsApi.getStoreService().reload((Collection)Collections.castAll(arrayList));
                atsApi.getStoreService().reload((Collection)Collections.castAll(useTasks));
                if (arrayList.size() == 1) {
                    WorkflowEditor.edit((IAtsWorkItem)arrayList.iterator().next());
                } else {
                    WorldEditor.open(this.getText(), Collections.castAll(arrayList));
                }
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.DUPLICATE);
    }
}

