/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile;

import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.agile.XOpenStoredSprintReportsButton;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.explorer.ArtifactExplorerUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XButton;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.widgets.Shell;

public class XStoreSprintReportsButton
extends XButton
implements ArtifactWidget {
    protected IAgileSprint sprint;
    private final boolean editable = false;
    public static final String WIDGET_ID = XStoreSprintReportsButton.class.getSimpleName();
    XModifiedListener listener = new XModifiedListener(){

        public void widgetModified(XWidget widget) {
            try {
                XStoreSprintReportsButton.this.storeAndOpen();
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    };

    public XStoreSprintReportsButton() {
        super("Store Snapshot of Sprint Reports");
        this.setImage(ImageManager.getImage((OseeImage)AtsImage.REPORT));
        this.setToolTip("Click to Store and Open Snapshot of Sprint Reports");
        this.addXModifiedListener(this.listener);
    }

    public Artifact getArtifact() {
        return AtsApiService.get().getQueryServiceIde().getArtifact(this.sprint);
    }

    private void storeAndOpen() {
        if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getLabel(), (String)"This will generate all reports and store them in database.\n\nThis is important if Sprint contents change after Sprint is closed\nsuch as moving un-completed work to the next Sprint.\nSnapshot reports will retain the metrics at the point of storage.\n\nAre you sure?")) {
            try {
                XResultData results;
                ArtifactToken teamArt = AtsApiService.get().getRelationResolver().getRelatedOrNull((IAtsObject)this.sprint, AtsRelationTypes.AgileTeamToSprint_AgileTeam);
                if (teamArt != null && (results = AtsApiService.get().getServerEndpoints().getAgileEndpoint().storeSprintReports(teamArt.getId().longValue(), this.sprint.getId().longValue())).isErrors()) {
                    AWorkbench.popup((String)(String.valueOf(this.getLabel()) + " errors " + results.toString()));
                    return;
                }
                AtsApiService.get().getQueryServiceIde().getArtifact(this.sprint).reloadAttributesAndRelations();
                XOpenStoredSprintReportsButton stored = new XOpenStoredSprintReportsButton();
                stored.setArtifact(AtsApiService.get().getQueryServiceIde().getArtifact(this.sprint));
                stored.openExternally();
                ArtifactExplorerUtil.revealArtifact((Artifact)AtsApiService.get().getQueryServiceIde().getArtifact(this.sprint));
                AWorkbench.popup((String)"Reports opened in browser");
            }
            catch (Exception ex) {
                OseeLog.log(XStoreSprintReportsButton.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void revert() {
    }

    public void saveToArtifact() {
    }

    public void setArtifact(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
            this.sprint = (IAgileSprint)artifact;
        }
    }

    public boolean isEditable() {
        return false;
    }
}

