/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.jira;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.jira.Issue;
import org.eclipse.osee.ats.api.workflow.jira.JiraSearch;
import org.eclipse.osee.ats.ide.agile.jira.AbstractJiraSyncColumnUI;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.swt.graphics.Color;

public class JiraStateColumnUI
extends AbstractJiraSyncColumnUI {
    public static JiraStateColumnUI instance = new JiraStateColumnUI();
    private static Map<String, Color> stateToColor;

    public static JiraStateColumnUI getInstance() {
        return instance;
    }

    private JiraStateColumnUI() {
        super(AtsColumnTokensDefault.JiraStateColumn);
        if (stateToColor == null) {
            stateToColor = new HashMap<String, Color>();
            stateToColor.put("To Do", FontManager.getDarkCyan());
            stateToColor.put("In Progress", FontManager.getDarkBlue());
            stateToColor.put("In Review", FontManager.getDarkYellow());
            stateToColor.put("Closed", FontManager.getDarkGreen());
        }
    }

    public JiraStateColumnUI copy() {
        JiraStateColumnUI newXCol = new JiraStateColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public String getValue(IAtsWorkItem workItem, Map<Long, String> idToValueMap) {
        IAgileSprint sprint;
        if (workItem.isTeamWorkflow() && (sprint = AtsApiService.get().getAgileService().getSprint((IAtsTeamWorkflow)workItem)) != null) {
            JiraSearch srch = JiraStateColumnUI.search(workItem);
            if (srch.getRd().isErrors()) {
                return srch.getRd().toString();
            }
            if (srch.issues != null && !srch.issues.isEmpty()) {
                return ((Issue)srch.issues.iterator().next()).getState();
            }
            return "Not in JIRA";
        }
        return "";
    }

    @Override
    public Color getForeground(Object element, XViewerColumn xCol, int columnIndex) {
        String text = this.getColumnText(element, xCol, columnIndex);
        Color col = stateToColor.get(text);
        if (col != null) {
            return col;
        }
        return super.getForeground(element, xCol, columnIndex);
    }
}

