/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.branch.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.commit.CommitConfigItem;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsPeerReviewDefinition;
import org.eclipse.osee.ats.api.workdef.StateEventType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.core.review.DecisionReviewOnTransitionToHook;
import org.eclipse.osee.ats.core.review.PeerReviewOnTransitionToHook;
import org.eclipse.osee.ats.ide.branch.AtsBranchServiceIde;
import org.eclipse.osee.ats.ide.branch.internal.AtsBranchCommitOperation;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.model.MergeBranch;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.CatchAndReleaseJob;
import org.eclipse.osee.framework.plugin.core.util.IExceptionableRunnable;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.revision.ChangeData;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.change.ChangeUiUtil;
import org.eclipse.osee.framework.ui.skynet.change.WordChangeUtil;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.util.NameLabelProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeBranchDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.xmerge.MergeView;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class AtsBranchServiceIdeImpl
implements AtsBranchServiceIde {
    private final AtsApi atsApi;

    public AtsBranchServiceIdeImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    @Override
    public void showMergeManager(TeamWorkFlowArtifact teamArt) {
        try {
            BranchToken workingBranch = teamArt.getWorkingBranch();
            ArrayList<BranchToken> destinationBranches = new ArrayList<BranchToken>();
            if (workingBranch.isValid()) {
                List mergeBranches = BranchManager.getMergeBranches((BranchId)workingBranch);
                BranchToken selectedBranch = null;
                if (!mergeBranches.isEmpty()) {
                    if (!BranchManager.getState((BranchId)workingBranch).isRebaselineInProgress()) {
                        for (MergeBranch mergeBranch : mergeBranches) {
                            destinationBranches.add(mergeBranch.getDestinationBranch());
                        }
                        if (mergeBranches.size() > 1) {
                            FilteredTreeBranchDialog dialog = new FilteredTreeBranchDialog("Select Destination Branch", "Select The Destination Branch for which you want to open the Merge Manager", destinationBranches);
                            int result = dialog.open();
                            if (result == 0) {
                                selectedBranch = (BranchId)dialog.getSelectedFirst();
                            }
                        } else {
                            MergeBranch updateFromParentMergeBranch = BranchManager.getFirstMergeBranch((BranchId)workingBranch);
                            selectedBranch = updateFromParentMergeBranch.getDestinationBranch();
                        }
                    } else {
                        MergeBranch updateFromParentMergeBranch = BranchManager.getFirstMergeBranch((BranchId)workingBranch);
                        selectedBranch = updateFromParentMergeBranch.getDestinationBranch();
                    }
                    if (selectedBranch != null) {
                        MergeView.openView((BranchId)workingBranch, (BranchId)selectedBranch, (TransactionRecord)BranchManager.getBaseTransaction((BranchId)workingBranch));
                    }
                } else {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)"There are no Merge Branches to view");
                }
            } else {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)"This Artifact does not have a working branch");
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    @Override
    public void showMergeManager(TeamWorkFlowArtifact teamArt, BranchId destinationBranch) {
        if (this.atsApi.getBranchService().isWorkingBranchInWork((IAtsTeamWorkflow)teamArt)) {
            BranchToken workingBranch = this.atsApi.getBranchService().getWorkingBranch((IAtsTeamWorkflow)teamArt);
            MergeView.openView((BranchId)workingBranch, (BranchId)destinationBranch, (TransactionRecord)BranchManager.getBaseTransaction((BranchId)workingBranch));
        } else if (this.atsApi.getBranchService().isCommittedBranchExists((IAtsTeamWorkflow)teamArt)) {
            for (TransactionRecord transactionId : this.atsApi.getBranchService().getTransactionIds((IAtsTeamWorkflow)teamArt, true)) {
                if (!transactionId.isOnBranch(destinationBranch)) continue;
                MergeView.openView((TransactionRecord)transactionId);
            }
        }
    }

    @Override
    public boolean deleteWorkingBranch(TeamWorkFlowArtifact teamWf, boolean promptUser, boolean pend) {
        block10: {
            boolean isExecutionAllowed = !promptUser;
            try {
                BranchToken branch = this.atsApi.getBranchService().getWorkingBranch((IAtsTeamWorkflow)teamWf);
                if (promptUser) {
                    StringBuilder message = new StringBuilder();
                    if (BranchManager.hasChanges((BranchId)branch)) {
                        message.append("Warning: Changes have been made on this branch.\n\n");
                    }
                    message.append("Are you sure you want to delete the branch? \n\n");
                    message.append("BRANCH NAME: \n\"" + branch + "\"");
                    isExecutionAllowed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete Working Branch", (String)message.toString());
                }
                if (!isExecutionAllowed) break block10;
                Exception exception = null;
                Result result = Result.FalseResult;
                try {
                    result = this.deleteWorkingBranch(teamWf, pend);
                }
                catch (Exception ex) {
                    exception = ex;
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Problem deleting branch.", (Throwable)ex);
                }
                if (result != null) {
                    if (promptUser) {
                        AWorkbench.popup((String)"Delete Complete", (String)(result.isTrue() ? "Branch delete was successful." : "Branch delete failed.\n" + result.getText()));
                    } else if (result.isFalse()) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)result.getText(), (Throwable)exception);
                    }
                }
                return true;
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Problem deleting branch.", (Throwable)ex);
            }
        }
        return false;
    }

    @Override
    public TransactionToken getTransactionIdOrPopupChoose(IAtsTeamWorkflow teamWf, String title, boolean showMergeManager) {
        BranchToken branch;
        Collection transactions = this.atsApi.getBranchService().getTransactionIds(teamWf, showMergeManager);
        LinkedHashMap<BranchToken, TransactionRecord> branchToTx = new LinkedHashMap<BranchToken, TransactionRecord>();
        if (transactions.size() == 1) {
            return (TransactionToken)transactions.iterator().next();
        }
        for (TransactionRecord id : transactions) {
            boolean workingBranch = BranchManager.getType((TransactionToken)id).isWorkingBranch();
            BranchState state = BranchManager.getState((BranchId)id.getBranch());
            if (workingBranch && state.isRebaselined() && state.isCommitted()) continue;
            BranchToken branch2 = BranchManager.getBranchToken((BranchId)id.getBranch());
            branchToTx.put(branch2, id);
        }
        ViewerComparator comparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 == null || e2 == null) {
                    return 0;
                }
                Long b1 = ((BranchToken)e1).getId();
                Long b2 = ((BranchToken)e1).getId();
                if (b1 > b2) {
                    return -1;
                }
                if (b2 > b1) {
                    return 1;
                }
                return 0;
            }
        };
        FilteredTreeDialog dialog = new FilteredTreeDialog(title, "Select Commit Branch", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new NameLabelProvider(), comparator);
        dialog.setInput(branchToTx.keySet());
        if (dialog.open() == 0 && (branch = (BranchToken)dialog.getSelectedFirst()) != null) {
            TransactionId id = (TransactionId)branchToTx.get(branch);
            return TransactionToken.valueOf((TransactionId)id, (BranchId)branch);
        }
        return TransactionToken.SENTINEL;
    }

    @Override
    public void showChangeReport(IAtsTeamWorkflow teamArt) {
        try {
            if (this.atsApi.getBranchService().isWorkingBranchInWork(teamArt)) {
                BranchToken parentBranch = this.atsApi.getBranchService().getConfiguredBranchForWorkflow(teamArt);
                if (parentBranch.isInvalid()) {
                    AWorkbench.popup((String)"Parent Branch Error", (String)"Parent Branch can not be null. Set Targeted Version or configure Team for Parent Branch");
                    return;
                }
                BranchToken workingBranch = this.atsApi.getBranchService().getWorkingBranch(teamArt);
                ChangeUiUtil.open((BranchToken)workingBranch, (BranchId)parentBranch, (boolean)true);
            } else if (this.atsApi.getBranchService().isCommittedBranchExists(teamArt)) {
                TransactionToken transactionId = this.getTransactionIdOrPopupChoose(teamArt, "Show Change Report", false);
                if (TransactionToken.SENTINEL.equals(transactionId)) {
                    return;
                }
                ChangeUiUtil.open((TransactionToken)transactionId);
            } else {
                AWorkbench.popup((String)"ERROR", (String)"No Branch or Committed Transaction Found.");
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't show change report.", (Throwable)ex);
        }
    }

    @Override
    public void showChangeReportForBranch(TeamWorkFlowArtifact teamArt, BranchId destinationBranch) {
        try {
            for (TransactionToken transactionId : this.atsApi.getBranchService().getTransactionIds((IAtsTeamWorkflow)teamArt, false)) {
                if (!transactionId.isOnBranch(destinationBranch)) continue;
                ChangeUiUtil.open((TransactionToken)transactionId);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't show change report.", (Throwable)ex);
        }
    }

    @Override
    public void generateWordChangeReport(IAtsTeamWorkflow teamArt) {
        List localChanges = (List)this.getChangeData(teamArt, null).getChanges();
        WordChangeUtil.generateWordTemplateChangeReport((List)localChanges, (PresentationType)PresentationType.DIFF, (boolean)false, (boolean)false);
    }

    @Override
    public void generateContextChangeReport(IAtsTeamWorkflow teamArt) {
        List localChanges = (List)this.getChangeData(teamArt, null).getChanges();
        WordChangeUtil.generateWordTemplateChangeReport((List)localChanges, (PresentationType)PresentationType.DIFF_NO_ATTRIBUTES, (boolean)true, (boolean)true);
    }

    @Override
    public XResultData commitWorkingBranch(TeamWorkFlowArtifact teamArt, boolean commitPopup, boolean overrideStateValidation, BranchId destinationBranch, boolean archiveWorkingBranch, XResultData rd) {
        if (rd == null) {
            rd = new XResultData();
        }
        if (this.atsApi.getBranchService().isBranchInCommit((IAtsTeamWorkflow)teamArt)) {
            rd.error("Branch is currently being committed.");
        }
        try {
            new AtsBranchCommitOperation(teamArt, commitPopup, overrideStateValidation, destinationBranch, archiveWorkingBranch, rd).run();
        }
        catch (Exception ex) {
            rd.errorf("Exception Committing Branch %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return rd;
    }

    @Override
    public ChangeData getChangeDataFromEarliestTransactionId(IAtsTeamWorkflow teamWf) {
        return this.getChangeData(teamWf, null);
    }

    @Override
    public ChangeData getChangeData(IAtsTeamWorkflow teamWf, CommitConfigItem commitConfigItem) {
        if (commitConfigItem != null && !AtsBranchServiceIdeImpl.isBaselinBranchConfigured(commitConfigItem)) {
            throw new OseeArgumentException("Parent Branch not configured for [%s]", new Object[]{commitConfigItem});
        }
        ArrayList changes = new ArrayList();
        IOperation operation = null;
        if (this.atsApi.getBranchService().isWorkingBranchInWork(teamWf)) {
            operation = ChangeManager.comparedToParent((BranchId)this.atsApi.getBranchService().getWorkingBranch(teamWf), changes);
            Operations.executeWorkAndCheckStatus((IOperation)operation);
        } else if (this.atsApi.getBranchService().isCommittedBranchExists(teamWf)) {
            TransactionToken transactionId = null;
            if (commitConfigItem == null) {
                transactionId = this.atsApi.getBranchService().getEarliestTransactionId(teamWf);
            } else {
                Collection transIds = this.atsApi.getBranchService().getTransactionIds(teamWf, false);
                if (transIds.size() == 1) {
                    transactionId = (TransactionToken)transIds.iterator().next();
                } else {
                    for (TransactionRecord transId : transIds) {
                        if (!transId.isOnBranch(commitConfigItem.getBaselineBranchId())) continue;
                        transactionId = transId;
                    }
                    if (transactionId == null) {
                        TransactionRecord transactionRecord = null;
                        for (TransactionRecord transId : transIds) {
                            if (transactionRecord != null && transId.getId() >= transactionRecord.getId()) continue;
                            transactionRecord = transId;
                        }
                        transactionId = transactionRecord;
                    }
                }
            }
            if (transactionId == null) {
                throw new OseeStateException("Unable to determine transaction id for [%s]", new Object[]{commitConfigItem});
            }
            operation = ChangeManager.comparedToPreviousTx((TransactionToken)transactionId, changes);
            Operations.executeWorkAndCheckStatus((IOperation)operation);
        }
        return new ChangeData(changes);
    }

    private static boolean isBaselinBranchConfigured(CommitConfigItem commitConfigItem) {
        return commitConfigItem.getBaselineBranchId().isValid();
    }

    @Override
    public boolean createNecessaryBranchEventReviews(StateEventType stateEventType, IAtsTeamWorkflow teamWf, Date createdDate, AtsUser createdBy, IAtsChangeSet changes) {
        Conditions.checkNotNull((Object)teamWf, (String)"Team Workflow");
        boolean created = false;
        if (stateEventType != StateEventType.CommitBranch && stateEventType != StateEventType.CreateBranch) {
            throw new OseeStateException("Invalid stateEventType [%s]", new Object[]{stateEventType});
        }
        TeamWorkFlowArtifact teamWfArt = (TeamWorkFlowArtifact)this.atsApi.getQueryService().getArtifact((IAtsObject)teamWf);
        for (IAtsDecisionReviewDefinition decRevDef : teamWf.getStateDefinition().getDecisionReviews()) {
            IAtsDecisionReview decRev;
            if (decRevDef.getStateEventType() == null || !decRevDef.getStateEventType().equals((Object)stateEventType) || (decRev = DecisionReviewOnTransitionToHook.createNewDecisionReview((IAtsDecisionReviewDefinition)decRevDef, (IAtsChangeSet)changes, (IAtsTeamWorkflow)teamWfArt, (Date)createdDate, (AtsUser)createdBy)) == null) continue;
            created = true;
            changes.add((Object)decRev);
        }
        for (IAtsPeerReviewDefinition peerRevDef : teamWf.getStateDefinition().getPeerReviews()) {
            IAtsPeerToPeerReview peerRev;
            if (peerRevDef.getStateEventType() == null || !peerRevDef.getStateEventType().equals((Object)stateEventType) || (peerRev = PeerReviewOnTransitionToHook.createNewPeerToPeerReview((IAtsPeerReviewDefinition)peerRevDef, (IAtsChangeSet)changes, (IAtsTeamWorkflow)teamWfArt, (Date)createdDate, (AtsUser)createdBy)) == null) continue;
            created = true;
            changes.add((Object)peerRev);
        }
        return created;
    }

    @Override
    public Job createWorkingBranch_Create(TeamWorkFlowArtifact teamArt) {
        return this.createWorkingBranch_Create((IAtsTeamWorkflow)teamArt, false);
    }

    @Override
    public Job createWorkingBranch_Create(IAtsTeamWorkflow teamWf, boolean pend) {
        BranchToken parentBranch = this.atsApi.getBranchService().getConfiguredBranchForWorkflow(teamWf);
        return this.createWorkingBranch_Create(teamWf, (BranchId)parentBranch, pend);
    }

    @Override
    public Job createWorkingBranch_Create(TeamWorkFlowArtifact teamArt, BranchId parentBranch) {
        return this.createWorkingBranch_Create(teamArt, parentBranch, false);
    }

    @Override
    public Job createWorkingBranch_Create(IAtsTeamWorkflow teamWf, BranchId parentBranch, boolean pend) {
        Conditions.checkNotNull((Object)teamWf, (String)"Parent Team Workflow");
        Conditions.checkNotNull((Object)parentBranch, (String)"Parent Branch");
        Conditions.checkValid((Id)parentBranch, (String)"Parent Branch", (Object[])new Object[0]);
        TransactionToken parentTransactionId = TransactionManager.getHeadTransaction((BranchId)parentBranch);
        return this.createWorkingBranch(teamWf, parentTransactionId, pend);
    }

    @Override
    public Job createWorkingBranch(final IAtsTeamWorkflow teamWf, final TransactionToken parentTransactionId, boolean pend) {
        final String branchName = this.atsApi.getBranchService().getBranchName(teamWf);
        Conditions.checkNotNull((Object)teamWf, (String)"Parent Team Workflow");
        Conditions.checkNotNull((Object)parentTransactionId, (String)"Parent Branch");
        IExceptionableRunnable runnable = new IExceptionableRunnable(){

            public IStatus run(IProgressMonitor monitor) {
                XResultData rd = new XResultData();
                for (IAtsWorkItemHook item : AtsBranchServiceIdeImpl.this.atsApi.getWorkItemService().getWorkItemHooks()) {
                    rd = item.creatingBranch(teamWf, rd);
                }
                if (rd.isErrors()) {
                    throw new OseeCoreException("Can not create branch.  Reason: [%s]", new Object[]{rd.toString()});
                }
                AtsBranchServiceIdeImpl.this.atsApi.getBranchService().setWorkingBranchCreationInProgress(teamWf, true);
                BranchToken branch = BranchManager.createWorkingBranch((TransactionToken)parentTransactionId, (String)branchName, (ArtifactId)AtsBranchServiceIdeImpl.this.atsApi.getQueryService().getArtifact((IAtsObject)teamWf));
                AtsBranchServiceIdeImpl.this.atsApi.getBranchService().setWorkingBranchCreationInProgress(teamWf, false);
                Conditions.assertTrue((boolean)branch.isValid(), (String)"Working Branch creation failed.", (Object[])new Object[0]);
                AtsBranchServiceIdeImpl.this.performPostBranchCreationTasks(teamWf);
                return Status.OK_STATUS;
            }
        };
        Job job = Jobs.startJob((Job)new CatchAndReleaseJob("Create Branch", runnable, Activator.class, "org.eclipse.osee.ats.ide"), (boolean)true);
        if (pend) {
            try {
                job.join();
            }
            catch (InterruptedException ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
        }
        return job;
    }

    private void performPostBranchCreationTasks(IAtsTeamWorkflow teamWf) {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create Reviews upon Transition");
        boolean created = this.createNecessaryBranchEventReviews(StateEventType.CreateBranch, teamWf, new Date(), AtsCoreUsers.SYSTEM_USER, changes);
        if (created) {
            changes.execute();
        }
        XResultData rd = new XResultData();
        for (IAtsWorkItemHook item : this.atsApi.getWorkItemService().getWorkItemHooks()) {
            item.workingBranchCreated(teamWf, rd);
        }
        if (rd.isErrors()) {
            ResultsEditor.open((String)"Branch Creation Tasks - Error", (XResultData)rd);
        }
    }

    @Override
    public Result deleteWorkingBranch(TeamWorkFlowArtifact teamArt, boolean pend) {
        BranchToken branch = this.atsApi.getBranchService().getWorkingBranch((IAtsTeamWorkflow)teamArt);
        if (branch != null) {
            IStatus status = null;
            if (pend) {
                status = BranchManager.deleteBranchAndPend((BranchId)branch);
            } else {
                Job job = BranchManager.deleteBranch((BranchId)branch);
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException ex) {
                    throw OseeCoreException.wrap((Throwable)ex);
                }
                status = job.getResult();
            }
            if (status.isOK()) {
                return Result.TrueResult;
            }
            return new Result(status.getMessage());
        }
        return Result.TrueResult;
    }
}

