/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.VersionLockedType;
import org.eclipse.osee.ats.api.version.VersionReleaseType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.FoundInVersionColumnUI;
import org.eclipse.osee.ats.ide.column.TargetedVersionColumnUI;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.VersionListDialog;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsCoreCodeXColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractVersionSelectorUI
extends XViewerAtsCoreCodeXColumn {
    public AbstractVersionSelectorUI(AtsCoreCodeColumnToken column) {
        super(column, AtsApiService.get());
    }

    public abstract RelationTypeSide getRelation();

    public boolean promptChangeVersion(AbstractWorkflowArtifact sma) {
        return this.promptChangeVersion(sma, null, null);
    }

    public boolean promptChangeVersion(AbstractWorkflowArtifact sma, VersionReleaseType verRelType, VersionLockedType verLockType) {
        return this.promptChangeVersionMultiSelect(Arrays.asList((TeamWorkFlowArtifact)sma), verRelType, verLockType);
    }

    private boolean isTargetedVersionRelation() {
        return this.getRelation().equals((Object)TargetedVersionColumnUI.getInstance().getRelation());
    }

    private boolean isFoundInVersionRelation() {
        return this.getRelation().equals((Object)FoundInVersionColumnUI.getInstance().getRelation());
    }

    public boolean promptChangeVersionMultiSelect(List<TeamWorkFlowArtifact> awas, VersionReleaseType versionReleaseType, VersionLockedType versionLockType) {
        if (awas.isEmpty()) {
            return false;
        }
        IAtsTeamDefinition teamDefHoldingVersions = null;
        for (TeamWorkFlowArtifact teamArt : awas) {
            if (!AtsApiService.get().getVersionService().isTeamUsesVersions(teamArt.getTeamDefinition())) {
                AWorkbench.popup((String)"ERROR", (String)("Team \"" + teamArt.getTeamDefinition().getName() + "\" doesn't use versions."));
                return false;
            }
            if (AtsApiService.get().getUserService().isAtsAdmin() && !teamArt.isTeamWorkflow()) {
                AWorkbench.popup((String)"ERROR ", (String)("Cannot set version for: \n\n" + teamArt.getName()));
                return false;
            }
            if (AtsApiService.get().getVersionService().isReleased((IAtsTeamWorkflow)teamArt) || AtsApiService.get().getVersionService().isVersionLocked((IAtsTeamWorkflow)teamArt)) {
                String error = "Team Workflow\n \"" + teamArt.getName() + "\"\n targeted version is locked or already released.";
                if (AtsApiService.get().getUserService().isAtsAdmin() && !MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Change Version", (String)(String.valueOf(error) + "\n\nOverride?"))) {
                    return false;
                }
                if (!AtsApiService.get().getUserService().isAtsAdmin()) {
                    AWorkbench.popup((String)"ERROR", (String)error);
                    continue;
                }
            }
            if (teamDefHoldingVersions != null && teamDefHoldingVersions.notEqual((Id)AtsApiService.get().getTeamDefinitionService().getTeamDefinitionHoldingVersions(teamArt.getTeamDefinition()))) {
                AWorkbench.popup((String)"ERROR", (String)"Can't change version on Workflows that have different release version sets.");
                return false;
            }
            if (teamDefHoldingVersions != null) continue;
            teamDefHoldingVersions = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionHoldingVersions(teamArt.getTeamDefinition());
        }
        Pair<IAtsVersion, Boolean> result = this.promptVersionSelectorDialog(awas.get(0), versionReleaseType, versionLockType, teamDefHoldingVersions);
        IAtsVersion selectedVersion = (IAtsVersion)result.getFirst();
        Boolean removeAllSelected = (Boolean)result.getSecond();
        if (selectedVersion == null && !removeAllSelected.booleanValue()) {
            return false;
        }
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("ATS Prompt Change Version");
        for (TeamWorkFlowArtifact sma : awas) {
            if (removeAllSelected.booleanValue()) {
                changes.unrelateAll((Object)sma, this.getRelation());
                continue;
            }
            if (this.isTargetedVersionRelation()) {
                AtsApiService.get().getVersionService().setTargetedVersion((IAtsTeamWorkflow)sma, selectedVersion, changes);
                continue;
            }
            if (this.isFoundInVersionRelation() && selectedVersion == AtsApiService.get().getVersionService().getFoundInVersion((IAtsWorkItem)sma)) continue;
            changes.setRelation((Object)sma, this.getRelation(), (Object)selectedVersion);
        }
        if (changes.isEmpty()) {
            return false;
        }
        changes.executeIfNeeded();
        ArtifactQuery.reloadArtifacts(awas);
        return true;
    }

    public Pair<IAtsVersion, Boolean> promptVersionSelectorDialog(TeamWorkFlowArtifact teamArt, VersionReleaseType versionReleaseType, VersionLockedType versionLockType, IAtsTeamDefinition teamDefHoldingVersions) {
        Object obj;
        VersionListDialog dialog;
        if (teamDefHoldingVersions == null) {
            teamDefHoldingVersions = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionHoldingVersions(teamArt.getTeamDefinition());
        }
        if (versionReleaseType == null || versionLockType == null) {
            if (teamDefHoldingVersions == null) {
                AWorkbench.popup((String)"ERROR", (String)"No versions configured for impacted team(s).");
                return null;
            }
            dialog = new VersionListDialog("Select Version", "Select Version", AtsApiService.get().getVersionService().getVersions(teamDefHoldingVersions));
        } else {
            dialog = new VersionListDialog("Select Version", "Select Version", AtsApiService.get().getVersionService().getVersions(teamDefHoldingVersions, versionReleaseType, versionLockType));
        }
        dialog.setRemoveAllAllowed(true);
        if (AtsApiService.get().getVersionService().hasTargetedVersion((IAtsWorkItem)teamArt)) {
            dialog.setInitialSelections(Arrays.asList(AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)teamArt)));
        }
        IAtsVersion newVersion = null;
        Boolean removeAllSelected = false;
        int result = dialog.open();
        if (dialog.isRemoveAllSelected()) {
            removeAllSelected = true;
        } else if (result == 0 && (newVersion = (IAtsVersion)(obj = dialog.getSelectedFirst())) != null && newVersion.isLocked()) {
            String error = "Version \"" + this.getCommitFullDisplayName(newVersion) + "\" is locked or already released.";
            if (AtsApiService.get().getUserService().isAtsAdmin() && !MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Change Version", (String)(String.valueOf(error) + "\n\nOverride?"))) {
                newVersion = null;
            } else if (!AtsApiService.get().getUserService().isAtsAdmin()) {
                AWorkbench.popup((String)"ERROR", (String)error);
            }
        }
        return new Pair(newVersion, (Object)removeAllSelected);
    }

    public String getCommitFullDisplayName(IAtsVersion version) {
        String description;
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(this.getName());
        String fullName = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.FullName, (Object)"");
        if (Strings.isValid((String)fullName)) {
            strs.add(fullName);
        }
        if (Strings.isValid((String)(description = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)"")))) {
            strs.add(description);
        }
        return Collections.toString((String)" - ", strs);
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<TeamWorkFlowArtifact> awas = new HashSet<TeamWorkFlowArtifact>();
            ArrayList<Artifact> arts = new ArrayList<Artifact>();
            for (TreeItem item : treeItems) {
                Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
                if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
                awas.add((TeamWorkFlowArtifact)art);
                arts.add(art);
            }
            if (awas.isEmpty()) {
                AWorkbench.popup((String)"Invalid Selection", (String)"Column [%s] is not valid for selected", (Object[])new Object[]{treeColumn.getText()});
                return;
            }
            if (this.promptChangeVersionMultiSelect(new ArrayList<TeamWorkFlowArtifact>(awas), AtsApiService.get().getUserService().isAtsAdmin() ? VersionReleaseType.Both : VersionReleaseType.UnReleased, AtsApiService.get().getUserService().isAtsAdmin() ? VersionLockedType.Both : VersionLockedType.UnLocked)) {
                ((XViewer)this.getXViewer()).update(awas.toArray(), null);
            }
            return;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return;
        }
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block6: {
            Artifact useArt;
            block8: {
                block7: {
                    if (!(treeItem.getData() instanceof Artifact)) break block6;
                    useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                    if (!useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) break block7;
                    if (AtsApiService.get().getWorkItemService().getTeams((Object)useArt).size() == 1) {
                        useArt = AtsApiService.get().getQueryServiceIde().getArtifact(AtsApiService.get().getWorkItemService().getFirstTeam((Object)useArt));
                        break block7;
                    }
                    return false;
                }
                if (useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) break block8;
                AWorkbench.popup((String)"Invalid Selection", (String)"Column [%s] is not valid for selected", (Object[])new Object[]{treeColumn.getText()});
                return false;
            }
            try {
                boolean modified = this.promptChangeVersion((TeamWorkFlowArtifact)useArt, AtsApiService.get().getUserService().isAtsAdmin() ? VersionReleaseType.Both : VersionReleaseType.UnReleased, AtsApiService.get().getUserService().isAtsAdmin() ? VersionLockedType.Both : VersionLockedType.UnLocked);
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified) {
                    useArt.persist("persist goals via alt-left-click");
                    xViewer.update((Object)useArt, null);
                    return true;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }
}

