/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.RemainingHoursColumnUI;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class AnnualCostAvoidanceColumnUI
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static AnnualCostAvoidanceColumnUI instance = new AnnualCostAvoidanceColumnUI();

    public static AnnualCostAvoidanceColumnUI getInstance() {
        return instance;
    }

    private AnnualCostAvoidanceColumnUI() {
        super("ats.column.annualCostAvoidance", "Annual Cost Avoidance", 50, XViewerAlign.Left, false, SortDataType.Float, false, "Hours that would be saved for the first year if this change were completed.\n\n(Weekly Benefit Hours * 52 weeks) - Remaining Hours\n\nIf number is high, benefit is great given hours remaining.");
    }

    public AnnualCostAvoidanceColumnUI copy() {
        AnnualCostAvoidanceColumnUI newXCol = new AnnualCostAvoidanceColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            Result result = AnnualCostAvoidanceColumnUI.isWorldViewAnnualCostAvoidanceValid(element);
            if (result.isFalse()) {
                return result.getText();
            }
            return AtsUtil.doubleToI18nString((double)AnnualCostAvoidanceColumnUI.getWorldViewAnnualCostAvoidance(element), (boolean)true);
        }
        catch (OseeCoreException ex) {
            LogUtil.getCellExceptionString((Exception)((Object)ex));
            return "";
        }
    }

    public static double getWorldViewAnnualCostAvoidance(Object object) {
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            double hours = 0.0;
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(object)) {
                if (team.isCompleted() || team.isCancelled()) continue;
                hours += AnnualCostAvoidanceColumnUI.getWorldViewAnnualCostAvoidance(team);
            }
            return hours;
        }
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.TeamWorkflow)) {
            TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)((Object)object);
            double benefit = AnnualCostAvoidanceColumnUI.getWorldViewWeeklyBenefit(teamArt);
            double remainHrs = AtsApiService.get().getEarnedValueService().getRemainHoursTotal((IAtsWorkItem)teamArt);
            return benefit * 52.0 - remainHrs;
        }
        if (object instanceof IAtsWorkItem) {
            return AnnualCostAvoidanceColumnUI.getWorldViewAnnualCostAvoidance(((IAtsWorkItem)object).getStoreObject());
        }
        return 0.0;
    }

    public static double getWorldViewWeeklyBenefit(TeamWorkFlowArtifact teamArt) {
        if (teamArt.isAttributeTypeValid((AttributeTypeId)AtsAttributeTypes.WeeklyBenefit)) {
            return 0.0;
        }
        String value = (String)teamArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.WeeklyBenefit, "");
        if (!Strings.isValid((String)value)) {
            return 0.0;
        }
        return Double.valueOf(value);
    }

    public static Result isWorldViewAnnualCostAvoidanceValid(Object object) {
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(object)) {
                Result result = AnnualCostAvoidanceColumnUI.isWorldViewAnnualCostAvoidanceValid(team);
                if (!result.isFalse()) continue;
                return result;
            }
        }
        if (object instanceof AbstractWorkflowArtifact) {
            AbstractWorkflowArtifact artifact = (AbstractWorkflowArtifact)((Object)object);
            if (artifact.isAttributeTypeValid((AttributeTypeId)AtsAttributeTypes.WeeklyBenefit)) {
                return Result.TrueResult;
            }
            Result result = RemainingHoursColumnUI.isRemainingHoursValid((Object)artifact);
            if (result.isFalse()) {
                return result;
            }
            String value = null;
            try {
                value = (String)artifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.WeeklyBenefit, "");
                if (!Strings.isValid((String)value)) {
                    return new Result("Weekly Benefit Hours not set.");
                }
                double val = Double.valueOf(value);
                if (val == 0.0) {
                    return new Result("Weekly Benefit Hours not set.");
                }
            }
            catch (NumberFormatException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)("ID " + artifact.getAtsId()), (Throwable)ex);
                return new Result("Weekly Benefit value is invalid double \"" + value + "\"");
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)("ID " + artifact.getAtsId()), (Throwable)ex);
                return new Result("Exception calculating cost avoidance.  See log for details.");
            }
            return Result.TrueResult;
        }
        return Result.FalseResult;
    }
}

