/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class DaysInCurrentStateColumnUI
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static DaysInCurrentStateColumnUI instance = new DaysInCurrentStateColumnUI();

    public static DaysInCurrentStateColumnUI getInstance() {
        return instance;
    }

    private DaysInCurrentStateColumnUI() {
        super("ats.column.daysInCurrState", "Days in Current State", 40, XViewerAlign.Center, false, SortDataType.Float, false, null);
    }

    public DaysInCurrentStateColumnUI copy() {
        DaysInCurrentStateColumnUI newXCol = new DaysInCurrentStateColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        block3: {
            double timeInCurrState;
            block4: {
                if (!(element instanceof IAtsWorkItem)) break block3;
                timeInCurrState = AtsApiService.get().getWorkItemService().getTimeInState((IAtsWorkItem)element);
                if (timeInCurrState != 0.0) break block4;
                return "0.0";
            }
            try {
                return AtsUtil.doubleToI18nString((double)(timeInCurrState / 8.64E7));
            }
            catch (OseeCoreException ex) {
                LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
        }
        return "";
    }
}

