/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Date;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class LastTransitionDateColumnUI
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static LastTransitionDateColumnUI instance = new LastTransitionDateColumnUI();

    public static LastTransitionDateColumnUI getInstance() {
        return instance;
    }

    private LastTransitionDateColumnUI() {
        super("ats.column.lastTransitionDate", "Last Transition State", 80, XViewerAlign.Center, false, SortDataType.Date, false, "Date of the transition to the current state.");
    }

    public LastTransitionDateColumnUI copy() {
        LastTransitionDateColumnUI newXCol = new LastTransitionDateColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            Date transitionDate;
            if (element instanceof IAtsWorkItem && (transitionDate = AtsApiService.get().getWorkItemService().getLastTransitionDate((IAtsWorkItem)element)) != null) {
                return DateUtil.getMMDDYYHHMM((Date)transitionDate);
            }
        }
        catch (OseeCoreException ex) {
            LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }
}

