/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.note.wf.WfNoteColors;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsCoreCodeXColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredListDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class NotesColorColumnUI
extends XViewerAtsCoreCodeXColumn {
    public static NotesColorColumnUI instance = new NotesColorColumnUI();

    public static NotesColorColumnUI getInstance() {
        return instance;
    }

    private NotesColorColumnUI() {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.NotesColorColumn, AtsApiService.get());
    }

    @Override
    public XViewerAtsCoreCodeXColumn copy() {
        NotesColorColumnUI newXCol = new NotesColorColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        Long colorId;
        if (element instanceof IAtsWorkItem && (colorId = (Long)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)((IAtsWorkItem)element), (AttributeTypeToken)AtsAttributeTypes.WorkflowNoteColor, null)) != null) {
            WfNoteColors color = WfNoteColors.getById((Long)colorId);
            if (color == null) {
                return String.format("Error: Can't resolve color for [%s]", colorId);
            }
            return color.toStringWithId();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            IAtsWorkItem workItem = null;
            boolean modified = false;
            XViewer xViewer = null;
            if (treeItem.getData() instanceof IAtsAction) {
                if (AtsApiService.get().getWorkItemService().getTeams(workItem).size() != 1) {
                    return false;
                }
                workItem = AtsApiService.get().getWorkItemService().getFirstTeam((Object)workItem);
            } else if (treeItem.getData() instanceof IAtsWorkItem) {
                workItem = (IAtsWorkItem)treeItem.getData();
            }
            if (workItem == null) {
                return false;
            }
            modified = NotesColorColumnUI.promptChangeColor(Arrays.asList(workItem));
            xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
            if (modified) {
                AtsApiService.get().getStoreService().executeChangeSet("persist assignees via alt-left-click", (IAtsObject)workItem);
            }
            if (!modified) return false;
            xViewer.update((Object)workItem.getStoreObject(), null);
            return true;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public static boolean promptChangeColor(IAtsWorkItem workItem) {
        return NotesColorColumnUI.promptChangeColor(Arrays.asList(workItem));
    }

    public static boolean promptChangeColor(Collection<? extends IAtsWorkItem> workItems) {
        FilteredListDialog diag = new FilteredListDialog("Select Notes Color", "Select Notes Color");
        diag.setClearAllowed(true);
        ArrayList sortColors = new ArrayList();
        sortColors.addAll(WfNoteColors.get());
        sortColors.remove(WfNoteColors.SENTINEL);
        sortColors.sort(Comparator.naturalOrder());
        diag.setInput(sortColors);
        if (diag.open() == 0) {
            WfNoteColors selected = (WfNoteColors)diag.getSelected();
            IAtsChangeSet changes = AtsApiService.get().createChangeSet("Notes Color");
            for (IAtsWorkItem iAtsWorkItem : workItems) {
                if (diag.isClearAllowedSelected() || selected.isInvalid() || selected.equals((Object)WfNoteColors.COLOR_BLACK)) {
                    changes.deleteAttributes((IAtsObject)iAtsWorkItem, (AttributeTypeToken)AtsAttributeTypes.WorkflowNoteColor);
                    continue;
                }
                changes.setSoleAttributeValue((IAtsObject)iAtsWorkItem, (AttributeTypeToken)AtsAttributeTypes.WorkflowNoteColor, (Object)selected.getId());
            }
            changes.executeIfNeeded();
        }
        return true;
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
            for (TreeItem item : treeItems) {
                IAtsWorkItem workItem;
                if (!(item.getData() instanceof IAtsWorkItem) || !((workItem = (IAtsWorkItem)item.getData()) instanceof AbstractWorkflowArtifact)) continue;
                workItems.add(workItem);
            }
            if (workItems.isEmpty()) {
                AWorkbench.popup((String)"Invalid selection for setting colors.");
                return;
            }
            NotesColorColumnUI.promptChangeColor(workItems);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    @Override
    public Color getForeground(Object element, XViewerColumn xCol, int columnIndex) {
        if (element instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)element;
            return NotesColorColumnUI.getWorkItemForground(workItem);
        }
        return super.getForeground(element, xCol, columnIndex);
    }

    public static Color getWorkItemForground(IAtsWorkItem workItem) {
        Long swtId;
        WfNoteColors color;
        Long colorId = (Long)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkflowNoteColor, null);
        if (colorId != null && (color = WfNoteColors.getById((Long)colorId)) != null && (swtId = color.getSwtId()) > 0L) {
            try {
                Color col = Displays.getSystemColor((int)swtId.intValue());
                if (col != null) {
                    return col;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

