/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreAttrTokColumnToken;
import org.eclipse.osee.ats.api.column.AtsCoreColumnToken;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class OriginatingWorkFlowColumnUI
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static OriginatingWorkFlowColumnUI instance = new OriginatingWorkFlowColumnUI();

    public static OriginatingWorkFlowColumnUI getInstance() {
        return instance;
    }

    private OriginatingWorkFlowColumnUI() {
        super("ats.column.origWf", "Originating Workflow", 150, XViewerAlign.Left, false, SortDataType.String, false, "Team Workflow(s) that were created upon origination of this Action.  Cancelled workflows not included.");
    }

    public OriginatingWorkFlowColumnUI copy() {
        OriginatingWorkFlowColumnUI newXCol = new OriginatingWorkFlowColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            IAtsAction action;
            if (element instanceof AbstractWorkflowArtifact && (action = ((AbstractWorkflowArtifact)((Object)element)).getParentAction()) != null) {
                Artifact parentAction = (Artifact)action.getStoreObject();
                return this.getColumnText(parentAction, column, columnIndex);
            }
        }
        catch (OseeCoreException ex) {
            LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }

    public static String getWorldViewOriginatingWorkflowStr(Artifact actionArt) {
        HashSet<String> strs = new HashSet<String>();
        for (IAtsTeamWorkflow team : OriginatingWorkFlowColumnUI.getWorldViewOriginatingWorkflows(actionArt)) {
            strs.add(AtsApiService.get().getColumnService().getColumn((AtsCoreColumnToken)AtsColumnTokensDefault.TeamColumn).getColumnText((IAtsObject)team));
        }
        return Collections.toString((String)";", strs);
    }

    public static Collection<IAtsTeamWorkflow> getWorldViewOriginatingWorkflows(Artifact actionArt) {
        if (AtsApiService.get().getWorkItemService().getTeams((Object)actionArt).size() == 1) {
            return AtsApiService.get().getWorkItemService().getTeams((Object)actionArt);
        }
        ArrayList<IAtsTeamWorkflow> results = new ArrayList<IAtsTeamWorkflow>();
        Date origDate = null;
        for (IAtsTeamWorkflow teamArt : AtsApiService.get().getWorkItemService().getTeams((Object)actionArt)) {
            if (teamArt.isCancelled()) continue;
            Date teamArtDate = AtsApiService.get().getColumnService().getColumnDate((AtsCoreAttrTokColumnToken)AtsColumnTokensDefault.CreatedDateColumn, (IAtsWorkItem)teamArt);
            if (origDate == null || teamArtDate.before(origDate)) {
                results.clear();
                origDate = teamArtDate;
                results.add(teamArt);
                continue;
            }
            if (!origDate.equals(teamArtDate)) continue;
            results.add(teamArt);
        }
        return results;
    }
}

