/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.IAtsXViewerPreComputedColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class RelatedArtifactChangedColumnUI
extends XViewerAtsColumn
implements IAtsXViewerPreComputedColumn {
    public static RelatedArtifactChangedColumnUI instance = new RelatedArtifactChangedColumnUI();
    private final Map<IAtsTeamWorkflow, BranchToken> teamWfToDerivedBranch = new HashMap<IAtsTeamWorkflow, BranchToken>();

    public static RelatedArtifactChangedColumnUI getInstance() {
        return instance;
    }

    private RelatedArtifactChangedColumnUI() {
        super("ats.column.RelatedArtifactChangedColumn", "Related Artifact Changed", 75, XViewerAlign.Left, false, SortDataType.String, false, "Committed - baseline/committed branch \nUnmodified - Related artifact has not changed \n<date> - Related artifact has been modified after task at the specified date \nEmpty - There is no related artifact");
    }

    public RelatedArtifactChangedColumnUI copy() {
        RelatedArtifactChangedColumnUI newXCol = new RelatedArtifactChangedColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        for (Object object : objects) {
            String value = "";
            try {
                Artifact refArt;
                if (!(object instanceof TaskArtifact)) {
                    return;
                }
                TaskArtifact task = (TaskArtifact)((Object)object);
                ArtifactId refArtId = (ArtifactId)AtsApiService.get().getQueryServiceIde().getArtifact(object).getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.TaskToChangedArtifactReference, (Object)ArtifactId.SENTINEL);
                if (refArtId.isInvalid()) {
                    return;
                }
                TeamWorkFlowArtifact teamWf = task.getParentTeamWorkflow();
                BranchToken refBranch = this.teamWfToDerivedBranch.get((Object)teamWf);
                if (refBranch == null) {
                    TeamWorkFlowArtifact reqWf = (TeamWorkFlowArtifact)AtsApiService.get().getRelationResolver().getRelatedOrNull((IAtsObject)teamWf, AtsRelationTypes.Derive_From);
                    if (reqWf == null) {
                        return;
                    }
                    refBranch = reqWf.getWorkingBranch();
                    if (refBranch.isInvalid()) {
                        return;
                    }
                    this.teamWfToDerivedBranch.put(teamWf, refBranch);
                }
                if ((refArt = AtsApiService.get().getQueryServiceIde().getArtifact(refArtId, (BranchId)refBranch)) != null) {
                    value = refArt.isDeleted() ? "Deleted" : (BranchManager.getState((BranchId)refBranch).isCommitted() || BranchManager.getType((BranchId)refBranch).isBaselineBranch() ? "Commited" : (refArt.getLastModified().after(AtsApiService.get().getQueryServiceIde().getArtifact(object).getLastModified()) ? refArt.getLastModified().toString() : "Unmodified"));
                }
            }
            catch (OseeCoreException ex) {
                value = LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
            Long key = this.getKey(object);
            preComputedValueMap.put(key, value);
        }
    }
}

