/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column.signby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.config.ColumnAlign;
import org.eclipse.osee.ats.api.config.MultiEdit;
import org.eclipse.osee.ats.api.config.Show;
import org.eclipse.osee.ats.api.util.ColumnType;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.signby.XAbstractSignByAndDateButton;
import org.eclipse.osee.ats.ide.util.widgets.signby.XSignByAndDateWidget;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsCoreCodeXColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractSignByAndDateColumnUI
extends XViewerAtsCoreCodeXColumn {
    protected final AttributeTypeToken dateAttrType;
    protected final AttributeTypeToken byAttrType;
    private final AttributeTypeToken attrType1;

    public AbstractSignByAndDateColumnUI(AttributeTypeToken attrType1, AttributeTypeToken attrType2) {
        super(new AtsCoreCodeColumnToken(attrType1.getName(), attrType1.getUnqualifiedName(), 40, attrType1.isDate() ? ColumnType.Date : ColumnType.String, ColumnAlign.Left, Show.No, MultiEdit.Yes, ""), AtsApiService.get());
        this.attrType1 = attrType1;
        this.dateAttrType = attrType1.isDate() ? attrType1 : attrType2;
        this.byAttrType = attrType1.isDate() ? attrType2 : attrType1;
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block4: {
            IAtsWorkItem workItem;
            Artifact useArt;
            block6: {
                block5: {
                    if (!(treeItem.getData() instanceof Artifact)) break block4;
                    useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                    if (useArt instanceof IAtsWorkItem) break block5;
                    AWorkbench.popup((String)"Invalid Selection", (String)"Column [%s] is not valid for selected", (Object[])new Object[]{treeColumn.getText()});
                    return false;
                }
                workItem = (IAtsWorkItem)useArt;
                if (AbstractSignByAndDateColumnUI.isAuthorized(Arrays.asList(workItem), this.byAttrType)) break block6;
                return false;
            }
            try {
                XSignByAndDateWidget widget = new XSignByAndDateWidget();
                widget.setAttributeType(this.byAttrType);
                widget.setAttributeType2(this.dateAttrType);
                widget.setArtifact((Artifact)workItem.getStoreObject());
                widget.handleSelection();
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                xViewer.update((Object)useArt, null);
                return true;
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean promptChange(IAtsWorkItem workItem, AttributeTypeToken byAttrType, AttributeTypeToken dateAttrType, AtsApi atsApi) {
        return AbstractSignByAndDateColumnUI.promptChange(Collections.singleton(workItem), byAttrType, dateAttrType, atsApi);
    }

    public static boolean promptChange(final Collection<IAtsWorkItem> workItems, final AttributeTypeToken byAttrType, final AttributeTypeToken dateAttrType, AtsApi atsApi) {
        block3: {
            if (AbstractSignByAndDateColumnUI.isAuthorized(workItems, byAttrType)) break block3;
            return false;
        }
        try {
            final int res = MessageDialog.open((int)3, (Shell)Displays.getActiveShell(), (String)byAttrType.getUnqualifiedName(), (String)byAttrType.getUnqualifiedName(), (int)0, (String[])new String[]{"Ok", "Cancel", "Clear"});
            Job signJob = new Job("Set " + byAttrType.getUnqualifiedName()){

                protected IStatus run(IProgressMonitor monitor) {
                    ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
                    for (IAtsWorkItem workItem : workItems) {
                        artifacts.add((Artifact)workItem.getStoreObject());
                    }
                    if (res == 2) {
                        XAbstractSignByAndDateButton.setSigned(artifacts, (AttributeTypeId)dateAttrType, (AttributeTypeId)byAttrType, byAttrType.getUnqualifiedName(), false);
                    } else if (res == 0) {
                        XAbstractSignByAndDateButton.setSigned(artifacts, (AttributeTypeId)dateAttrType, (AttributeTypeId)byAttrType, byAttrType.getUnqualifiedName(), true);
                    }
                    return Status.OK_STATUS;
                }
            };
            Operations.scheduleJob((Job)signJob, (boolean)false, (int)20, null);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return true;
    }

    private static boolean isAuthorized(Collection<IAtsWorkItem> workItems, AttributeTypeToken byAttrType) {
        for (IAtsWorkItem workItem : workItems) {
            XResultData rd = new XResultData();
            for (IAtsWorkItemHook wiHook : AtsApiService.get().getWorkItemService().getWorkItemHooks()) {
                wiHook.isModifiableAttribute(workItem.getArtifactToken(), byAttrType, rd);
            }
            if (!rd.isErrors()) continue;
            XResultDataUI.report((XResultData)rd, (String)"Unable to Sign");
            return false;
        }
        return true;
    }

    @Override
    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        block3: {
            try {
                if (element instanceof IAtsWorkItem) break block3;
                return "";
            }
            catch (OseeCoreException ex) {
                return LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
        }
        IAtsWorkItem workItem = (IAtsWorkItem)element;
        return this.getText((Artifact)workItem.getStoreObject(), this.attrType1);
    }

    private String getText(Artifact artifact, AttributeTypeToken attrType1) {
        String result = "";
        if (artifact.isAttributeTypeValid((AttributeTypeId)attrType1)) {
            if (attrType1.isDate()) {
                Date date = (Date)artifact.getSoleAttributeValue((AttributeTypeId)attrType1, null);
                if (date != null) {
                    result = DateUtil.getDateNow((Date)date, (String)"MM/dd/yyyy hh:mm a");
                }
            } else {
                User user = UserManager.getUserByArtId((long)((Long)artifact.getSoleAttributeValue((AttributeTypeId)attrType1, (Object)SystemUser.UnAssigned.getId())));
                if (!user.equals((Object)SystemUser.UnAssigned)) {
                    return user.getName();
                }
            }
        }
        return result;
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
            for (TreeItem item : treeItems) {
                Artifact art;
                if (!(item.getData() instanceof IAtsWorkItem) || !((art = AtsApiService.get().getQueryServiceIde().getArtifact(item)) instanceof IAtsWorkItem)) continue;
                workItems.add((IAtsWorkItem)art);
            }
            if (workItems.isEmpty()) {
                AWorkbench.popup((String)"Invalid Selection", (String)"Column [%s] is not valid for selected", (Object[])new Object[]{treeColumn.getText()});
                return;
            }
            AbstractSignByAndDateColumnUI.promptChange(workItems, this.byAttrType, this.dateAttrType, (AtsApi)AtsApiService.get());
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

