/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionDialog;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorProvider;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorTab;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.table.IResultsXViewerRow;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsEditorTableTab;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsXViewerRow;

public class ParallelConfigurationView
extends XNavigateItemAction {
    public static final String TITLE = "Parallel Configuration View";

    public ParallelConfigurationView() {
        super(TITLE, (OseeImage)AtsImage.VERSION, new XNavItemCat[]{AtsNavigateViewItems.ATS_VERSIONS});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) throws Exception {
        TeamDefinitionDialog dialog = new TeamDefinitionDialog(TITLE, "Select Team");
        dialog.setMultiSelect(false);
        Collection teamDefs = AtsApiService.get().getTeamDefinitionService().getTeamDefHoldingVersions();
        dialog.setInput(teamDefs);
        if (dialog.open() == 0) {
            final IAtsTeamDefinition teamDef = (IAtsTeamDefinition)dialog.getSelectedFirst();
            ResultsEditor.open((IResultsEditorProvider)new IResultsEditorProvider(){
                private List<IResultsEditorTab> tabs;

                public String getEditorName() {
                    return String.format("%s - %s", ParallelConfigurationView.TITLE, teamDef.toStringWithId());
                }

                public List<IResultsEditorTab> getResultsEditorTabs() {
                    if (this.tabs == null) {
                        AtsApiService.get().getVersionService().getVersions(teamDef);
                        this.tabs = new LinkedList<IResultsEditorTab>();
                        this.tabs.add(ParallelConfigurationView.this.createDataTab(teamDef));
                    }
                    return this.tabs;
                }
            });
        }
    }

    private IResultsEditorTab createDataTab(IAtsTeamDefinition teamDef) {
        ArrayList<VersionRow> rows = new ArrayList<VersionRow>();
        for (IAtsVersion ver : AtsApiService.get().getVersionService().getVersions(teamDef)) {
            rows.add(new VersionRow(ver, null));
        }
        List<XViewerColumn> columns = Arrays.asList(new XViewerColumn(Columns.AtsVersion.name(), Columns.AtsVersion.name(), 260, XViewerAlign.Left, true, SortDataType.String, false, ""), new XViewerColumn(Columns.Branch.name(), Columns.Branch.name(), 260, XViewerAlign.Left, true, SortDataType.String, false, ""), new XViewerColumn(Columns.AllowCreate.name(), Columns.AllowCreate.name(), 126, XViewerAlign.Left, true, SortDataType.String, false, ""), new XViewerColumn(Columns.AllowCommit.name(), Columns.AllowCommit.name(), 126, XViewerAlign.Left, true, SortDataType.String, false, ""), new XViewerColumn(Columns.Released.name(), Columns.Released.name(), 126, XViewerAlign.Left, true, SortDataType.String, false, ""), new XViewerColumn(Columns.ArtId.name(), Columns.ArtId.name(), 126, XViewerAlign.Left, true, SortDataType.Long, false, ""));
        return new ResultsEditorTableTab("Versions", columns, rows);
    }

    private static enum Columns {
        AtsVersion,
        Branch,
        AllowCreate,
        AllowCommit,
        Released,
        ArtId;

    }

    public static class VersionRow
    extends ResultsXViewerRow {
        private final IAtsVersion version;
        private final VersionRow parent;

        public VersionRow(IAtsVersion version, VersionRow parent) {
            this.version = version;
            this.parent = parent;
            this.setData(version.getArtifactToken());
            this.values.add(version.getName());
            BranchId baselineBranch = version.getBaselineBranch();
            if (baselineBranch.isValid()) {
                this.values.add(BranchManager.getBranchName((BranchId)baselineBranch));
            } else {
                this.values.add("");
            }
            this.values.add(String.valueOf(version.isAllowCreateBranch()));
            this.values.add(String.valueOf(version.isAllowCommitBranch()));
            this.values.add(String.valueOf(version.isReleased()));
            this.values.add(String.valueOf(version.getIdString()));
        }

        public boolean hasChildren() {
            return this.getChildren().size() > 0;
        }

        public Collection<IResultsXViewerRow> getChildren() {
            ArrayList<IResultsXViewerRow> rows = new ArrayList<IResultsXViewerRow>();
            for (IAtsVersion version : AtsApiService.get().getVersionService().getParallelVersions(this.version)) {
                rows.add((IResultsXViewerRow)new VersionRow(version, this));
            }
            return rows;
        }

        public IResultsXViewerRow getParent() {
            return this.parent;
        }
    }
}

