/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.bit;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.JaxTeamWorkflow;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactData;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactDatas;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.WfeAbstractTab;
import org.eclipse.osee.ats.ide.editor.tab.bit.WfeBitToolbar;
import org.eclipse.osee.ats.ide.editor.tab.bit.XBitContentProvider;
import org.eclipse.osee.ats.ide.editor.tab.bit.XBitLabelProvider;
import org.eclipse.osee.ats.ide.editor.tab.bit.XBitViewer;
import org.eclipse.osee.ats.ide.editor.tab.bit.XBitXViewerFactory;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactTopicEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WfeBitTab
extends WfeAbstractTab
implements IArtifactEventListener,
IArtifactTopicEventListener {
    private Composite bodyComp;
    private ScrolledForm scrolledForm;
    public static final String ID = "ats.bit.tab";
    protected final IAtsTeamWorkflow teamWf;
    protected XBitViewer xViewer;
    protected WfeBitToolbar toolBar;
    protected Label messageLabel;
    protected BuildImpactDatas bids;
    protected AtsApi atsApi;
    private XBitXViewerFactory xBitXViewerFactory;
    private final Set<ArtifactToken> expanded = new HashSet<ArtifactToken>();

    public WfeBitTab(WorkflowEditor editor, IAtsTeamWorkflow teamWf) {
        super(editor, ID, (IAtsWorkItem)teamWf, "Build Impact Table");
        this.teamWf = teamWf;
        this.atsApi = AtsApiService.get();
        OseeEventManager.addListener((IEventListener)this);
    }

    protected void setXBitXViewerFactoryAms(XBitXViewerFactory xBitXViewerFactory) {
        this.xBitXViewerFactory = xBitXViewerFactory;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.scrolledForm = managedForm.getForm();
        try {
            this.bodyComp = this.scrolledForm.getBody();
            GridLayout gridLayout = new GridLayout(1, true);
            this.bodyComp.setLayout((Layout)gridLayout);
            GridData gd = new GridData(16384, 16384, true, true);
            this.bodyComp.setLayoutData((Object)gd);
            Composite mainComp = new Composite(this.bodyComp, 2048);
            GridData gd2 = new GridData(4, 4, true, true);
            gd2.widthHint = 100;
            gd2.heightHint = 100;
            mainComp.setLayoutData((Object)gd2);
            mainComp.setLayout((Layout)ALayout.getZeroMarginLayout());
            managedForm.getToolkit().paintBordersFor(mainComp);
            this.messageLabel = new Label(mainComp, 0);
            this.messageLabel.setLayoutData((Object)new GridData(768));
            if (this.atsApi.getUserService().isAtsAdmin()) {
                this.messageLabel.setText("Debug Here");
            }
            this.messageLabel.setForeground(Displays.getSystemColor((int)3));
            managedForm.getToolkit().adapt((Control)this.messageLabel, true, true);
            this.xViewer = new XBitViewer(mainComp, 67586, (IXViewerFactory)(this.xBitXViewerFactory != null ? this.xBitXViewerFactory : new XBitXViewerFactory()), (IDirtiableEditor)this.editor, this.teamWf);
            this.xViewer.setContentProvider((IContentProvider)new XBitContentProvider(this.xViewer));
            this.xViewer.setLabelProvider((IBaseLabelProvider)new XBitLabelProvider(this.xViewer));
            this.xViewer.getTree().setLayoutData((Object)new GridData(1808));
            this.getSite().setSelectionProvider((ISelectionProvider)this.xViewer);
            final WfeBitTab fWfeBitTab = this;
            this.xViewer.getTree().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    OseeEventManager.removeListener((IEventListener)fWfeBitTab);
                }
            });
            this.refresh();
            this.updateTitleBar(managedForm);
            this.createToolbar(managedForm);
            FormsUtil.addHeadingGradient((FormToolkit)this.editor.getToolkit(), (ScrolledForm)managedForm.getForm(), (boolean)true);
            managedForm.reflow(true);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    @Override
    public void refresh() {
        if (this.xViewer == null || this.xViewer.getTree() == null || this.xViewer.getTree().isDisposed()) {
            return;
        }
        Job loadJob = new Job("Loading Build Impacts"){

            protected IStatus run(IProgressMonitor monitor) {
                WfeBitTab.this.bids = WfeBitTab.this.atsApi.getServerEndpoints().getActionEndpoint().getBids(WfeBitTab.this.teamWf.getAtsId());
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!Widgets.isAccessible((Widget)(this).WfeBitTab.this.bodyComp)) {
                            return;
                        }
                        if ((this).WfeBitTab.this.bids.getResults().isErrors()) {
                            (this).WfeBitTab.this.xViewer.setLoading(false);
                            (this).WfeBitTab.this.xViewer.getStatusLabel().setText((this).WfeBitTab.this.bids.getResults().toString());
                            return;
                        }
                        WfeBitTab.this.storeExpandState();
                        (this).WfeBitTab.this.xViewer.setBids((this).WfeBitTab.this.bids);
                        (this).WfeBitTab.this.xViewer.loadTable();
                        WfeBitTab.this.restoreExpandState();
                        (this).WfeBitTab.this.xViewer.setLoading(false);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        Operations.scheduleJob((Job)loadJob, (boolean)true, (int)20, null);
    }

    private void storeExpandState() {
        if (!Widgets.isAccessible((Widget)this.bodyComp)) {
            return;
        }
        this.expanded.clear();
        for (TreeItem item : this.xViewer.getVisibleItems()) {
            if (!item.getExpanded()) continue;
            BuildImpactData bid = (BuildImpactData)item.getData();
            this.expanded.add(bid.getBidArt());
        }
    }

    private void restoreExpandState() {
        if (!Widgets.isAccessible((Widget)this.bodyComp)) {
            return;
        }
        for (TreeItem item : this.xViewer.getVisibleItems()) {
            BuildImpactData bid = (BuildImpactData)item.getData();
            if (!this.expanded.contains(bid.getBidArt())) continue;
            this.xViewer.expandToLevel(bid, 2);
        }
    }

    @Override
    public IToolBarManager createToolbar(IManagedForm managedForm) {
        this.toolBar = new WfeBitToolbar(this.scrolledForm, this.xViewer, this.editor, this.teamWf);
        this.toolBar.build();
        return super.createToolbar(managedForm);
    }

    public XBitViewer getxViewer() {
        return this.xViewer;
    }

    public List<? extends IEventFilter> getEventFilters() {
        return AtsUtilClient.getAtsObjectEventFilters();
    }

    public List<? extends ITopicEventFilter> getTopicEventFilters() {
        return AtsUtilClient.getAtsTopicObjectEventFilters();
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        if (this.editor.getBitTab() == null) {
            return;
        }
        boolean refresh = false;
        for (Artifact art : artifactEvent.getCacheArtifacts(EventModType.values())) {
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.BuildImpactData})) {
                refresh = true;
                break;
            }
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow}) || !this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)art, AtsRelationTypes.BuildImpactDataToTeamWf_Bid).isValid()) continue;
            refresh = true;
            break;
        }
        if (refresh) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    WfeBitTab.this.refresh();
                }
            });
        }
    }

    public void handleArtifactTopicEvent(ArtifactTopicEvent artifactTopicEvent, Sender sender) {
        if (this.editor.getBitTab() == null) {
            return;
        }
        boolean refresh = false;
        for (Artifact art : artifactTopicEvent.getCacheArtifacts(EventModType.values())) {
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.BuildImpactData})) {
                refresh = true;
                break;
            }
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow}) || !this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)art, AtsRelationTypes.BuildImpactDataToTeamWf_Bid).isValid()) continue;
            refresh = true;
            break;
        }
        if (refresh) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    WfeBitTab.this.refresh();
                }
            });
        }
    }

    public ArtifactTypeToken getBuildImpactDataType() {
        return AtsArtifactTypes.BuildImpactData;
    }

    public void creatingSibling(IAtsTeamWorkflow teamWf, JaxTeamWorkflow jTeamWf, IAtsActionableItem ai) {
    }
}

