/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.action.ViewTableReportAction;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.workdef.RuleEventType;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.actions.AddTaskAction;
import org.eclipse.osee.ats.ide.actions.DeleteTasksAction;
import org.eclipse.osee.ats.ide.actions.IAtsTaskArtifactProvider;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.actions.ImportTasksViaSimpleList;
import org.eclipse.osee.ats.ide.actions.ImportTasksViaSpreadsheet;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsTaskEditorAction;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsTaskEditorSelected;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsWorldEditorSelectedAction;
import org.eclipse.osee.ats.ide.config.AtsBulkLoad;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.WfeAbstractTab;
import org.eclipse.osee.ats.ide.editor.tab.task.CreateManualTaskPlaceholder;
import org.eclipse.osee.ats.ide.editor.tab.task.CreateManualTaskSet;
import org.eclipse.osee.ats.ide.export.AtsExportAction;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.task.IXTaskViewer;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskComposite;
import org.eclipse.osee.ats.ide.workflow.task.TaskXViewerFactory;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.IMenuActionProvider;
import org.eclipse.osee.ats.ide.world.IWorldEditor;
import org.eclipse.osee.ats.ide.world.IWorldEditorProvider;
import org.eclipse.osee.ats.ide.world.IWorldViewerEventHandler;
import org.eclipse.osee.ats.ide.world.WorldAssigneeFilter;
import org.eclipse.osee.ats.ide.world.WorldCompletedFilter;
import org.eclipse.osee.ats.ide.world.WorldComposite;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.ats.ide.world.WorldXViewerEventManager;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactTopicEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.action.RefreshAction;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.IOseeTreeReportProvider;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.progress.UIJob;

public class WfeTasksTab
extends WfeAbstractTab
implements IArtifactEventListener,
IArtifactTopicEventListener,
IWorldEditor,
ISelectedAtsArtifacts,
IWorldViewerEventHandler,
IMenuActionProvider,
IXTaskViewer,
IOseeTreeReportProvider,
IAtsTaskArtifactProvider {
    private IManagedForm managedForm;
    private ScrolledForm scrolledForm;
    private TaskComposite taskComposite;
    public static final String ID = "ats.tasks.tab";
    private final WorkflowEditor editor;
    private static Map<Long, Integer> idToScrollLocation = new HashMap<Long, Integer>();
    private final ReloadJobChangeAdapter reloadAdapter;
    private final AtsApiIde client;
    private final IAtsTeamWorkflow teamWf;
    private final TeamWorkFlowArtifact teamWfArt;
    private final WorldCompletedFilter worldCompletedFilter = new WorldCompletedFilter();
    private WorldAssigneeFilter worldAssigneeFilter = null;
    private Action filterCompletedAction;
    private Action filterMyAssigneeAction;
    private final Control control = null;

    public WfeTasksTab(WorkflowEditor editor, IAtsTeamWorkflow teamWf, AtsApiIde client) {
        super(editor, ID, (IAtsWorkItem)teamWf, "Tasks");
        this.editor = editor;
        this.teamWf = teamWf;
        this.client = client;
        this.reloadAdapter = new ReloadJobChangeAdapter(editor);
        this.teamWfArt = (TeamWorkFlowArtifact)teamWf.getStoreObject();
        this.refreshTabName();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.managedForm = managedForm;
        this.scrolledForm = managedForm.getForm();
        final WfeTasksTab listener = this;
        try {
            this.scrolledForm.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WfeTasksTab.this.storeScrollLocation();
                    OseeEventManager.removeListener((IEventListener)listener);
                }
            });
            this.bodyComp = this.scrolledForm.getBody();
            GridLayout gridLayout = new GridLayout(1, true);
            this.bodyComp.setLayout((Layout)gridLayout);
            GridData gd = new GridData(16384, 16384, false, false);
            this.bodyComp.setLayoutData((Object)gd);
            this.updateTitleBar(managedForm);
            FormsUtil.addHeadingGradient((FormToolkit)this.editor.getToolkit(), (ScrolledForm)managedForm.getForm(), (boolean)true);
            this.setLoading(true);
            this.refreshData();
            WorldXViewerEventManager.add(this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        OseeEventManager.addListener((IEventListener)this);
    }

    @Override
    public void showBusy(boolean busy) {
        super.showBusy(busy);
        if (this.getManagedForm() != null && Widgets.isAccessible((Widget)this.getManagedForm().getForm())) {
            this.getManagedForm().getForm().getForm().setBusy(busy);
        }
    }

    public void refreshData() {
        if (Widgets.isAccessible((Widget)this.bodyComp)) {
            List<IOperation> ops = AtsBulkLoad.getConfigLoadingOperations();
            IOperation operation = Operations.createBuilder((String)"Load Tasks Tab").addAll(ops).build();
            Operations.executeAsJob((IOperation)operation, (boolean)false, (int)30, (IJobChangeListener)this.reloadAdapter);
        }
    }

    private boolean createMembersBody() {
        if (!Widgets.isAccessible((Widget)this.taskComposite)) {
            this.taskComposite = new TaskComposite(this, this, (IXViewerFactory)new TaskXViewerFactory(this), this.bodyComp, 2048, (IDirtiableEditor)this.editor, this.teamWf.isInWork(), this.teamWf);
            this.taskComposite.getWorldXViewer().addMenuActionProvider(this);
            this.getSite().setSelectionProvider((ISelectionProvider)this.taskComposite.getWorldXViewer());
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 100;
            gd.heightHint = 100;
            this.taskComposite.setLayoutData(gd);
            this.getSite().setSelectionProvider((ISelectionProvider)this.taskComposite.getWorldXViewer());
            this.reload();
            return true;
        }
        return false;
    }

    public void reload() {
        if (this.isTableDisposed()) {
            return;
        }
        String getLoadingString = String.format("Loading Tasks for %s", new Object[]{this.editor.getWorkItem()});
        Job job = new Job(getLoadingString){

            protected IStatus run(IProgressMonitor monitor) {
                if (WfeTasksTab.this.isTableDisposed()) {
                    return Status.OK_STATUS;
                }
                try {
                    final Collection<TaskArtifact> taskArts = WfeTasksTab.this.getTaskArts();
                    Displays.ensureInDisplayThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (WfeTasksTab.this.isTableDisposed()) {
                                return;
                            }
                            (this).WfeTasksTab.this.taskComposite.load("Tasks", (Collection<? extends Artifact>)taskArts, (CustomizeData)null, XNavigateComposite.TableLoadOption.None);
                            WfeTasksTab.this.refreshTabName();
                        }
                    });
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    return new Status(4, "org.eclipse.osee.ats.ide", String.format("Exception loading tasks for %s", WfeTasksTab.this.teamWf.toStringWithId()), (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)false);
    }

    private boolean isTableDisposed() {
        return this.taskComposite == null || this.taskComposite.getXViewer() == null || this.taskComposite.getXViewer().getTree() == null || this.taskComposite.getXViewer().getTree().isDisposed();
    }

    private void jumptoScrollLocation() {
        Integer selection = idToScrollLocation.get(this.teamWf.getId());
        if (selection != null) {
            JumpScrollbarJob job = new JumpScrollbarJob("");
            job.schedule(500L);
        }
    }

    public void dispose() {
        if (this.taskComposite != null) {
            this.taskComposite.dispose();
        }
    }

    private void storeScrollLocation() {
        if (this.managedForm != null && this.managedForm.getForm() != null) {
            Integer selection = this.managedForm.getForm().getVerticalBar().getSelection();
            idToScrollLocation.put(this.teamWf.getId(), selection);
        }
    }

    @Override
    public void refresh() {
        Thread reload = new Thread("Reload Tasks"){

            @Override
            public void run() {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (Widgets.isAccessible((Widget)(this).WfeTasksTab.this.taskComposite)) {
                            Collection<TaskArtifact> tasks = WfeTasksTab.this.getTaskArts();
                            (this).WfeTasksTab.this.taskComposite.getXViewer().setInput(tasks);
                            WfeTasksTab.this.refreshTabName();
                        }
                    }
                });
            }
        };
        reload.start();
    }

    @Override
    public IToolBarManager createToolbar(IManagedForm managedForm) {
        IToolBarManager toolBarMgr = this.scrolledForm.getToolBarManager();
        toolBarMgr.removeAll();
        toolBarMgr.add((IAction)new AddTaskAction(this.taskComposite));
        toolBarMgr.add((IAction)new DeleteTasksAction(this));
        toolBarMgr.add((IContributionItem)new Separator());
        if (this.getWorldXViewer() != null) {
            toolBarMgr.add((IAction)this.getWorldXViewer().getCustomizeAction());
        }
        toolBarMgr.add((IContributionItem)new Separator());
        toolBarMgr.add((IAction)new ViewTableReportAction((XViewer)this.taskComposite.getXViewer()));
        toolBarMgr.add((IContributionItem)new Separator());
        toolBarMgr.add((IAction)new OpenNewAtsTaskEditorAction(this.taskComposite));
        toolBarMgr.add((IAction)new OpenNewAtsTaskEditorSelected(this.taskComposite));
        toolBarMgr.add((IAction)new OpenNewAtsWorldEditorSelectedAction(this.taskComposite));
        toolBarMgr.add((IContributionItem)new Separator());
        this.createDropDownMenuActions();
        toolBarMgr.add((IAction)new DropDownAction());
        toolBarMgr.add((IContributionItem)new Separator());
        super.createToolbar(managedForm);
        this.scrolledForm.updateToolBar();
        return toolBarMgr;
    }

    @Override
    public void addRefreshAction(IToolBarManager toolBarMgr) {
        toolBarMgr.add((IAction)new RefreshAction(new RefreshAction.IRefreshActionHandler(){

            public void refreshActionHandler() {
                Thread reload = new Thread(){

                    @Override
                    public void run() {
                        HashSet<TeamWorkFlowArtifact> arts = new HashSet<TeamWorkFlowArtifact>();
                        arts.add((this).WfeTasksTab.this.teamWfArt);
                        arts.addAll((this).WfeTasksTab.this.teamWfArt.getRelatedArtifacts(AtsRelationTypes.TeamWfToTask_Task));
                        ArtifactQuery.reloadArtifacts(arts);
                    }
                };
                reload.start();
            }
        }));
    }

    protected void createDropDownMenuActions() {
        try {
            this.worldAssigneeFilter = new WorldAssigneeFilter();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        this.filterCompletedAction = new Action("Filter Out Completed/Cancelled - Ctrl-F", 2){

            public void run() {
                if (WfeTasksTab.this.filterCompletedAction.isChecked()) {
                    WfeTasksTab.this.taskComposite.getTaskXViewer().addFilter(WfeTasksTab.this.worldCompletedFilter);
                } else {
                    WfeTasksTab.this.taskComposite.getTaskXViewer().removeFilter(WfeTasksTab.this.worldCompletedFilter);
                }
                WfeTasksTab.this.updateExtendedStatusString();
                WfeTasksTab.this.taskComposite.getTaskXViewer().refresh();
            }
        };
        this.filterCompletedAction.setToolTipText("Filter Out Completed/Cancelled - Ctrl-F");
        this.filterCompletedAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.GREEN_PLUS));
        this.filterMyAssigneeAction = new Action("Filter My Assignee - Ctrl-G", 2){

            public void run() {
                if (WfeTasksTab.this.filterMyAssigneeAction.isChecked()) {
                    WfeTasksTab.this.taskComposite.getTaskXViewer().addFilter(WfeTasksTab.this.worldAssigneeFilter);
                } else {
                    WfeTasksTab.this.taskComposite.getTaskXViewer().removeFilter(WfeTasksTab.this.worldAssigneeFilter);
                }
                WfeTasksTab.this.updateExtendedStatusString();
                WfeTasksTab.this.taskComposite.getTaskXViewer().refresh();
            }
        };
        this.filterMyAssigneeAction.setToolTipText("Filter My Assignee - Ctrl-G");
        this.filterMyAssigneeAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.USER));
    }

    public void updateExtendedStatusString() {
        this.taskComposite.getTaskXViewer().setExtendedStatusString(String.valueOf(this.filterCompletedAction.isChecked() ? "[Complete/Cancel Filter]" : "") + (this.filterMyAssigneeAction.isChecked() ? "[My Assignee Filter]" : ""));
    }

    public WorldComposite getMembersSection() {
        return this.taskComposite;
    }

    @Override
    public WorldXViewer getWorldXViewer() {
        if (this.taskComposite == null) {
            return null;
        }
        return this.taskComposite.getWorldXViewer();
    }

    @Override
    public void relationsModifed(Collection<Artifact> relModifiedArts, Collection<Artifact> goalMemberReordered, Collection<Artifact> sprintMemberReordered) {
        if (relModifiedArts.contains((Object)this.teamWfArt)) {
            this.refresh();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.editor.isDisposed();
    }

    @Override
    public void updateMenuActionsForTable() {
        MenuManager mm = this.taskComposite.getXViewer().getMenuManager();
        mm.insertBefore("ATS WORLD EDIT", (IContributionItem)new Separator());
    }

    @Override
    public Set<Artifact> getSelectedWorkflowArtifacts() {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (Artifact art : this.taskComposite.getSelectedArtifacts()) {
            if (!(art instanceof AbstractWorkflowArtifact)) continue;
            artifacts.add(art);
        }
        return artifacts;
    }

    @Override
    public List<Artifact> getSelectedAtsArtifacts() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact art : this.taskComposite.getSelectedArtifacts()) {
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AtsArtifact})) continue;
            artifacts.add(art);
        }
        return artifacts;
    }

    @Override
    public List<TaskArtifact> getSelectedTaskArtifacts() {
        ArrayList<TaskArtifact> tasks = new ArrayList<TaskArtifact>();
        for (Artifact art : this.taskComposite.getSelectedArtifacts()) {
            if (!(art instanceof TaskArtifact)) continue;
            tasks.add((TaskArtifact)art);
        }
        return tasks;
    }

    @Override
    public void reflow() {
    }

    @Override
    public void setTableTitle(String title, boolean warning) {
    }

    @Override
    public void reSearch() {
        this.refresh();
    }

    @Override
    public IWorldEditorProvider getWorldEditorProvider() {
        return null;
    }

    @Override
    public void createToolBarPulldown(Menu menu) {
    }

    @Override
    public String getCurrentTitleLabel() {
        return null;
    }

    private Collection<IAtsTask> getTasks() {
        Collection tasks = this.client.getTaskService().getTasks(this.teamWf);
        return tasks;
    }

    public Collection<TaskArtifact> getTaskArts() {
        return Collections.castAll(this.getTasks());
    }

    public void refreshTabName() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public TaskComposite getTaskComposite() {
        return this.taskComposite;
    }

    @Override
    public IAtsTeamWorkflow getTeamWfArt() {
        return this.teamWfArt;
    }

    @Override
    public boolean isTasksEditable() {
        return this.editor.isTasksEditable();
    }

    public String getEditorTitle() {
        try {
            return String.format("Table Report - Tasks for [%s]", this.getTeamWfArt());
        }
        catch (Exception exception) {
            return "Table Report - Tasks";
        }
    }

    public String getReportTitle() {
        return this.getEditorTitle();
    }

    public List<? extends IEventFilter> getEventFilters() {
        return AtsUtilClient.getAtsObjectEventFilters();
    }

    public List<? extends ITopicEventFilter> getTopicEventFilters() {
        return AtsUtilClient.getAtsTopicObjectEventFilters();
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        this.refresh();
    }

    public void handleArtifactTopicEvent(ArtifactTopicEvent artifactTopicEvent, Sender sender) {
        this.refresh();
    }

    @Override
    public List<TaskArtifact> getSelectedArtifacts() {
        return this.taskComposite.getSelectedTaskArtifacts();
    }

    @Override
    public void handleColumnEvents(ArtifactEvent artifactEvent, WorldXViewer worldXViewer) {
    }

    @Override
    public void handleColumnTopicEvents(ArtifactTopicEvent artifactTopicEvent, WorldXViewer worldXViewer) {
    }

    public class DropDownAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;

        public DropDownAction() {
            this.setText("Other");
            this.setMenuCreator(this);
            this.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.GEAR));
            this.addKeyListener();
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            this.addActionToMenu(this.fMenu, WfeTasksTab.this.filterCompletedAction);
            this.addActionToMenu(this.fMenu, WfeTasksTab.this.filterMyAssigneeAction);
            new MenuItem(this.fMenu, 2);
            this.addActionToMenu(this.fMenu, new AtsExportAction(WfeTasksTab.this.taskComposite.getTaskXViewer()));
            try {
                if (WfeTasksTab.this.taskComposite.getIXTaskViewer().isTasksEditable()) {
                    this.addActionToMenu(this.fMenu, new ImportTasksViaSpreadsheet(WfeTasksTab.this.taskComposite.getTeamArt(), null));
                    this.addActionToMenu(this.fMenu, new ImportTasksViaSimpleList(WfeTasksTab.this.taskComposite.getTeamArt(), null));
                    Collection taskSets = AtsApiService.get().getTaskService().getTaskSets(WfeTasksTab.this.teamWf);
                    new MenuItem(this.fMenu, 2);
                    this.addActionToMenu(this.fMenu, new CreateManualTaskPlaceholder("Create Task Set - Instructions"));
                    if (!taskSets.isEmpty()) {
                        for (CreateTasksDefinitionBuilder taskSet : taskSets) {
                            if (taskSet.getCreateTasksDef().getRuleEvent() != RuleEventType.Manual) continue;
                            this.addActionToMenu(this.fMenu, new CreateManualTaskSet(String.format("Create from Task Set [%s]", taskSet.getName()), WfeTasksTab.this.taskComposite.getTeamArt(), taskSet, null));
                        }
                    }
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
            return this.fMenu;
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        protected void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        void clear() {
            this.dispose();
        }

        private void addKeyListener() {
            WfeTasksTab.this.taskComposite.getTaskXViewer().getTree().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                }

                public void keyReleased(KeyEvent event) {
                    if ((event.stateMask & SWT.MODIFIER_MASK) == 262144) {
                        if (event.keyCode == 97) {
                            ((DropDownAction)DropDownAction.this).WfeTasksTab.this.taskComposite.getTaskXViewer().getTree().setSelection(((DropDownAction)DropDownAction.this).WfeTasksTab.this.taskComposite.getTaskXViewer().getTree().getItems());
                        } else if (event.keyCode == 102) {
                            ((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterCompletedAction.setChecked(!((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterCompletedAction.isChecked());
                            ((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterCompletedAction.run();
                        } else if (event.keyCode == 103) {
                            ((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterMyAssigneeAction.setChecked(!((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterMyAssigneeAction.isChecked());
                            ((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterMyAssigneeAction.run();
                        } else if (event.keyCode == 100) {
                            ((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterMyAssigneeAction.setChecked(!((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterMyAssigneeAction.isChecked());
                            ((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterCompletedAction.setChecked(!((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterCompletedAction.isChecked());
                            ((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterCompletedAction.run();
                            ((DropDownAction)DropDownAction.this).WfeTasksTab.this.filterMyAssigneeAction.run();
                        }
                    }
                }
            });
        }
    }

    private class JumpScrollbarJob
    extends Job {
        public JumpScrollbarJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Integer selection = idToScrollLocation.get(((JumpScrollbarJob)JumpScrollbarJob.this).WfeTasksTab.this.teamWf.getId());
                    ScrolledComposite sComp = null;
                    if (((JumpScrollbarJob)JumpScrollbarJob.this).WfeTasksTab.this.control == null || ((JumpScrollbarJob)JumpScrollbarJob.this).WfeTasksTab.this.control.isDisposed()) {
                        return;
                    }
                    Composite parent = ((JumpScrollbarJob)JumpScrollbarJob.this).WfeTasksTab.this.control.getParent();
                    while (parent != null) {
                        if (parent instanceof ScrolledComposite) {
                            sComp = (ScrolledComposite)parent;
                            break;
                        }
                        parent = parent.getParent();
                    }
                    if (sComp != null) {
                        sComp.setOrigin(0, selection.intValue());
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }

    private final class ReloadJobChangeAdapter
    extends JobChangeAdapter {
        private final WorkflowEditor editor;
        boolean firstTime = true;

        private ReloadJobChangeAdapter(WorkflowEditor editor) {
            this.editor = editor;
            WfeTasksTab.this.showBusy(true);
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            UIJob job = new UIJob("Draw Tasks Tab"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (ReloadJobChangeAdapter.this.firstTime) {
                        try {
                            try {
                                if (Widgets.isAccessible((Widget)((ReloadJobChangeAdapter)ReloadJobChangeAdapter.this).WfeTasksTab.this.scrolledForm)) {
                                    WfeTasksTab.this.setLoading(false);
                                    boolean createdAndLoaded = WfeTasksTab.this.createMembersBody();
                                    if (!createdAndLoaded) {
                                        WfeTasksTab.this.reload();
                                    }
                                    WfeTasksTab.this.refreshTabName();
                                    WfeTasksTab.this.createToolbar(((ReloadJobChangeAdapter)ReloadJobChangeAdapter.this).WfeTasksTab.this.managedForm);
                                    WfeTasksTab.this.jumptoScrollLocation();
                                    ((ReloadJobChangeAdapter)ReloadJobChangeAdapter.this).WfeTasksTab.this.scrolledForm.reflow(true);
                                    ReloadJobChangeAdapter.this.editor.onDirtied();
                                }
                                ReloadJobChangeAdapter.this.firstTime = false;
                            }
                            catch (OseeCoreException ex) {
                                WfeTasksTab.this.handleException((Exception)((Object)ex));
                                WfeTasksTab.this.showBusy(false);
                            }
                        }
                        finally {
                            WfeTasksTab.this.showBusy(false);
                        }
                    } else {
                        WfeTasksTab.this.showBusy(false);
                        if (((ReloadJobChangeAdapter)ReloadJobChangeAdapter.this).WfeTasksTab.this.managedForm != null && Widgets.isAccessible((Widget)((ReloadJobChangeAdapter)ReloadJobChangeAdapter.this).WfeTasksTab.this.managedForm.getForm())) {
                            WfeTasksTab.this.refresh();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            Operations.scheduleJob((Job)job, (boolean)false, (int)20, null);
        }
    }
}

