/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.actions.EditActionableItemsAction;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.XFormToolkit;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeActionableItemHeader
extends Composite {
    private Label label;
    private final IAtsWorkItem workItem;

    public WfeActionableItemHeader(Composite parent, XFormToolkit toolkit, IAtsWorkItem workItem, final WorkflowEditor editor) {
        super(parent, 0);
        this.workItem = workItem;
        try {
            final TeamWorkFlowArtifact teamWf = (TeamWorkFlowArtifact)workItem;
            toolkit.adapt((Composite)this);
            this.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 4;
            this.setLayoutData(gd);
            Hyperlink link = toolkit.createHyperlink((Composite)this, "Actionable Items: ", 0);
            link.setToolTipText("Edit Actionable Items for the parent Action (this may add Team Workflows)");
            link.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        if (editor.isDirty()) {
                            editor.doSave(null);
                        }
                        EditActionableItemsAction.editActionableItems(teamWf);
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            });
            this.label = toolkit.createLabel((Composite)this, " ");
            this.refresh();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void refresh() {
        if (this.label.isDisposed()) {
            return;
        }
        TeamWorkFlowArtifact teamWf = (TeamWorkFlowArtifact)this.workItem;
        if (teamWf.getParentAction() == null) {
            this.label.setText("Error: No Parent Action");
            this.label.setForeground(Displays.getSystemColor((int)3));
        } else {
            IAtsAction parentAction = (IAtsAction)teamWf.getParentAction().getStoreObject();
            if (parentAction == null) {
                this.label.setText(" Error: No Parent Action.");
                this.label.setForeground(Displays.getSystemColor((int)3));
            } else if (AtsApiService.get().getActionableItemService().getActionableItems(parentAction).isEmpty()) {
                this.label.setText(" Error: No Actionable Items identified.");
                this.label.setForeground(Displays.getSystemColor((int)3));
            } else {
                StringBuffer sb = new StringBuffer(AtsApiService.get().getActionableItemService().getActionableItemsStr((IAtsWorkItem)teamWf));
                if (AtsApiService.get().getWorkItemService().getTeams((Object)parentAction).size() > 1) {
                    sb.append("         Other: ");
                    for (IAtsTeamWorkflow workflow : AtsApiService.get().getWorkItemService().getTeams((Object)parentAction)) {
                        if (!workflow.notEqual((Id)teamWf)) continue;
                        sb.append(AtsApiService.get().getActionableItemService().getActionableItemsStr((IAtsWorkItem)workflow));
                        sb.append(", ");
                    }
                }
                this.label.setText(sb.toString().replaceFirst(", $", ""));
                this.label.setLayoutData((Object)new GridData(768));
                this.label.setForeground(Displays.getSystemColor((int)2));
            }
        }
        this.label.update();
        this.layout();
    }
}

