/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.note;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNoteType;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.editor.tab.workflow.note.NewStateNoteWizard;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.ui.skynet.widgets.XList;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.ui.PlatformUI;

public class AddStateNoteAction
extends AbstractAtsAction {
    private final AbstractWorkflowArtifact workItem;
    private boolean emulate = false;
    private String selectedState;
    private AtsStateNoteType noteType;
    private String noteText;

    public AddStateNoteAction(AbstractWorkflowArtifact workItem) {
        this.workItem = workItem;
        this.setText("Add State Note");
        this.setToolTipText(this.getText());
    }

    @Override
    public void runWithException() {
        boolean result;
        ArrayList<String> stateNames = new ArrayList<String>();
        HashMap<String, String> selectedToStateName = new HashMap<String, String>();
        for (StateDefinition stateDefinition : AtsApiService.get().getWorkDefinitionService().getStatesOrderedByOrdinal(this.workItem.getWorkDefinition())) {
            String displayName = "\"" + stateDefinition.getName() + "\" State";
            stateNames.add(displayName);
            selectedToStateName.put(displayName, stateDefinition.getName());
        }
        if (this.emulate ? !(result = this.performEmulate()) : !(result = this.performUi(stateNames))) {
            return;
        }
        String state = "";
        if (!this.selectedState.startsWith(String.valueOf(this.workItem.getName()) + " - ")) {
            state = (String)selectedToStateName.get(this.selectedState);
        }
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getText());
        AtsApiService.get().getWorkItemService().getStateNoteService().addNote((IAtsWorkItem)this.workItem, this.noteType, state, this.noteText, changes);
        changes.execute();
    }

    private boolean performEmulate() {
        this.selectedState = "Endorse";
        this.noteType = AtsStateNoteType.Info;
        this.noteText = "this is the comment";
        return true;
    }

    private boolean performUi(ArrayList<String> stateNames) {
        NewStateNoteWizard noteWizard = new NewStateNoteWizard(stateNames);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)noteWizard);
        dialog.create();
        if (dialog.open() == 0) {
            this.selectedState = ((XList.XListItem)noteWizard.mainPage.stateList.getSelected().iterator().next()).getName();
            this.noteType = AtsStateNoteType.valueOf((String)((XList.XListItem)noteWizard.mainPage.typeList.getSelected().iterator().next()).getName());
            this.noteText = noteWizard.mainPage.noteText.get();
            return true;
        }
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.NEW_NOTE);
    }

    public void setEmulateUi(boolean emulate) {
        this.emulate = emulate;
    }
}

