/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.section.goal;

import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class AbstractWebExportAction
extends AbstractAtsAction {
    protected final GoalArtifact goalArt;
    protected final WorkflowEditor editor;

    public AbstractWebExportAction(String string, GoalArtifact goalArt, WorkflowEditor editor, OseeImage image) {
        super(string, ImageManager.getImageDescriptor((OseeImage)image));
        this.goalArt = goalArt;
        this.editor = editor;
    }

    protected String validateAndGetCustomizeDataGuid() {
        String custGuid = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((ArtifactId)this.goalArt, (AttributeTypeToken)AtsAttributeTypes.WorldResultsCustId, (Object)"");
        if (Strings.isInValid((String)custGuid)) {
            AWorkbench.popup((String)"Error", (String)"No customization id (WorldResultsCustId) configured for Goal %s", (Object[])new Object[]{this.goalArt.getName()});
            return null;
        }
        CustomizeData customization = AtsApiService.get().getStoreService().getCustomizationByGuid(custGuid);
        if (customization == null) {
            AWorkbench.popup((String)"Error", (String)"No customization found with id [%s]\n\nNote: Customization must be saved.", (Object[])new Object[]{custGuid});
            return null;
        }
        return custGuid;
    }
}

