/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.util;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.core.workflow.transition.TransitionStatusData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TransitionStatusDialog;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;

public class WfePromptChangeStatus {
    private final Collection<? extends AbstractWorkflowArtifact> awas;

    public WfePromptChangeStatus(AbstractWorkflowArtifact sma) {
        this(Arrays.asList(sma));
    }

    public WfePromptChangeStatus(Collection<? extends AbstractWorkflowArtifact> awas) {
        this.awas = awas;
    }

    public static boolean promptChangeStatus(Collection<? extends AbstractWorkflowArtifact> awas, boolean persist) {
        WfePromptChangeStatus promptChangeStatus = new WfePromptChangeStatus(awas);
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Prompt Change Status");
        boolean result = promptChangeStatus.promptChangeStatus(changes).isTrue();
        if (result) {
            changes.execute();
        }
        return result;
    }

    public static Result isValidToChangeStatus(Collection<? extends AbstractWorkflowArtifact> awas) {
        for (AbstractWorkflowArtifact abstractWorkflowArtifact : awas) {
            TaskArtifact taskArt;
            if (abstractWorkflowArtifact.isCancelled()) {
                String error = "Can not status a cancelled " + abstractWorkflowArtifact.getArtifactTypeName() + ".\n\nTransition out of cancelled first.";
                return new Result(error);
            }
            if (!abstractWorkflowArtifact.isTypeEqual((ArtifactTypeId)AtsArtifactTypes.Task) || !(taskArt = (TaskArtifact)abstractWorkflowArtifact).isRelatedToUsed() || taskArt.isRelatedToParentWorkflowCurrentState()) continue;
            return new Result(String.format("Task work must be done in \"Related to State\" of parent workflow for Task titled: \"%s\".\n\nTask work configured to be done in parent's \"%s\" state.\nParent workflow is currently in \"%s\" state.\n\nEither transition parent workflow or change Task's \"Related to State\" to perform task work.", taskArt.getName(), taskArt.getSoleAttributeValueAsString((AttributeTypeToken)AtsAttributeTypes.RelatedToState, "unknown"), taskArt.getParentAWA().getCurrentStateName()));
        }
        return Result.TrueResult;
    }

    public Result promptChangeStatus(IAtsChangeSet changes) {
        Result result = WfePromptChangeStatus.isValidToChangeStatus(this.awas);
        if (result.isFalse()) {
            AWorkbench.popup((Result)result);
            return result;
        }
        TransitionStatusData data = new TransitionStatusData(this.awas, true);
        TransitionStatusDialog dialog = new TransitionStatusDialog("Enter Hours Spent", "Enter percent complete and number of hours you spent since last status.", data);
        if (dialog.open() == 0) {
            WfePromptChangeStatus.performChangeStatus(this.awas, null, data.getAdditionalHours(), data.getPercent(), data.isSplitHoursBetweenItems(), changes);
            return Result.TrueResult;
        }
        return Result.FalseResult;
    }

    public static void performChangeStatusAndPersist(Collection<? extends IAtsWorkItem> workItems, String selectedOption, double hours, int percent, boolean splitHours) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("ATS Prompt Change Status");
        WfePromptChangeStatus.performChangeStatus(workItems, selectedOption, hours, percent, splitHours, changes);
        changes.execute();
    }

    public static void performChangeStatus(Collection<? extends IAtsWorkItem> workItems, String selectedOption, double hours, int percent, boolean splitHours, IAtsChangeSet changes) {
        if (splitHours) {
            hours /= (double)workItems.size();
        }
        for (IAtsWorkItem iAtsWorkItem : workItems) {
            if (iAtsWorkItem.isUnAssigned()) {
                changes.removeAssignee(iAtsWorkItem, AtsCoreUsers.UNASSIGNED_USER);
                changes.addAssignee(iAtsWorkItem, AtsApiService.get().getUserService().getCurrentUser());
            }
            AtsApiService.get().getWorkItemMetricsService().updateMetrics(iAtsWorkItem, (IStateToken)iAtsWorkItem.getStateDefinition(), hours, percent, true, AtsApiService.get().getUserService().getCurrentUser(), changes);
            changes.add((Object)iAtsWorkItem);
        }
    }
}

