/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.widget;

import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateColor;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workdef.StateColorToSwtColor;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskStates;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.XLabelValueBase;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;

public class TaskInfoXWidget
extends XLabelValueBase {
    private final IStateToken forState;
    private final IManagedForm managedForm;
    private final TeamWorkFlowArtifact teamWf;
    private final Composite compositeLabel;
    private final Composite composite;

    public TaskInfoXWidget(IManagedForm managedForm, TeamWorkFlowArtifact teamWf, IStateToken forState, Composite fromComposite, int horizontalSpan) {
        super("Tasks");
        this.managedForm = managedForm;
        this.teamWf = teamWf;
        this.forState = forState;
        this.compositeLabel = fromComposite.getParent();
        this.composite = fromComposite;
        this.setToolTip("Tasks must be completed before transtion.  Select \"Task\" tab to view tasks");
        this.setFillHorizontally(true);
        this.createWidgets(managedForm, this.composite, horizontalSpan);
        this.addAdminRightClickOption();
    }

    public String toString() {
        try {
            return "TaskInfoXWidget for SMA \"" + (Object)((Object)this.teamWf) + "\"";
        }
        catch (Exception ex) {
            return "TaskInfoXWidget " + ex.getLocalizedMessage();
        }
    }

    public void refresh() {
        if (this.labelWidget == null || this.labelWidget.isDisposed() || this.managedForm == null || this.managedForm.getForm() == null || this.managedForm.getForm().isDisposed()) {
            this.dispose();
        }
        try {
            if (AtsApiService.get().getTaskService().hasTasks((IAtsTeamWorkflow)this.teamWf)) {
                this.dispose();
                this.getStateStatus(this.teamWf, this.forState);
            } else {
                this.dispose();
                this.setValueText("No Tasks Created");
            }
            if (TaskInfoXWidget.areTasksComplete(this.teamWf, this.forState).isFalse()) {
                IMessageManager messageManager;
                if (this.managedForm != null && (messageManager = this.managedForm.getMessageManager()) != null) {
                    messageManager.addMessage((Object)"validation.error", "State \"" + this.forState.getName() + "\" has uncompleted Tasks", null, 3, (Control)this.labelWidget);
                }
            } else if (Widgets.isAccessible((Widget)this.managedForm.getForm()) && this.labelWidget != null) {
                this.managedForm.getMessageManager().removeMessage((Object)"validation.error", (Control)this.labelWidget);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public static Result areTasksComplete(IAtsTeamWorkflow teamWf, IStateToken state) {
        try {
            for (IAtsTask task : AtsApiService.get().getTaskService().getTask((IAtsWorkItem)teamWf)) {
                if (!task.getCurrentStateType().isWorking() || !AtsApiService.get().getTaskService().isRelatedToState(task, state.getName())) continue;
                return new Result(false, "Task " + task.getIdString() + " Not Complete");
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return new Result(false, "Exception " + ex.getLocalizedMessage());
        }
        return Result.TrueResult;
    }

    private void getStateStatus(TeamWorkFlowArtifact currWf, IStateToken currState) {
        if (!this.getValueText().equals("")) {
            return;
        }
        Composite tasksCompositeLabel = new Composite(this.compositeLabel, 16384);
        HashMap<String, Integer> countingMap = new HashMap<String, Integer>();
        HashMap<String, Integer> colorMap = new HashMap<String, Integer>();
        int numStates = 0;
        for (IAtsTask task : AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)currWf)) {
            if (task.getStateDefinition() == null) continue;
            String currTaskName = task.getStateDefinition().getName();
            if (countingMap.containsKey(currTaskName)) {
                countingMap.put(currTaskName, (Integer)countingMap.get(currTaskName) + 1);
            } else {
                countingMap.put(currTaskName, 1);
                StateColor currColor = task.getStateDefinition().getColor();
                if (currColor == null) {
                    currColor = StateColor.BLACK;
                }
                colorMap.put(currTaskName, StateColorToSwtColor.convert(currColor));
            }
            ++numStates;
        }
        int gridSpaces = numStates;
        if (numStates < 3) {
            gridSpaces = 3;
        }
        tasksCompositeLabel.setLayout((Layout)new GridLayout(gridSpaces, false));
        tasksCompositeLabel.setLayoutData((Object)new GridData(0, 0, true, false));
        this.setValueText(String.format(" Total: %d  |  Current State \"%s\": %s", numStates, currState.getName(), AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)currWf, currState).size()));
        Label leftAlignLab = new Label(tasksCompositeLabel, 0);
        leftAlignLab.setText("          ");
        for (String key : countingMap.keySet()) {
            Label lab = new Label(tasksCompositeLabel, 0);
            lab.setText("\"" + key + "\"" + ": " + countingMap.get(key) + " ");
            lab.setForeground(Displays.getSystemColor((int)((Integer)colorMap.get(key))));
        }
    }

    public void addAdminRightClickOption() {
        try {
            if (AtsApiService.get().getUserService().isAtsAdmin() && !AtsApiService.get().getStoreService().isProductionDb()) {
                this.labelWidget.addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.button == 3) {
                            if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Auto Complete Tasks", (String)"ATS Admin\n\nAuto Complete Tasks?")) {
                                return;
                            }
                            try {
                                IAtsChangeSet changes = AtsApiService.get().createChangeSet("Auto Compelte Tasks");
                                for (IAtsTask task : AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)TaskInfoXWidget.this.teamWf, TaskInfoXWidget.this.forState)) {
                                    TaskArtifact taskArt = (TaskArtifact)task.getStoreObject();
                                    if (taskArt.isCompletedOrCancelled() || !taskArt.isUnAssigned()) continue;
                                    changes.setAssignee((IAtsWorkItem)task, AtsApiService.get().getUserService().getCurrentUser());
                                }
                                changes.executeIfNeeded();
                                for (IAtsTask task : AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)TaskInfoXWidget.this.teamWf, TaskInfoXWidget.this.forState)) {
                                    TransitionData transData = new TransitionData("Transition to Completed", Arrays.asList(task), TaskStates.Completed.getName(), null, null, null, new TransitionOption[]{TransitionOption.OverrideTransitionValidityCheck, TransitionOption.None});
                                    TransitionResults results = AtsApiService.get().getWorkItemServiceIde().transition(transData);
                                    if (results.isEmpty()) continue;
                                    AWorkbench.popup((String)String.format("Transition Error %s", results.toString()));
                                    return;
                                }
                            }
                            catch (OseeCoreException ex) {
                                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                            }
                        }
                    }
                });
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

