/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.ev;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.ide.ev.WorkPackageConfigLoader;
import org.eclipse.osee.ats.ide.ev.WorkPackageData;
import org.eclipse.osee.ats.ide.ev.WorkPackageReportColumns;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorProvider;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorTab;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsEditorTableTab;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsXViewerRow;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class WorkPackageConfigReport
extends XNavigateItemAction {
    public static final String TITLE = "Work Package Config Report";

    public WorkPackageConfigReport() {
        super(TITLE, (KeyedImage)PluginUiImage.ADMIN, new XNavItemCat[]{AtsNavigateViewItems.ATS_EARNED_VALUE});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        ResultsEditor.open((IResultsEditorProvider)new IResultsEditorProvider(){
            private List<IResultsEditorTab> tabs;

            public String getEditorName() {
                return WorkPackageConfigReport.TITLE;
            }

            public List<IResultsEditorTab> getResultsEditorTabs() {
                if (this.tabs == null) {
                    this.tabs = new LinkedList<IResultsEditorTab>();
                    this.tabs.add(WorkPackageConfigReport.this.createConfigurationTab());
                }
                return this.tabs;
            }
        });
    }

    private IResultsEditorTab createConfigurationTab() {
        List<XViewerColumn> columns = this.getColumns();
        ArrayList<ResultsXViewerRow> rows = new ArrayList<ResultsXViewerRow>();
        WorkPackageConfigLoader loader = new WorkPackageConfigLoader();
        loader.load();
        for (WorkPackageData data : loader.getWorkPackageDatas()) {
            rows.add(new ResultsXViewerRow(new String[]{data.getWorkPackageName(), data.getColorTeam(), String.valueOf(data.isWorkPackageActive()), data.getProgramName(), data.getWorkPackageProgram(), data.getInsertionName(), data.getInsertionActivityName(), data.getWorkPackageIdStr(), data.getActivityId(), String.valueOf(data.getWorkPackagePercentComplete()), String.valueOf(data.getWorkPackagePointsNumeric()), data.getWorkPackageType(), String.valueOf(data.getWorkPackageBac()), data.getWorkPackageIpt(), DateUtil.get((Date)data.getWorkPackageStartDate(), (String)"MM/dd/yyyy"), DateUtil.get((Date)data.getWorkPackageEndDate(), (String)"MM/dd/yyyy"), data.getWorkPackageNotes(), data.getWorkPackageAnnotation(), data.getTeamNames(), data.getCountryName(), String.valueOf(data.getWorkPackageId())}));
        }
        return new ResultsEditorTableTab("Configuration", columns, rows);
    }

    private List<XViewerColumn> getColumns() {
        List<XViewerColumn> columns = Arrays.asList(WorkPackageReportColumns.workPackageNameColumn, WorkPackageReportColumns.wpColorTeamColumn, WorkPackageReportColumns.wpActiveColumn, WorkPackageReportColumns.programColumn, WorkPackageReportColumns.wpProgramColumn, WorkPackageReportColumns.insertionColumn, WorkPackageReportColumns.insertionActivityColumn, WorkPackageReportColumns.wpIdColumn, WorkPackageReportColumns.wpActivityIdColumn, WorkPackageReportColumns.wpPercentComplete, WorkPackageReportColumns.wpPointsNumeric, WorkPackageReportColumns.wpType, WorkPackageReportColumns.wpBac, WorkPackageReportColumns.wpIpt, WorkPackageReportColumns.wpStartDate, WorkPackageReportColumns.wpEndDate, WorkPackageReportColumns.wpNotes, WorkPackageReportColumns.wpAnnotation, WorkPackageReportColumns.wpTeamAiNames, WorkPackageReportColumns.countryColumn, WorkPackageReportColumns.wpId);
        return columns;
    }
}

