/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.metrics;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelTeamDefinitionSelection;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelVersionSelection;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.widgets.XDateDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DevProgressMetricsBlam
extends AbstractBlam {
    private static final String NAME = "Development Progress Metrics BLAM";
    private static final String TEAM_DEFINITIONS = "Team Definition(s)";
    private static final String VERSION = "Version";
    private static final String START_DATE = "Start Date";
    private static final String END_DATE = "End Date";
    private static final String ALL_TIME = "All Time";
    private XHyperlabelTeamDefinitionSelection programWidget;
    private XHyperlabelVersionSelection versionWidget;
    private XDateDam startDateWidget;
    private XDateDam endDateWidget;
    private Date startDate;
    private Date endDate;
    private boolean allTime;
    private Collection<IAtsVersion> versions;

    public String getName() {
        return NAME;
    }

    public String getDescriptionUsage() {
        return "Generates Dev Progress Report based on Version. Results are in the downloads folder.";
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        if (xWidget.getLabel().equalsIgnoreCase(VERSION)) {
            this.versions = new ArrayList<IAtsVersion>();
            this.versionWidget = (XHyperlabelVersionSelection)xWidget;
            this.versionWidget.getLabelHyperlink().redraw();
        } else if (xWidget.getLabel().equals(TEAM_DEFINITIONS)) {
            this.programWidget = (XHyperlabelTeamDefinitionSelection)xWidget;
            this.programWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    DevProgressMetricsBlam.this.setProgramVersions();
                    DevProgressMetricsBlam.this.versionWidget.setSelectableVersions(DevProgressMetricsBlam.this.versions);
                    DevProgressMetricsBlam.this.versionWidget.getLabelHyperlink().redraw();
                }
            });
        } else if (xWidget.getLabel().equalsIgnoreCase(START_DATE)) {
            this.startDateWidget = (XDateDam)xWidget;
            this.initializeWidgets();
        } else if (xWidget.getLabel().equalsIgnoreCase(END_DATE)) {
            this.endDateWidget = (XDateDam)xWidget;
            this.initializeWidgets();
        }
    }

    public void runOperation(final VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String fileLocation = String.format("C:%sUsers%s%s%sDownloads", File.separator, File.separator, System.getProperty("user.name"), File.separator);
                    Version selectedVersion = DevProgressMetricsBlam.this.versionWidget.getSelectedVersion();
                    DevProgressMetricsBlam.this.startDate = (Date)variableMap.getValue(DevProgressMetricsBlam.START_DATE);
                    DevProgressMetricsBlam.this.endDate = (Date)variableMap.getValue(DevProgressMetricsBlam.END_DATE);
                    DevProgressMetricsBlam.this.allTime = variableMap.getBoolean(DevProgressMetricsBlam.ALL_TIME);
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (Response res = AtsApiService.get().getServerEndpoints().getMetricsEp().devProgressReport(selectedVersion.getName(), DevProgressMetricsBlam.this.startDate, DevProgressMetricsBlam.this.endDate, DevProgressMetricsBlam.this.allTime);){
                        if (res == null) {
                            return;
                        }
                        String filePath = String.format("%s%s%s", fileLocation, File.separator, res.getHeaderString("FileName"));
                        Throwable throwable2 = null;
                        Object var8_12 = null;
                        try (BufferedWriter bwr = new BufferedWriter(new FileWriter(new File(filePath)));){
                            GZIPInputStream gzInputStream = (GZIPInputStream)res.getEntity();
                            StringBuffer sb = new StringBuffer();
                            Throwable throwable3 = null;
                            Object var13_19 = null;
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(gzInputStream));){
                                String inputLine = "";
                                while ((inputLine = in.readLine()) != null) {
                                    sb.append(inputLine);
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                            bwr.write(sb.toString());
                            bwr.flush();
                            bwr.close();
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                        res.close();
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.REPORTS);
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        XWidgetBuilder wb = new XWidgetBuilder();
        wb.andWidget(TEAM_DEFINITIONS, "XHyperlabelTeamDefinitionSelection").endWidget();
        wb.andWidget(VERSION, "XHyperlabelVersionSelection").endWidget();
        wb.andWidget(START_DATE, "XDateDam").endWidget();
        wb.andWidget(END_DATE, "XDateDam").endWidget();
        wb.andWidget(ALL_TIME, "XCheckBox").endWidget();
        return wb.getItems();
    }

    public void setProgramVersions() {
        HashSet versionSet = new HashSet();
        Collection<TeamDefinition> teamDefs = this.programWidget.getSelectedTeamDefintions();
        for (IAtsTeamDefinition iAtsTeamDefinition : teamDefs) {
            if (!iAtsTeamDefinition.isValid()) continue;
            versionSet.addAll(AtsApiService.get().getVersionService().getVersionsFromTeamDefHoldingVersions(iAtsTeamDefinition));
        }
        this.versions.clear();
        this.versions.addAll(versionSet);
    }

    private void initializeWidgets() {
        if (this.startDateWidget != null) {
            this.initializeStartDate();
        }
        if (this.endDateWidget != null) {
            this.endDateWidget.setDate(Calendar.getInstance().getTime());
        }
    }

    private void initializeStartDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        this.startDateWidget.setDate(cal.getTime());
    }
}

