/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.util.ExportChangeReportUtil;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.operation.ChangeReportProvider;
import org.eclipse.osee.ats.ide.operation.ChangeReportProviderService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.CompareData;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.change.ArtifactChange;
import org.eclipse.osee.framework.skynet.core.change.ArtifactDelta;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.skynet.render.compare.CompareDataCollector;

public final class ExportChangeReportOperation
extends AbstractOperation {
    private final List<IAtsTeamWorkflow> workflows;
    private final Appendable resultFolder;
    private final boolean reverse;
    private final boolean writeChangeReports;
    private final String overrideDataRightsClassification;
    private final List<Long> excludedIds = new ArrayList<Long>();
    boolean debug = false;

    public ExportChangeReportOperation(List<IAtsTeamWorkflow> workflows, boolean reverse, boolean writeChangeReports, String overrideDataRightsClassification, Appendable resultFolder, OperationLogger logger) {
        super("Exporting Change Report(s)", "org.eclipse.osee.ats.ide", logger);
        this.workflows = workflows;
        this.reverse = reverse;
        this.writeChangeReports = writeChangeReports;
        this.overrideDataRightsClassification = overrideDataRightsClassification;
        this.resultFolder = resultFolder;
        for (ChangeReportProvider provider : ChangeReportProviderService.getProviders()) {
            this.excludedIds.addAll(provider.getExcludedArtifactIds());
        }
    }

    protected void doWork(IProgressMonitor monitor) {
        this.logf("Starting %s, processing %d workflows.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.workflows.size()});
        this.sortWorkflows();
        HashSet<String> skippedTypes = new HashSet<String>();
        CompareDataCollector collector = new CompareDataCollector(){

            public void onCompare(CompareData data) {
                String filePath = data.getOutputPath();
                String modifiedPath = filePath.substring(0, filePath.lastIndexOf(File.separator));
                try {
                    if (ExportChangeReportOperation.this.resultFolder.toString().isEmpty()) {
                        ExportChangeReportOperation.this.resultFolder.append(modifiedPath);
                    }
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            }
        };
        for (IAtsTeamWorkflow workflow : this.workflows) {
            HashSet<ArtifactId> artIds;
            Collection<Change> changes = this.computeChanges(workflow, monitor, artIds = new HashSet<ArtifactId>());
            if (!changes.isEmpty() && changes.size() < 4000) {
                this.logf("Exporting: %s -- %s", new Object[]{workflow.toString(), workflow.getAtsId()});
                String id = workflow.getAtsId();
                String prefix = "/" + id;
                if (this.writeChangeReports) {
                    ArrayList<ArtifactDelta> artifactDeltas = new ArrayList<ArtifactDelta>(changes.size());
                    for (Change next : changes) {
                        this.filterChange(next, skippedTypes, artIds, artifactDeltas);
                    }
                    if (artifactDeltas.isEmpty()) {
                        this.logf("Nothing exported for Workflow[%s]", new Object[]{id});
                        continue;
                    }
                    RendererMap rendererOptions = RendererMap.of((Object[])new Object[]{RendererOption.NO_DISPLAY, true, RendererOption.SKIP_DIALOGS, true, RendererOption.OVERRIDE_DATA_RIGHTS, this.overrideDataRightsClassification});
                    RendererManager.diff((CompareDataCollector)collector, artifactDeltas, (String)prefix, (RendererMap)rendererOptions);
                }
                String artIdsAsString = org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", artIds);
                try {
                    if (this.resultFolder.toString().isEmpty()) {
                        IFolder folder = OseeData.getFolder((String)"ids");
                        File idsFolder = new File(folder.getLocationURI());
                        this.resultFolder.append(idsFolder.getAbsolutePath());
                    }
                    Lib.writeStringToFile((String)artIdsAsString, (File)new File(this.resultFolder + prefix + "_ids.txt"));
                    File resultDir = new File(this.resultFolder.toString());
                    File compareDir = resultDir.getParentFile().getParentFile();
                    Lib.writeStringToFile((String)artIdsAsString, (File)new File(compareDir + "/copy" + prefix + "_ids.txt"));
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            }
            monitor.worked(this.calculateWork(0.5));
        }
        this.logf("-------- skipped types --------- ", new Object[0]);
        for (String skipped : skippedTypes) {
            this.logf(skipped, new Object[0]);
        }
    }

    private void filterChange(Change change, Set<String> skipped, Set<ArtifactId> artIds, Collection<ArtifactDelta> deltas) {
        boolean remove = false;
        ArtifactDelta delta = change.getDelta();
        Artifact endArtifact = delta.getEndArtifact();
        if (!endArtifact.isOfType((ArtifactTypeId[])ExportChangeReportUtil.ARTIFACT_ALLOW_TYPES)) {
            remove = true;
            artIds.remove(endArtifact);
        }
        if (!remove && change.getModificationType() == ModificationType.APPLICABILITY && delta.getStartArtifact() == null && delta.getEndArtifact().getApplicablityId().equals(ApplicabilityId.BASE)) {
            remove = true;
        }
        if (remove) {
            if (this.debug) {
                this.logf("skipping: [" + endArtifact.getName().replaceAll("%", "%%") + "] type: [" + endArtifact.getArtifactTypeName() + "] branch: [" + endArtifact.getBranch().getIdString() + "] artId: [" + endArtifact.getIdString() + "]", new Object[0]);
            }
            skipped.add(endArtifact.getArtifactTypeName());
        } else {
            deltas.add(delta);
        }
    }

    private void sortWorkflows() {
        Collections.sort(this.workflows, new Comparator<IAtsTeamWorkflow>(){

            @Override
            public int compare(IAtsTeamWorkflow workflow1, IAtsTeamWorkflow workflow2) {
                try {
                    String atsId1 = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)workflow1, (AttributeTypeToken)AtsAttributeTypes.AtsId, (Object)"");
                    String atsId2 = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)workflow2, (AttributeTypeToken)AtsAttributeTypes.AtsId, (Object)"");
                    int compare = atsId1.compareTo(atsId2);
                    return ExportChangeReportOperation.this.reverse ? -1 * compare : compare;
                }
                catch (OseeCoreException oseeCoreException) {
                    return -1;
                }
            }
        });
    }

    private Collection<Change> computeChanges(IAtsTeamWorkflow teamWf, IProgressMonitor monitor, Set<ArtifactId> artIds) {
        ArrayList<Change> changes = new ArrayList<Change>();
        IOperation operation = null;
        if (AtsApiService.get().getBranchService().isCommittedBranchExists(teamWf)) {
            operation = ChangeManager.comparedToPreviousTx((TransactionToken)this.pickTransactionFromTargetVersion(teamWf), changes);
        } else {
            BranchToken workingBranch = AtsApiService.get().getBranchService().getWorkingBranch(teamWf);
            if (workingBranch != null && !BranchManager.getType((BranchId)workingBranch).isBaselineBranch()) {
                operation = ChangeManager.comparedToParent((BranchId)workingBranch, changes);
            }
        }
        if (operation != null) {
            this.doSubWork(operation, monitor, 0.5);
            Iterator iterator = changes.iterator();
            while (iterator.hasNext()) {
                Change change = (Change)iterator.next();
                if (!(change instanceof ArtifactChange) || this.excludedIds.contains(change.getChangeArtifact().getId())) {
                    iterator.remove();
                    continue;
                }
                artIds.add(change.getArtId());
            }
            Collections.sort(changes);
        }
        return changes;
    }

    private TransactionToken pickTransactionFromTargetVersion(IAtsTeamWorkflow workflow) {
        TransactionToken pickId = TransactionToken.SENTINEL;
        IAtsProgram program = AtsApiService.get().getProgramService().getProgram((IAtsWorkItem)workflow);
        String targetBranchStr = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)program, (AttributeTypeToken)AtsAttributeTypes.ProductLineBranchId, (Object)"");
        if (Strings.isValidAndNonBlank((String)targetBranchStr)) {
            BranchId targetBranch = BranchId.valueOf((String)targetBranchStr);
            for (TransactionToken transaction : TransactionManager.getCommittedArtifactTransactionIds((ArtifactId)AtsApiService.get().getQueryServiceIde().getArtifact(workflow))) {
                if (!transaction.getBranch().equals(targetBranch)) continue;
                pickId = transaction;
            }
        }
        if (!pickId.isValid()) {
            return this.pickTransaction(workflow);
        }
        return pickId;
    }

    private TransactionToken pickTransaction(IAtsTeamWorkflow workflow) {
        TransactionToken minTransactionId = TransactionToken.SENTINEL;
        for (TransactionToken transaction : TransactionManager.getCommittedArtifactTransactionIds((ArtifactId)AtsApiService.get().getQueryServiceIde().getArtifact(workflow))) {
            if (!minTransactionId.isOlderThan((TransactionId)transaction) || BranchManager.isArchived((BranchId)transaction.getBranch())) continue;
            minTransactionId = transaction;
        }
        if (!minTransactionId.isValid()) {
            throw new OseeStateException("no transaction records found for [%s]", new Object[]{workflow});
        }
        return minTransactionId;
    }
}

