/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.program;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.ats.core.rule.validate.AttributeFormatRule;
import org.eclipse.osee.ats.core.rule.validate.AttributeSetRule;
import org.eclipse.osee.ats.core.rule.validate.DeletedArtifactValidationRule;
import org.eclipse.osee.ats.core.rule.validate.ListAndBulletRule;
import org.eclipse.osee.ats.core.rule.validate.OrphanAndDuplicateParentValidationRule;
import org.eclipse.osee.ats.core.rule.validate.UniqueNameRule;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.validate.MatchingApplicabilityTagsRule;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class DemoCreateValidationRulesOperation
extends AbstractOperation {
    private final TeamWorkFlowArtifact teamArt;
    public Collection<AbstractValidationRule> rules;
    private final WorkType workType;

    public DemoCreateValidationRulesOperation(XResultData results, TeamWorkFlowArtifact teamArt, Collection<AbstractValidationRule> rules, WorkType workType) {
        super("Multi Processor Build Validation Rules Operation - " + teamArt.getName(), "org.eclipse.osee.ats.ide", null);
        this.teamArt = teamArt;
        this.rules = rules;
        this.workType = workType;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        if (this.workType == null) {
            String errorMsg = String.format("WorkType can not be determined for [%s][%s]", new Object[]{this.teamArt.getArtifactTypeName(), this.teamArt});
            throw new OseeCoreException(errorMsg, new Object[0]);
        }
        this.rules.add((AbstractValidationRule)new AttributeSetRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.AbstractSoftwareRequirement, (AttributeTypeToken)CoreAttributeTypes.CSCI, Integer.valueOf(1), "Unspecified"));
        this.rules.add(new MatchingApplicabilityTagsRule(AtsApiService.get()));
        this.rules.add((AbstractValidationRule)new OrphanAndDuplicateParentValidationRule((AtsApi)AtsApiService.get()));
        this.rules.add((AbstractValidationRule)new DeletedArtifactValidationRule((AtsApi)AtsApiService.get()));
        if (this.workType == WorkType.Code || this.workType == WorkType.Requirements) {
            this.rules.add((AbstractValidationRule)new ListAndBulletRule(this.workType, (AtsApi)AtsApiService.get()));
        }
        if (this.workType == WorkType.Requirements) {
            this.rules.add((AbstractValidationRule)new AttributeSetRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.AbstractSoftwareRequirement, (AttributeTypeToken)CoreAttributeTypes.DataRightsClassification, Integer.valueOf(1), "Unspecified"));
            this.rules.add((AbstractValidationRule)new AttributeSetRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.AbstractSoftwareRequirement, (AttributeTypeToken)CoreAttributeTypes.Subsystem, Integer.valueOf(1), "Unspecified"));
            this.rules.add((AbstractValidationRule)new AttributeSetRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.AbstractSoftwareRequirement, (AttributeTypeToken)CoreAttributeTypes.QualificationMethod, Integer.valueOf(1), "Unspecified"));
            this.rules.add((AbstractValidationRule)new UniqueNameRule(CoreArtifactTypes.AbstractSoftwareRequirement, (AtsApi)AtsApiService.get()));
            this.rules.add((AbstractValidationRule)new AttributeSetRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.ImplementationDetailsMsWord, (AttributeTypeToken)CoreAttributeTypes.CSCI, Integer.valueOf(1), "Unspecified"));
            this.rules.add((AbstractValidationRule)new AttributeSetRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.ImplementationDetailsMsWord, (AttributeTypeToken)CoreAttributeTypes.Subsystem, Integer.valueOf(1), "Unspecified"));
            String ReqNameFormat = String.format("\\{.*\\}", new Object[0]);
            this.rules.add((AbstractValidationRule)new AttributeFormatRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.SoftwareRequirementMsWord, (AttributeTypeToken)CoreAttributeTypes.Name, Integer.valueOf(1), ReqNameFormat));
            this.rules.add((AbstractValidationRule)new AttributeFormatRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.SoftwareRequirementProcedureMsWord, (AttributeTypeToken)CoreAttributeTypes.Name, Integer.valueOf(1), ReqNameFormat));
            this.rules.add((AbstractValidationRule)new AttributeFormatRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.SoftwareRequirementFunctionMsWord, (AttributeTypeToken)CoreAttributeTypes.Name, Integer.valueOf(1), ReqNameFormat));
            this.rules.add((AbstractValidationRule)new AttributeFormatRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.ImplementationDetailsMsWord, (AttributeTypeToken)CoreAttributeTypes.Name, Integer.valueOf(1), ReqNameFormat));
            this.rules.add((AbstractValidationRule)new AttributeFormatRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.ImplementationDetailsProcedureMsWord, (AttributeTypeToken)CoreAttributeTypes.Name, Integer.valueOf(1), ReqNameFormat));
            this.rules.add((AbstractValidationRule)new AttributeFormatRule((AtsApi)AtsApiService.get(), CoreArtifactTypes.ImplementationDetailsFunctionMsWord, (AttributeTypeToken)CoreAttributeTypes.Name, Integer.valueOf(1), ReqNameFormat));
        }
    }
}

