/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractAtsArtifact;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.review.ReviewManager;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactPersistenceManager;
import org.eclipse.osee.framework.skynet.core.artifact.PurgeArtifacts;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.artifact.ArtifactPersistenceManagerUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.HtmlDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.widgets.Shell;

public class AtsDeleteManager {
    public static void handleDeletePurgeAtsObject(Collection<Artifact> selectedArts, boolean forcePend, DeleteOption ... deleteOption) {
        final ArrayList<DeleteOption> deleteOptions = new ArrayList<DeleteOption>(Arrays.asList(deleteOption));
        boolean purgeOption = deleteOptions.contains((Object)DeleteOption.Purge);
        ArrayList<Artifact> delArts = new ArrayList<Artifact>();
        StringBuilder artBuilder = new StringBuilder();
        for (Artifact art : selectedArts) {
            if (!(art instanceof AbstractAtsArtifact)) continue;
            delArts.add(art);
            if (selectedArts.size() >= 30) continue;
            artBuilder.append(String.format("Name: %s  Type: %s\n", ((AbstractAtsArtifact)art).getName(), art.getArtifactTypeName()));
        }
        if (selectedArts.size() >= 5) {
            artBuilder.append(" < " + selectedArts.size() + " artifacts>");
        }
        boolean confirmDelete = true;
        boolean isAtsAdmin = AtsApiService.get().getUserService().isAtsAdmin();
        boolean isAtsDeleteWorkflowAdmin = AtsApiService.get().getUserService().isAtsDeleteWorkflowAdmin();
        if (deleteOptions.contains((Object)DeleteOption.Prompt)) {
            if (!isAtsAdmin && isAtsDeleteWorkflowAdmin) {
                boolean confirmationFromDialog;
                confirmDelete = confirmationFromDialog = MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Delete ATS Object", (String)("Prepare to Delete/ ATS Object\n\n" + artBuilder.toString().replaceFirst("\n$", "") + "\n\nAnd ALL its ATS children.\n(Artifacts will be retrieved for confirmation)\nAre You Sure?"));
                purgeOption = false;
            } else {
                MessageDialogWithToggle md = MessageDialogWithToggle.openOkCancelConfirm((Shell)Displays.getActiveShell(), (String)"Delete/Purge ATS Object", (String)("Prepare to Delete/Purge ATS Object\n\n" + artBuilder.toString().replaceFirst("\n$", "") + "\n\nAnd ALL its ATS children.\n(Artifacts will be retrieved for confirmation)\nAre You Sure?"), (String)"Purge", (boolean)false, null, null);
                boolean bl = confirmDelete = md.getReturnCode() == 0;
                if (md.getToggleState()) {
                    purgeOption = true;
                }
            }
        }
        if (!confirmDelete) {
            return;
        }
        StringBuilder delBuilder = new StringBuilder();
        final HashSet<Artifact> allDeleteArts = new HashSet<Artifact>(30);
        HashMap<Artifact, Object> ignoredArts = new HashMap<Artifact, Object>();
        AtsDeleteManager.getDeleteArtifacts(delArts, delBuilder, allDeleteArts, ignoredArts);
        final boolean purge = purgeOption;
        if (purge && isAtsDeleteWorkflowAdmin && !isAtsAdmin) {
            AWorkbench.popup((String)"Purge is an Admin-only function");
            return;
        }
        if (deleteOptions.contains((Object)DeleteOption.Prompt)) {
            String results = String.valueOf(purge ? "Purge" : "Delete") + " ATS objects and related children, Are You Sure?\n" + delBuilder.toString();
            results = results.replaceAll("\n", "<br/>");
            HtmlDialog dialog = new HtmlDialog(String.valueOf(purge ? "Purge" : "Delete") + " ATS objects and related children", "", AHTML.simplePage((String)results));
            dialog.open();
            if (dialog.getReturnCode() != 0) {
                return;
            }
        }
        AbstractOperation operation = new AbstractOperation(String.valueOf(purge ? "Purge" : "Delete") + " ATS Objects", "org.eclipse.osee.ats.ide"){

            protected void doWork(IProgressMonitor monitor) throws Exception {
                if (purge) {
                    Operations.executeWorkAndCheckStatus((IOperation)new PurgeArtifacts((Collection)allDeleteArts));
                } else if (!allDeleteArts.isEmpty()) {
                    SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)"Delete ATS Objects");
                    XResultData rd = ArtifactPersistenceManager.deleteArtifactCollection((SkynetTransaction)transaction, (boolean)false, (XResultData)new XResultData(), (Collection)allDeleteArts);
                    ArtifactPersistenceManagerUI.cancelTxAndExceptionUiIfErrors((XResultData)rd, (String)"Delete ATS Objects", (SkynetTransaction)transaction);
                    transaction.execute();
                }
                if (deleteOptions.contains((Object)DeleteOption.Prompt)) {
                    AWorkbench.popup((String)(String.valueOf(purge ? "Purge" : "Delete") + " Completed"), (String)(String.valueOf(purge ? "Purge" : "Delete") + " Completed"));
                }
            }
        };
        if (forcePend) {
            Operations.executeWork((IOperation)operation);
        } else {
            Operations.executeAsJob((IOperation)operation, (boolean)true);
        }
    }

    private static void getDeleteArtifacts(List<Artifact> delArts, StringBuilder delBuilder, Set<Artifact> allDeleteArts, Map<Artifact, Object> ignoredArts) {
        for (Artifact deleteArt : delArts) {
            allDeleteArts.add(deleteArt);
            HashSet<Artifact> relatedArts = new HashSet<Artifact>(30);
            delBuilder.append(String.valueOf(String.format("\n<b>Selected</b>:[%s][%s][%s]", deleteArt.getArtifactTypeName(), AtsApiService.get().getAtsId((ArtifactToken)deleteArt), deleteArt.getName())) + "\n");
            if (deleteArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                for (IAtsTeamWorkflow iAtsTeamWorkflow : AtsApiService.get().getWorkItemService().getTeams((Object)deleteArt)) {
                    AtsDeleteManager.atsDelete((AbstractWorkflowArtifact)iAtsTeamWorkflow, relatedArts, ignoredArts);
                }
            } else if (deleteArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
                WorkflowEditor.close(Collections.singleton((AbstractWorkflowArtifact)deleteArt), true);
                AtsDeleteManager.atsDelete((AbstractWorkflowArtifact)deleteArt, relatedArts, ignoredArts);
                for (Artifact artifact : relatedArts) {
                    if (!artifact.notEqual((Id)deleteArt)) continue;
                    delBuilder.append(String.valueOf(String.format(String.valueOf(AHTML.addSpace((int)4)) + "<b>Related</b>:[%s][%s][%s]", artifact.getArtifactTypeName(), AtsApiService.get().getAtsId((ArtifactToken)artifact), artifact.getName())) + "\n");
                }
            }
            for (Artifact artifact : allDeleteArts) {
                Collection teamWfArts;
                Artifact actionArt;
                AbstractWorkflowArtifact awa;
                IAtsTeamWorkflow teamWf;
                if (!(artifact instanceof AbstractWorkflowArtifact) || (teamWf = (awa = (AbstractWorkflowArtifact)artifact).getParentTeamWorkflow()) == null || (actionArt = (Artifact)awa.getParentAction().getStoreObject()) == null || allDeleteArts.contains(actionArt) || !allDeleteArts.containsAll(teamWfArts = AtsObjects.getArtifacts((Collection)AtsApiService.get().getWorkItemService().getTeams((Object)actionArt)))) continue;
                relatedArts.add(actionArt);
                delBuilder.append(String.valueOf(String.format(String.valueOf(AHTML.addSpace((int)4)) + "<b>Related</b>:[%s][%s][%s]", actionArt.getArtifactTypeName(), AtsApiService.get().getAtsId((ArtifactToken)actionArt), actionArt.getName())) + "\n");
            }
            allDeleteArts.addAll(relatedArts);
        }
        for (Artifact art : allDeleteArts) {
            if (!(art instanceof AbstractWorkflowArtifact)) continue;
            WorkflowEditor.close(Collections.singleton((AbstractWorkflowArtifact)art), true);
        }
    }

    private static void atsDelete(AbstractWorkflowArtifact awa, Set<Artifact> deleteArts, Map<Artifact, Object> allRelated) {
        deleteArts.add(awa);
        for (Artifact relative : AtsDeleteManager.getBSideArtifacts(awa)) {
            allRelated.put(relative, (Object)awa);
        }
        if (awa.isTeamWorkflow()) {
            for (AbstractReviewArtifact reviewArt : ReviewManager.getReviews((TeamWorkFlowArtifact)awa)) {
                AtsDeleteManager.atsDelete(reviewArt, deleteArts, allRelated);
            }
            for (IAtsTask task : AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)((TeamWorkFlowArtifact)awa))) {
                AtsDeleteManager.atsDelete((AbstractWorkflowArtifact)task.getStoreObject(), deleteArts, allRelated);
            }
        }
    }

    private static List<Artifact> getBSideArtifacts(AbstractWorkflowArtifact awa) {
        ArrayList<Artifact> sideBArtifacts = new ArrayList<Artifact>();
        List relatives = awa.getRelationsAll(DeletionFlag.EXCLUDE_DELETED);
        for (RelationLink link : relatives) {
            Artifact sideB = link.getArtifactB();
            if (!sideB.notEqual((Id)awa)) continue;
            sideBArtifacts.add(sideB);
        }
        return sideBArtifacts;
    }

    public static enum DeleteOption {
        Prompt,
        Delete,
        Purge;

    }
}

