/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.Date;
import java.util.logging.Level;
import org.eclipse.osee.ats.ide.column.DeadlineColumnUI;
import org.eclipse.osee.ats.ide.column.EstimatedCompletionDateColumn;
import org.eclipse.osee.ats.ide.column.EstimatedReleaseDateColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLog;

public class DeadlineManager {
    public static Date getEcdDate(AbstractWorkflowArtifact sma) {
        try {
            return EstimatedCompletionDateColumn.getDate((Object)sma);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Date getDeadlineDate(AbstractWorkflowArtifact sma) {
        try {
            return DeadlineColumnUI.getDate((Object)sma);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isDeadlineDateSet(AbstractWorkflowArtifact sma) {
        return DeadlineManager.getDeadlineDate(sma) != null;
    }

    public static boolean isEcdDateSet(AbstractWorkflowArtifact sma) {
        return DeadlineManager.getEcdDate(sma) != null;
    }

    public static Result isDeadlineDateOverdue(AbstractWorkflowArtifact sma) {
        Result result = Result.FalseResult;
        if (sma.isInWork() && new Date().after(DeadlineManager.getDeadlineDate(sma))) {
            return new Result(true, "Need By Date has passed.");
        }
        return result;
    }

    public static Result isEcdDateOverdue(AbstractWorkflowArtifact sma) {
        Result result = Result.FalseResult;
        if (sma.isInWork()) {
            Date ecdDate = DeadlineManager.getEcdDate(sma);
            Date deadlineDate = DeadlineManager.getDeadlineDate(sma);
            if (ecdDate != null) {
                if (new Date().after(ecdDate)) {
                    result = new Result(true, "Estimated Completion Date has passed.");
                }
                if (deadlineDate != null && ecdDate.after(deadlineDate)) {
                    result = new Result(true, "Estimated Completion Date after Need By Date.");
                }
            }
        }
        return result;
    }

    public static Result isDeadlinePastRelease(AbstractWorkflowArtifact sma) {
        try {
            if (sma.isCompleted() || sma.isCancelled()) {
                return Result.FalseResult;
            }
            Date deadDate = DeadlineManager.getDeadlineDate(sma);
            if (deadDate == null) {
                return Result.FalseResult;
            }
            Date releaseDate = EstimatedReleaseDateColumn.getDateFromWorkflow((Object)sma);
            if (releaseDate == null && (releaseDate = EstimatedReleaseDateColumn.getDateFromTargetedVersion((Object)sma)) == null) {
                return Result.FalseResult;
            }
            if (releaseDate.after(deadDate)) {
                return new Result(true, "Need By Date is past current Release Date.");
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return Result.FalseResult;
    }

    public static Result isDeadlineDateAlerting(AbstractWorkflowArtifact sma) {
        if (!DeadlineManager.isDeadlineDateSet(sma)) {
            return Result.FalseResult;
        }
        Result r = DeadlineManager.isDeadlineDateOverdue(sma);
        if (r.isTrue()) {
            return r;
        }
        r = DeadlineManager.isDeadlinePastRelease(sma);
        if (r.isTrue()) {
            return r;
        }
        return Result.FalseResult;
    }

    public static Result isEcdDateAlerting(AbstractWorkflowArtifact sma) {
        if (!DeadlineManager.isEcdDateSet(sma)) {
            return Result.FalseResult;
        }
        Result r = DeadlineManager.isEcdDateOverdue(sma);
        if (r.isTrue()) {
            return r;
        }
        return Result.FalseResult;
    }
}

