/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.Import.action;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.task.JaxAttribute;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.util.Import.action.ActionColumns;
import org.eclipse.osee.ats.ide.util.Import.action.ActionData;
import org.eclipse.osee.ats.ide.util.Import.action.ValidationEditorOperation;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.ExcelToPojoOperation;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.ECell;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.EFile;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.EHeaderCell;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.ERow;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.EWorksheet;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;

public class ImportActionsOperation {
    private final List<ActionData> actionDatas = new ArrayList<ActionData>();
    private final Set<Artifact> actionArts = new HashSet<Artifact>();
    private final Map<String, ActionResult> actionNameToAction = new HashMap<String, ActionResult>(100);
    private final boolean emailPOCs;
    private final IAtsGoal toGoal;
    private final Map<String, IAgileTeam> teamNameByTeamMap = new HashMap<String, IAgileTeam>();
    private final File file;
    private XResultData rd;
    private final AtsApiIde atsApi;
    private final boolean persist;
    private final String commitComment;

    public ImportActionsOperation(File file, boolean emailPOCs, IAtsGoal toGoal, boolean persist, String commitComment) {
        this.file = file;
        this.emailPOCs = emailPOCs;
        this.toGoal = toGoal;
        this.persist = persist;
        this.commitComment = commitComment;
        this.atsApi = AtsApiService.get();
    }

    public XResultData run() {
        ExcelToPojoOperation op = new ExcelToPojoOperation(this.file);
        EFile eFile = op.run();
        if (eFile.getResults().isErrors()) {
            return eFile.getResults();
        }
        this.rd = eFile.getResults();
        try {
            this.validateHeaders(eFile);
            if (this.rd.isErrors()) {
                return this.rd;
            }
            this.createActionDatas(eFile);
            if (this.rd.isErrors()) {
                return this.rd;
            }
            this.validateActionDatas(eFile, new XResultData());
            if (this.rd.isErrors()) {
                return this.rd;
            }
            if (this.persist) {
                IAtsChangeSet changes = this.atsApi.createChangeSet(this.commitComment);
                this.createArtifactsAndNotify(changes);
                changes.execute();
            } else {
                ValidationEditorOperation editOp = new ValidationEditorOperation(this.actionDatas);
                editOp.open();
            }
        }
        catch (Exception ex) {
            this.rd.errorf("Exception importing actions %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return this.rd;
    }

    private void validateHeaders(EFile eFile) {
        for (EHeaderCell hCell : ((EWorksheet)eFile.getWorkbook().getSheets().iterator().next()).getHeader().getHcells()) {
            String hCellName = hCell.getName();
            if (ActionColumns.getColNames().contains(hCellName)) continue;
            String attrTypeName = hCellName;
            if (Strings.isValid((String)attrTypeName)) {
                if (!AttributeTypeManager.typeExists((String)attrTypeName)) {
                    this.rd.errorf("Invalid Column or Attribute Type Name => %s\n", new Object[]{attrTypeName});
                    continue;
                }
                AttributeTypeToken attributeType = AttributeTypeManager.getType((String)attrTypeName);
                if (attributeType == null) {
                    this.rd.errorf("Invalid Column or Attribute Type Name => %s\n", new Object[]{attrTypeName});
                    continue;
                }
                hCell.setStoreType((Object)attributeType);
                continue;
            }
            this.rd.errorf("Unhandled column %s => [%s]\n", new Object[]{hCell.getColNum(), hCell.getName()});
        }
    }

    private void validateActionDatas(EFile eFile, XResultData rd) {
        int rowNum = 1;
        for (ActionData aData : this.actionDatas) {
            IAgileSprint sprint;
            IAgileTeam aTeam;
            ++rowNum;
            if (aData.title.equals("")) {
                rd.error("Row " + rowNum + "; Invalid Title");
            }
            if (Strings.isInValid((String)aData.desc)) {
                rd.error("Row " + rowNum + "; Invalid Description");
            }
            HashSet teamDefs = new HashSet();
            if (aData.actionableItems.isEmpty()) {
                rd.error("Row " + rowNum + ": Must have at least one ActionableItem defined");
            } else {
                for (String actionableItemName : aData.actionableItems) {
                    try {
                        ArrayList<ActionableItem> aias = new ArrayList<ActionableItem>();
                        for (Artifact aiaArt : ArtifactQuery.getArtifactListFromTypeAndName((ArtifactTypeId)AtsArtifactTypes.ActionableItem, (String)actionableItemName, (BranchId)this.atsApi.getAtsBranch())) {
                            ActionableItem ai = this.atsApi.getActionableItemService().getActionableItemById((ArtifactId)aiaArt);
                            if (ai == null) continue;
                            aias.add(ai);
                        }
                        if (aias.isEmpty()) {
                            rd.error("Row " + rowNum + ": Couldn't find actionable item for \"" + actionableItemName + "\"");
                            continue;
                        }
                        if (aias.size() > 1) {
                            rd.error("Row " + rowNum + ": Duplicate actionable items found with name \"" + actionableItemName + "\"");
                            continue;
                        }
                        IAtsActionableItem aia = (IAtsActionableItem)aias.iterator().next();
                        teamDefs.addAll(this.atsApi.getActionableItemService().getImpactedTeamDefs(Arrays.asList(aia)));
                        if (teamDefs.isEmpty()) {
                            rd.error("Row " + rowNum + ": No related Team Definition for Actionable Item\"" + actionableItemName + "\"");
                            continue;
                        }
                        if (teamDefs.size() <= 1) continue;
                        rd.error("Row " + rowNum + ": Duplicate Team Definitions found for Actionable Item\"" + actionableItemName + "\"");
                    }
                    catch (Exception ex) {
                        rd.error("Row " + rowNum + " - " + ex.getLocalizedMessage());
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            }
            if (Strings.isValid((String)aData.version)) {
                try {
                    for (IAtsTeamDefinition teamDef : teamDefs) {
                        if (this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(teamDef) == null) {
                            rd.errorf("No Team Definitions Holding Versions found for Team Definition [%s]\n", new Object[]{teamDef});
                        }
                        IAtsTeamDefinition teamDefHolVer = this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(teamDef);
                        if (this.atsApi.getVersionService().getVersion(teamDefHolVer, aData.version) != null) continue;
                        rd.errorf("No version [%s] configured for Team Definition [%s]\n", new Object[]{aData.version, teamDef});
                    }
                }
                catch (Exception ex) {
                    rd.error("Row " + rowNum + " - " + ex.getLocalizedMessage());
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
            if (aData.assigneeStrs.size() > 0) {
                for (String assignee : aData.assigneeStrs) {
                    try {
                        assignee = assignee.replaceFirst("^ *", "");
                        assignee = assignee.replaceFirst(" *$", "");
                        AtsUser user = this.atsApi.getUserService().getUserByName(assignee);
                        if (user == null) {
                            rd.error("Row " + rowNum + ": Couldn't retrieve user \"" + assignee + "\"");
                            continue;
                        }
                        aData.assignees.add(user);
                    }
                    catch (UserNotInDatabase ex) {
                        rd.error("Row " + rowNum + ": " + ex.getLocalizedMessage());
                    }
                }
            }
            if (Strings.isValid((String)aData.agileTeamName)) {
                IAgileBacklog backlog;
                aTeam = this.getAgileTeamByName(aData.agileTeamName);
                if (aTeam == null) {
                    rd.errorf("Invalid team name [%s]\n", new Object[]{aData.agileTeamName});
                }
                if ((backlog = this.getAgileBacklog(aData.agileTeamName)) == null) {
                    rd.errorf("No backlog for team [%s]\n", new Object[]{aData.agileTeamName});
                }
            }
            if (Strings.isValid((String)aData.agileSprintName) && (sprint = this.getAgileSprint(aData.agileTeamName, aData.agileSprintName)) == null) {
                rd.errorf("Invalid sprint name [%s] for team [%s]\n", new Object[]{aData.agileSprintName, aData.agileTeamName});
            }
            if (!Strings.isValid((String)aData.agilePoints)) continue;
            aTeam = this.getAgileTeamByName(aData.agileTeamName);
            if (aTeam == null) {
                rd.errorf("Invalid team name [%s] for points [%s]\n", new Object[]{aData.agileTeamName, aData.agilePoints});
                continue;
            }
            AttributeTypeToken pointsAttrType = this.atsApi.getAgileService().getAgileTeamPointsAttributeType(aTeam);
            if (pointsAttrType != null) continue;
            rd.errorf("Points not configured for team [%s]\n", new Object[]{aData.agileTeamName});
        }
    }

    private void createActionDatas(EFile eFile) {
        boolean last = false;
        for (ERow row : ((EWorksheet)eFile.getWorkbook().getSheets().iterator().next()).getRows()) {
            ActionData actionData = new ActionData();
            for (ECell cell : row.getCells()) {
                if (cell.getCol().is((NamedId)ActionColumns.Title)) {
                    actionData.title = this.validateAndGet(cell);
                    continue;
                }
                if (cell.getCol().is((NamedId)ActionColumns.Description)) {
                    actionData.desc = this.validateAndGet(cell);
                    continue;
                }
                if (cell.getCol().is((NamedId)ActionColumns.ActionableItems)) {
                    actionData.actionableItems = this.validateAndGet(cell, ";");
                    continue;
                }
                if (cell.getCol().is((NamedId)ActionColumns.Assignees)) {
                    actionData.assigneeStrs = this.validateAndGet(cell, ";");
                    continue;
                }
                if (cell.getCol().is((NamedId)ActionColumns.Originator)) {
                    String name = cell.getValue();
                    if (!Strings.isValid((String)name)) continue;
                    AtsUser user = this.atsApi.getUserService().getUserByName(name);
                    if (user != null) {
                        actionData.originator = user;
                        continue;
                    }
                    this.rd.errorf("Originator [%s] is invalid", new Object[]{name});
                    continue;
                }
                if (cell.getCol().is((NamedId)ActionColumns.ChangeType)) {
                    actionData.changeType = this.getOrBlank(cell);
                    continue;
                }
                if (cell.getCol().is((NamedId)ActionColumns.Priority)) {
                    actionData.priorityStr = this.getOrBlank(cell);
                    continue;
                }
                if (cell.getCol().is((NamedId)ActionColumns.Version)) {
                    actionData.version = this.getOrBlank(cell);
                    continue;
                }
                if (cell.getCol().is((NamedId)ActionColumns.AgilePoints)) {
                    actionData.agilePoints = this.getOrBlank(cell);
                    continue;
                }
                if (cell.getCol().is((NamedId)ActionColumns.EstimatedHours)) {
                    actionData.estimatedHours = Strings.isNumeric((String)cell.getValue()) ? Double.valueOf(cell.getValue()) : 0.0;
                    continue;
                }
                if (cell.getCol().is((NamedId)ActionColumns.AgileSprintName)) {
                    actionData.agileSprintName = this.getOrBlank(cell);
                    continue;
                }
                if (cell.getCol().is((NamedId)ActionColumns.AgileTeamName)) {
                    actionData.agileTeamName = this.getOrBlank(cell);
                    continue;
                }
                String value = cell.getValue();
                Object obj = cell.getCol().getStoreType();
                if (obj instanceof AttributeTypeToken) {
                    AttributeTypeToken attrType = (AttributeTypeToken)obj;
                    JaxAttribute attr = new JaxAttribute();
                    attr.setAttrType(attrType);
                    attr.getValues().add(value);
                    actionData.attributes.add(attr);
                    continue;
                }
                this.rd.errorf("No Attribute Type for cell with value %s\n", new Object[]{cell.toString()});
            }
            if (last) break;
            this.actionDatas.add(actionData);
        }
    }

    private String getOrBlank(ECell cell) {
        return Strings.isValid((String)cell.getValue()) ? cell.getValue() : "";
    }

    private String validateAndGet(ECell cell) {
        String value = cell.getValue();
        if (Strings.isInvalid((String)value)) {
            this.rd.errorf(String.valueOf(cell.getCol().getName()) + " must be specified for %s\n", new Object[]{cell.toString()});
            return "";
        }
        return value;
    }

    private Collection<String> validateAndGet(ECell cell, String separator) {
        ArrayList<String> values = new ArrayList<String>();
        String value = cell.getValue();
        if (Strings.isInvalid((String)value)) {
            this.rd.errorf(String.valueOf(cell.getCol().getName()) + " must be specified for %s\n", new Object[]{cell.toString()});
        } else {
            String[] stringArray = value.split(separator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                values.add(val);
                ++n2;
            }
        }
        return values;
    }

    private void createArtifactsAndNotify(IAtsChangeSet changes) {
        AtsUtilClient.setEmailEnabled(false);
        HashSet<IAtsTeamWorkflow> teamWfs = new HashSet<IAtsTeamWorkflow>();
        Date createdDate = new Date();
        try {
            try {
                AtsUser createdBy = this.atsApi.getUserService().getCurrentUser();
                for (ActionData aData : this.actionDatas) {
                    ActionResult actionResult = this.actionNameToAction.get(aData.title);
                    if (actionResult == null) {
                        ChangeTypes changeType = this.getChangeType(aData);
                        String priorityStr = this.getPriority(aData);
                        ActionResult aResult = this.atsApi.getActionService().createAction(null, aData.title, aData.desc, changeType, priorityStr, false, null, (Collection)this.atsApi.getActionableItemService().getActionableItems(aData.actionableItems), createdDate, createdBy, null, changes);
                        this.actionNameToAction.put(aData.title, aResult);
                        for (IAtsTeamWorkflow teamWf : aResult.getTeamWfs()) {
                            this.processTeamWorkflow(changes, aData, teamWf);
                            teamWfs.add(teamWf);
                        }
                        this.actionArts.add(this.atsApi.getQueryServiceIde().getArtifact(aResult.getActionArt()));
                        continue;
                    }
                    HashSet<IAtsActionableItem> aias = new HashSet<IAtsActionableItem>();
                    for (String actionableItemName : aData.actionableItems) {
                        for (Artifact aiaArt : ArtifactQuery.getArtifactListFromTypeAndName((ArtifactTypeId)AtsArtifactTypes.ActionableItem, (String)actionableItemName, (BranchId)this.atsApi.getAtsBranch())) {
                            ActionableItem ai = this.atsApi.getActionableItemService().getActionableItemById((ArtifactId)aiaArt);
                            if (ai == null) continue;
                            aias.add((IAtsActionableItem)ai);
                        }
                    }
                    Map<IAtsTeamDefinition, Collection<IAtsActionableItem>> teamDefToAias = this.getTeamDefToAias(aias);
                    for (Map.Entry<IAtsTeamDefinition, Collection<IAtsActionableItem>> entry : teamDefToAias.entrySet()) {
                        IAtsTeamWorkflow teamWf = this.atsApi.getActionService().createTeamWorkflow(actionResult.getAction(), entry.getKey(), entry.getValue(), aData.assignees, changes, createdDate, createdBy, null, new CreateTeamOption[]{CreateTeamOption.Duplicate_If_Exists});
                        actionResult.getTeamWfs().add(teamWf);
                        this.processTeamWorkflow(changes, aData, teamWf);
                        teamWfs.add(teamWf);
                    }
                }
                AtsUtilClient.setEmailEnabled(true);
                if (this.emailPOCs) {
                    for (IAtsTeamWorkflow teamWf : teamWfs) {
                        try {
                            changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((AtsUser)this.atsApi.getUserService().getCurrentUser(), (IAtsWorkItem)teamWf, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Assigned}));
                        }
                        catch (OseeCoreException ex) {
                            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error adding ATS Notification Event", (Throwable)ex);
                        }
                    }
                }
                WorldEditor.open(new WorldEditorSimpleProvider(this.getName(), AtsObjects.getArtifacts(teamWfs)));
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                AtsUtilClient.setEmailEnabled(true);
            }
        }
        finally {
            AtsUtilClient.setEmailEnabled(true);
        }
    }

    private String getPriority(ActionData aData) {
        String priorityStr = "3";
        if (Strings.isValid((String)aData.priorityStr)) {
            priorityStr = aData.priorityStr;
        }
        return priorityStr;
    }

    private ChangeTypes getChangeType(ActionData aData) {
        ChangeTypes changeType = ChangeTypes.None;
        if (Strings.isValid((String)aData.changeType)) {
            changeType = ChangeTypes.getChangeType((Object)aData.changeType);
        }
        return changeType;
    }

    private void processTeamWorkflow(IAtsChangeSet changes, ActionData aData, IAtsTeamWorkflow teamWf) {
        ChangeTypes changeType = this.getChangeType(aData);
        String priorityStr = this.getPriority(aData);
        changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.Description, aData.desc);
        changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.Priority, priorityStr);
        changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.ChangeType, changeType.name());
        this.addToAgile(changes, aData, teamWf);
        for (JaxAttribute attr : aData.attributes) {
            AttributeTypeToken attrType = attr.getAttrType();
            changes.setAttributeValues((IAtsObject)teamWf, attrType, attr.getValues());
        }
        this.addToGoal(Collections.singleton((TeamWorkFlowArtifact)teamWf.getStoreObject()), changes);
        if (!aData.version.equals("")) {
            IAtsTeamDefinition teamDefHoldVer = this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(teamWf.getTeamDefinition());
            IAtsVersion version = this.atsApi.getVersionService().getVersion(teamDefHoldVer, aData.version);
            if (version == null) {
                this.rd.errorf("No version [%s] configured for Team Definition [%s]\n", new Object[]{aData.version, teamWf.getTeamDefinition()});
            }
            this.atsApi.getVersionService().setTargetedVersion(teamWf, version, changes);
        }
        if (aData.estimatedHours != null) {
            changes.setSoleAttributeValue((ArtifactId)teamWf, (AttributeTypeToken)AtsAttributeTypes.EstimatedHours, (Object)aData.estimatedHours);
        }
        if (aData.assigneeStrs.size() > 0) {
            changes.setAssignees((IAtsWorkItem)teamWf, aData.assignees);
        }
        if (aData.originator != null) {
            changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.CreatedBy, aData.originator.getUserId());
        }
    }

    private void addToAgile(IAtsChangeSet changes, ActionData aData, IAtsTeamWorkflow teamWf) {
        IAgileSprint sprint;
        IAgileBacklog backlog;
        if (Strings.isValid((String)aData.agileTeamName) && (backlog = this.getAgileBacklog(aData.agileTeamName)) != null) {
            changes.relate((Object)backlog, AtsRelationTypes.Goal_Member, (Object)teamWf);
        }
        if (Strings.isValid((String)aData.agileSprintName) && (sprint = this.getAgileSprint(aData.agileTeamName, aData.agileSprintName)) != null) {
            changes.relate((Object)sprint, AtsRelationTypes.AgileSprintToItem_AtsItem, (Object)teamWf);
        }
        if (Strings.isValid((String)aData.agilePoints)) {
            IAgileTeam aTeam = this.getAgileTeamByName(aData.agileTeamName);
            AttributeTypeToken attrType = this.atsApi.getAgileService().getAgileTeamPointsAttributeType(aTeam);
            if (attrType.getId().equals(AtsAttributeTypes.Points.getId())) {
                changes.setSoleAttributeValue((IAtsWorkItem)teamWf, attrType, aData.agilePoints);
            } else if (attrType.getId().equals(AtsAttributeTypes.PointsNumeric.getId())) {
                changes.setSoleAttributeValue((IAtsObject)teamWf, attrType, (Object)Double.valueOf(aData.agilePoints));
            } else {
                throw new OseeArgumentException("Un-configured pointes types for team %s", new Object[]{teamWf.getTeamDefinition().toStringWithId()});
            }
        }
    }

    private IAgileTeam getAgileTeamByName(String agileTeamName) {
        IAgileTeam aTeam;
        IAgileTeam team = this.teamNameByTeamMap.get(agileTeamName);
        if (team == null && (aTeam = this.atsApi.getAgileService().getAgileTeamByName(agileTeamName)) != null) {
            this.teamNameByTeamMap.put(agileTeamName, aTeam);
            team = aTeam;
        }
        return team;
    }

    private IAgileSprint getAgileSprint(String agileTeamName, String agileSprintName) {
        IAgileTeam aTeam = this.getAgileTeamByName(agileTeamName);
        if (aTeam != null) {
            for (IAgileSprint teamSprint : this.atsApi.getAgileService().getAgileSprints(aTeam)) {
                if (!teamSprint.getName().equals(agileSprintName)) continue;
                return teamSprint;
            }
        }
        return null;
    }

    private IAgileBacklog getAgileBacklog(String agileTeamName) {
        IAgileTeam aTeam = this.atsApi.getAgileService().getAgileTeamByName(agileTeamName);
        if (aTeam != null) {
            return this.atsApi.getAgileService().getAgileBacklog(aTeam);
        }
        return null;
    }

    private void addToGoal(Collection<TeamWorkFlowArtifact> newTeamArts, IAtsChangeSet changes) {
        if (this.toGoal != null) {
            GoalArtifact goal = (GoalArtifact)this.atsApi.getQueryService().getArtifact((IAtsObject)this.toGoal);
            if (goal == null) {
                throw new OseeArgumentException("Goal artifact does not exist for goal %s", new Object[]{this.toGoal.toStringWithId()});
            }
            for (Artifact artifact : newTeamArts) {
                goal.addMember((ArtifactId)artifact);
            }
            changes.add((Object)goal);
        }
    }

    public Map<IAtsTeamDefinition, Collection<IAtsActionableItem>> getTeamDefToAias(Collection<IAtsActionableItem> aias) {
        HashMap<IAtsTeamDefinition, Collection<IAtsActionableItem>> teamDefToAias = new HashMap<IAtsTeamDefinition, Collection<IAtsActionableItem>>();
        for (IAtsActionableItem aia : aias) {
            IAtsTeamDefinition teamDef = (IAtsTeamDefinition)this.atsApi.getTeamDefinitionService().getImpactedTeamDefs(Arrays.asList(aia)).iterator().next();
            if (teamDefToAias.containsKey(teamDef)) {
                ((Collection)teamDefToAias.get(teamDef)).add(aia);
                continue;
            }
            teamDefToAias.put(teamDef, Arrays.asList(aia));
        }
        return teamDefToAias;
    }

    public String getDescription() {
        return "Extract each row as an Action";
    }

    public Set<Artifact> getActionArts() {
        return this.actionArts;
    }

    public String getName() {
        return "Excel Ats Actions";
    }

    public List<ActionData> getActionDatas() {
        return this.actionDatas;
    }
}

