/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.Import.action;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.util.Import.action.ImportActionsOperation;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.XButtonPush;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ImportActionsViaSpreadsheetBlam
extends AbstractBlam {
    private static final String OPEN_EXCEL_SPREADSHEET = "Open Excel Import Example Spreadsheet";
    public static final String NAME = "Import Actions Via Spreadsheet";

    public String getName() {
        return NAME;
    }

    protected boolean includeGoalWidget() {
        return true;
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        XWidgetBuilder wb = new XWidgetBuilder();
        wb.andXButtonPush(OPEN_EXCEL_SPREADSHEET).andDisplayLabel(false).endWidget();
        wb.andWidget("Excel Spreadsheet saved as xml", "XFileTextWithSelectionDialog").endWidget();
        wb.andXCheckbox("Email POCs");
        wb.andXCheckbox("Persist");
        wb.andWidget("Add to Goal", "XGoalCombo").andHorizLabel().andLabelAfter().endWidget();
        return wb.getItems();
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        try {
            boolean isValid;
            String path = variableMap.getString("Excel Spreadsheet saved as xml");
            File file = new File(path);
            boolean bl = isValid = Strings.isValid((String)path) && path.endsWith(".xml") && file.isFile();
            if (!isValid) {
                AWorkbench.popup((String)"File is not a valid xml file");
                return;
            }
            boolean emailPocs = variableMap.getBoolean("Email POCs");
            boolean persist = variableMap.getBoolean("Persist");
            try {
                this.importActions(file, null, ImportOption.POPUP_ERROR_REPORT, emailPocs ? ImportOption.EMAIL_POCS : ImportOption.NONE, persist ? ImportOption.PERSIST : ImportOption.NONE);
            }
            catch (Exception ex) {
                this.log(ex);
            }
        }
        finally {
            monitor.subTask("Done");
        }
    }

    public XResultData importActions(File file, IAtsGoal toGoal, ImportOption ... importOption) throws Exception {
        boolean emailPocs = Arrays.asList(importOption).contains((Object)ImportOption.EMAIL_POCS);
        boolean persist = Arrays.asList(importOption).contains((Object)ImportOption.PERSIST);
        boolean popupReport = Arrays.asList(importOption).contains((Object)ImportOption.POPUP_ERROR_REPORT);
        ImportActionsOperation op = new ImportActionsOperation(file, emailPocs, toGoal, persist, NAME);
        XResultData rd = op.run();
        if (rd.isErrors() && popupReport) {
            XResultDataUI.report((XResultData)rd, (String)this.getName());
        }
        return rd;
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals(OPEN_EXCEL_SPREADSHEET)) {
            XButtonPush button = (XButtonPush)xWidget;
            button.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    try {
                        File file = ImportActionsViaSpreadsheetBlam.this.getSampleSpreadsheetFile();
                        Program.launch((String)file.getCanonicalPath());
                    }
                    catch (Exception ex) {
                        ImportActionsViaSpreadsheetBlam.this.log(ex);
                    }
                }
            });
        }
    }

    public File getSampleSpreadsheetFile() throws Exception {
        return OseeInf.getResourceAsFile((String)"atsImport/Action_Import.xml", ((Object)((Object)this)).getClass());
    }

    public String getDescriptionUsage() {
        return "Import Actions via Excel Spreadsheet.\n Open example spreadsheet, save to desktop and edit as desired. Once completed, select file from this BLAM and Run.  Titles that are the same are placed under the same action.  After \"Estimated Hours\", remaining columns will attempt to match column name with valid attribute type name add that to Task.";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AtsNavigateViewItems.ATS_IMPORT);
    }

    public Image getImage() {
        return ImageManager.getImage((KeyedImage)FrameworkImage.IMPORT);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.IMPORT);
    }

    public static enum ImportOption {
        EMAIL_POCS,
        POPUP_ERROR_REPORT,
        PERSIST,
        NONE;

    }
}

