/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkBranchViewSelect;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkWorkDefDam;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.ui.skynet.widgets.XBranchSelectWidgetDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XOption;
import org.eclipse.osee.framework.ui.skynet.widgets.XTextFlatDam;
import org.eclipse.osee.framework.ui.skynet.widgets.util.DefaultAttributeXWidgetProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;

public class AtsAttributeXWidgetProvider
extends DefaultAttributeXWidgetProvider {
    private static final Collection<AttributeTypeId> xFlatAttributeTypes = new ArrayList<AttributeTypeId>();
    private static final Map<AttributeTypeToken, ArtifactTypeToken> artRefAttrTypeToValidArtType = new HashMap<AttributeTypeToken, ArtifactTypeToken>();
    private static final Collection<AttributeTypeToken> artRefAttributeTypes;

    static {
        xFlatAttributeTypes.add((AttributeTypeId)CoreAttributeTypes.WorkTransition);
        xFlatAttributeTypes.add((AttributeTypeId)CoreAttributeTypes.WorkData);
        xFlatAttributeTypes.add((AttributeTypeId)AtsAttributeTypes.CurrentStateAssignee);
        xFlatAttributeTypes.add((AttributeTypeId)AtsAttributeTypes.BitConfig);
        xFlatAttributeTypes.add((AttributeTypeId)AtsAttributeTypes.CSCI);
        xFlatAttributeTypes.add((AttributeTypeId)AtsAttributeTypes.TaskSetId);
        xFlatAttributeTypes.add((AttributeTypeId)AtsAttributeTypes.WorkType);
        xFlatAttributeTypes.add((AttributeTypeId)AtsAttributeTypes.JournalSubscriber);
        artRefAttrTypeToValidArtType.put((AttributeTypeToken)AtsAttributeTypes.ActionableItemReference, AtsArtifactTypes.ActionableItem);
        artRefAttrTypeToValidArtType.put((AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, AtsArtifactTypes.TeamDefinition);
        artRefAttrTypeToValidArtType.put((AttributeTypeToken)AtsAttributeTypes.ProgramId, AtsArtifactTypes.Program);
        artRefAttrTypeToValidArtType.put((AttributeTypeToken)AtsAttributeTypes.RelatedPeerWorkflowDefinitionReference, AtsArtifactTypes.TeamDefinition);
        artRefAttrTypeToValidArtType.put((AttributeTypeToken)AtsAttributeTypes.RelatedTaskWorkflowDefinitionReference, AtsArtifactTypes.TeamDefinition);
        artRefAttrTypeToValidArtType.put((AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactReference, AtsArtifactTypes.TeamDefinition);
        artRefAttributeTypes = artRefAttrTypeToValidArtType.keySet();
    }

    public List<XWidgetRendererItem> getDynamicXWidgetLayoutData(ArtifactTypeToken artType, AttributeTypeToken attributeType) {
        List<XWidgetRendererItem> layouts = new ArrayList();
        if (attributeType.equals(AtsAttributeTypes.BaselineBranchId)) {
            layouts = super.getDynamicXWidgetLayoutData(artType, attributeType);
            XWidgetRendererItem layoutData = (XWidgetRendererItem)layouts.get(0);
            layoutData.setXWidgetName(XBranchSelectWidgetDam.WIDGET_ID);
        } else if (xFlatAttributeTypes.contains(attributeType)) {
            layouts = super.getDynamicXWidgetLayoutData(artType, attributeType);
            XWidgetRendererItem layoutData = (XWidgetRendererItem)layouts.get(0);
            layoutData.setXWidgetName(XTextFlatDam.WIDGET_ID);
        } else if (attributeType.matches(new Id[]{AtsAttributeTypes.TestRunToSourceLocator})) {
            layouts = super.getDynamicXWidgetLayoutData(artType, attributeType);
            XWidgetRendererItem layoutData = layouts.get(0);
            layoutData.getXOptionHandler().add(XOption.FILL_VERTICALLY);
        } else if (attributeType.matches(new Id[]{AtsAttributeTypes.WorkflowDefinitionReference})) {
            layouts = super.getDynamicXWidgetLayoutData(artType, attributeType);
            XWidgetRendererItem layoutData = layouts.get(0);
            layoutData.setXWidgetName(XHyperlinkWorkDefDam.class.getSimpleName());
        } else if (attributeType.matches(new Id[]{AtsAttributeTypes.VersionBranchView})) {
            layouts = super.getDynamicXWidgetLayoutData(artType, attributeType);
            XWidgetRendererItem layoutData = layouts.get(0);
            layoutData.setXWidgetName(XHyperlinkBranchViewSelect.class.getSimpleName());
        } else if (artRefAttributeTypes.contains(attributeType)) {
            layouts = super.getDynamicXWidgetLayoutData(artType, attributeType);
            XWidgetRendererItem layoutData = layouts.get(0);
            ArtifactTypeToken newArtType = artRefAttrTypeToValidArtType.get(attributeType);
            if (newArtType.isValid()) {
                layoutData.setArtifactType(newArtType);
            }
            layoutData.setXWidgetName(XTextFlatDam.WIDGET_ID);
        }
        return layouts;
    }
}

