/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.define.rest.api.git.GitEndpoint;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XButton;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.widgets.Shell;

public class XGitFetchButton
extends XButton
implements ArtifactWidget {
    private TeamWorkFlowArtifact teamArt;
    private final XModifiedListener listener = new XModifiedListener(){

        public void widgetModified(XWidget widget) {
            try {
                BranchToken workingBranch = AtsApiService.get().getBranchService().getBranch((IAtsTeamWorkflow)XGitFetchButton.this.teamArt);
                if (workingBranch.isValid()) {
                    String workingBranchName = AtsApiService.get().getBranchService().getBranchName((IAtsTeamWorkflow)XGitFetchButton.this.teamArt);
                    String repositoryName = (String)XGitFetchButton.this.teamArt.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.GitRepoName);
                    String branchName = (String)XGitFetchButton.this.teamArt.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.GitBranchName);
                    if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Fetch Git Data", (String)String.format("Fetch git code files for:\n\"%s\"\n\n On git branch:\n\"%s\"\n\nfor OSEE branch: \n\"%s\"\n\nIs that correct?\n\n---\nNOTE: Only need to do when git branch not yet merged for traceability.", repositoryName, branchName, workingBranchName))) {
                        GitEndpoint proxy = AtsApiService.get().getOseeClient().getGitEndpoint();
                        if (proxy.getRemoteBranches((BranchId)workingBranch, repositoryName).contains(branchName)) {
                            proxy.updateGitTrackingBranch((BranchId)workingBranch, repositoryName, true, true, branchName);
                        } else {
                            MessageDialog.openError((Shell)Displays.getActiveShell(), (String)"Branch does not exist", (String)String.format("The branch [%s] does not exist or is invalid.", branchName));
                        }
                    }
                    XGitFetchButton.this.button.redraw();
                    XGitFetchButton.this.button.getParent().layout();
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    };

    public XGitFetchButton() {
        super("Import Code Files from Branch");
        this.setImage(ImageManager.getImage((OseeImage)AtsImage.PLAY_GREEN));
        this.setToolTip("Fetch Git Data");
        this.addXModifiedListener(this.listener);
        this.teamArt = null;
    }

    public TeamWorkFlowArtifact getArtifact() {
        return this.teamArt;
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void revert() {
    }

    public void saveToArtifact() {
    }

    public void setArtifact(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            this.teamArt = (TeamWorkFlowArtifact)artifact;
        }
    }

    public boolean isEditable() {
        return this.teamArt != null;
    }
}

