/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.AttributeWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkWithFilteredDialog;
import org.eclipse.osee.framework.ui.swt.Widgets;

public class XHyperlinkBranchViewSelect
extends XHyperlinkWithFilteredDialog<ArtifactToken>
implements AttributeWidget {
    private Artifact versionArt;

    public XHyperlinkBranchViewSelect() {
        super("Branch View");
    }

    protected boolean isSelectable() {
        if (AtsApiService.get().getUserService().isAtsAdmin()) {
            return true;
        }
        AWorkbench.popup((String)"Must be ATS Admin to change");
        return false;
    }

    public Collection<ArtifactToken> getSelectable() {
        Version version = AtsApiService.get().getVersionService().getVersionById((ArtifactId)this.versionArt);
        return AtsApiService.get().getBranchService().getBranchViews((IAtsVersion)version);
    }

    public String getCurrentValue() {
        String result = Widgets.NOT_SET;
        if (this.versionArt != null) {
            Version version = AtsApiService.get().getVersionService().getVersionById((ArtifactId)this.versionArt);
            ArtifactId versionBranchViewId = (ArtifactId)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((ArtifactId)this.versionArt, (AttributeTypeToken)AtsAttributeTypes.VersionBranchView, (Object)ArtifactId.SENTINEL);
            BranchToken baselineBranch = AtsApiService.get().getBranchService().getBranch((IAtsConfigObject)version);
            ArtifactToken versionBranchView = AtsApiService.get().getQueryService().getArtifact(versionBranchViewId, (BranchId)baselineBranch);
            if (versionBranchView.isValid()) {
                result = versionBranchView.getName();
            }
        }
        return result;
    }

    public Artifact getArtifact() {
        return this.versionArt;
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    protected void handleSelectionPersist(ArtifactToken branchView) {
        Version version = AtsApiService.get().getVersionService().getVersionById((ArtifactId)this.versionArt);
        AtsApiService.get().getBranchService().setBranchView((IAtsVersion)version, (ArtifactId)branchView);
        this.versionArt.reloadAttributesAndRelations();
        ArtifactEvent artifactEvent = new ArtifactEvent((BranchId)this.versionArt.getBranch());
        artifactEvent.addArtifact(this.versionArt);
        OseeEventManager.kickPersistEvent(XHyperlinkBranchViewSelect.class, (ArtifactEvent)artifactEvent);
    }

    public boolean isEditable() {
        return true;
    }

    public void setAttributeType(Artifact artifact, AttributeTypeToken attributeTypeToken) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Version})) {
            this.versionArt = artifact;
        } else {
            OseeLog.log(((Object)((Object)this)).getClass(), (Level)Level.SEVERE, (String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " - can only be used with ATS Version Artifact"));
        }
        this.refresh();
    }
}

