/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.VersionListDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelCmdValueSelection;

public class XTargetedVersionHyperlinkWidget
extends XHyperlinkLabelCmdValueSelection {
    IAtsVersion version;
    Collection<IAtsVersion> selectable = new HashSet<IAtsVersion>();
    IAtsTeamDefinition teamDef;
    AtsApi atsApi = AtsApiService.get();

    public XTargetedVersionHyperlinkWidget() {
        super("Targeted Version", true, Integer.valueOf(50));
    }

    public String getCurrentValue() {
        return this.version == null ? "" : this.version.getName();
    }

    public boolean handleSelection() {
        VersionListDialog dialog = null;
        if (!this.selectable.isEmpty()) {
            dialog = new VersionListDialog("Select Version", "Select Version", this.selectable);
        } else if (this.teamDef != null || this.getTeamId().isValid()) {
            IAtsTeamDefinition useTeamDef = IAtsTeamDefinition.SENTINEL;
            if (this.teamDef != null) {
                useTeamDef = this.teamDef;
            } else if (this.getTeamId().isValid()) {
                useTeamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById(this.getTeamId());
            }
            IAtsTeamDefinition definitionHoldingVersions = this.atsApi.getVersionService().getTeamDefinitionHoldingVersions(useTeamDef);
            Collection versions = AtsApiService.get().getVersionService().getVersions(definitionHoldingVersions);
            dialog = new VersionListDialog("Select Version", "Select Version", versions);
        }
        if (dialog == null) {
            return false;
        }
        int result = dialog.open();
        if (result != 0) {
            return false;
        }
        Object obj = dialog.getSelectedFirst();
        this.version = (IAtsVersion)obj;
        return true;
    }

    public boolean handleClear() {
        this.version = null;
        return true;
    }

    public IAtsVersion getSelected() {
        return this.version;
    }

    public Collection<IAtsVersion> getSelectable() {
        return this.selectable;
    }

    public void setSelectable(Collection<IAtsVersion> selectable) {
        this.selectable = selectable;
    }

    public void setVersion(IAtsVersion version) {
        this.version = version;
    }

    public IAtsTeamDefinition getTeamDef() {
        return this.teamDef;
    }

    public void setTeamDef(IAtsTeamDefinition teamDef) {
        this.teamDef = teamDef;
    }

    public void setSelected(IAtsVersion version) {
        this.version = version;
    }
}

