/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.commit;

import java.util.Date;
import java.util.Objects;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.commit.CommitConfigItem;
import org.eclipse.osee.ats.api.commit.CommitOverride;
import org.eclipse.osee.ats.api.commit.CommitStatus;
import org.eclipse.osee.ats.api.workflow.IAtsBranchService;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.commit.CommitXManager;
import org.eclipse.osee.ats.ide.util.widgets.commit.CommitXManagerFactory;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public class XCommitLabelProvider
extends XViewerLabelProvider {
    private final CommitXManager commitXManager;
    private final IAtsTeamWorkflow teamWf;

    public XCommitLabelProvider(CommitXManager commitXManager, IAtsTeamWorkflow teamWf) {
        super((XViewer)commitXManager);
        this.commitXManager = commitXManager;
        this.teamWf = teamWf;
    }

    public Image getColumnImage(Object element, XViewerColumn xCol, int columnIndex) {
        CommitStatus commitStatus;
        BranchId branch = null;
        if (element instanceof CommitConfigItem) {
            CommitConfigItem configItem = (CommitConfigItem)element;
            branch = AtsApiService.get().getBranchService().getBranch(configItem);
        } else if (element instanceof TransactionToken) {
            TransactionToken txRecord = (TransactionToken)element;
            branch = txRecord.getBranch();
        } else {
            throw new OseeArgumentException("Unhandled element type [%s]", new Object[]{element.getClass().toString()});
        }
        if (xCol.equals((Object)CommitXManagerFactory.Action_Col)) {
            return ImageManager.getImage((KeyedImage)FrameworkImage.ARROW_RIGHT_YELLOW);
        }
        if (branch == null) {
            return null;
        }
        if (xCol.equals((Object)CommitXManagerFactory.Status_Col)) {
            try {
                commitStatus = AtsApiService.get().getBranchService().getCommitStatus((IAtsTeamWorkflow)this.commitXManager.getXCommitViewer().getTeamArt(), branch);
                if (commitStatus == CommitStatus.Branch_Not_Configured || commitStatus == CommitStatus.Branch_Commit_Disabled || commitStatus == CommitStatus.Commit_Needed || commitStatus == CommitStatus.Working_Branch_Not_Created) {
                    return ImageManager.getImage((KeyedImage)FrameworkImage.DOT_RED);
                }
                if (commitStatus == CommitStatus.Merge_In_Progress) {
                    return ImageManager.getImage((KeyedImage)FrameworkImage.DOT_YELLOW);
                }
                if (commitStatus == CommitStatus.Committed || commitStatus == CommitStatus.Committed_With_Merge || commitStatus == CommitStatus.No_Commit_Needed || commitStatus == CommitStatus.Commit_Overridden) {
                    return ImageManager.getImage((KeyedImage)FrameworkImage.DOT_GREEN);
                }
                return null;
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        } else if (xCol.equals((Object)CommitXManagerFactory.Merge_Col)) {
            try {
                commitStatus = AtsApiService.get().getBranchService().getCommitStatus((IAtsTeamWorkflow)this.commitXManager.getXCommitViewer().getTeamArt(), branch);
                if (commitStatus == CommitStatus.Merge_In_Progress || commitStatus == CommitStatus.Committed_With_Merge) {
                    return ImageManager.getImage((KeyedImage)FrameworkImage.OUTGOING_MERGED);
                }
                return null;
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return null;
    }

    public String getColumnText(Object element, XViewerColumn xCol, int columnIndex) {
        BranchId branch;
        if (element instanceof CommitConfigItem) {
            CommitConfigItem configItem = (CommitConfigItem)element;
            if (!AtsApiService.get().getBranchService().isBranchValid(configItem)) {
                return String.format("Branch not configured for [%s]", element);
            }
            branch = configItem.getBaselineBranchId();
        } else if (element instanceof TransactionToken) {
            TransactionToken txRecord = (TransactionToken)element;
            branch = txRecord.getBranch();
        } else {
            throw new OseeArgumentException("Unhandled element type [%s]", new Object[]{element.getClass().toString()});
        }
        if (xCol.equals((Object)CommitXManagerFactory.Status_Col)) {
            CommitStatus status = AtsApiService.get().getBranchService().getCommitStatus((IAtsTeamWorkflow)this.commitXManager.getXCommitViewer().getTeamArt(), branch);
            if (status == CommitStatus.Commit_Overridden) {
                CommitOverride override = AtsApiService.get().getBranchService().getCommitOverrideOps().getCommitOverride(this.teamWf, branch);
                Objects.requireNonNull(override, "Override can not be null");
                String userName = AtsApiService.get().getUserService().getUserById((ArtifactId)override.getUser()).getName();
                return String.format("%s by %s - Reason: [%s]", status.getDisplayName(), userName, override.getReason());
            }
            return status.getDisplayName();
        }
        if (xCol.equals((Object)CommitXManagerFactory.Merge_Col)) {
            return "";
        }
        if (xCol.equals((Object)CommitXManagerFactory.Version_Col)) {
            return this.handleVersionColumn(element);
        }
        if (xCol.equals((Object)CommitXManagerFactory.Configuring_Object_Col)) {
            return this.handleArtifactTypeNameColumn(element);
        }
        if (xCol.equals((Object)CommitXManagerFactory.Commit_Date)) {
            return this.handleCommitDateColumn(branch);
        }
        if (xCol.equals((Object)CommitXManagerFactory.Commit_Comment)) {
            return this.handleCommitCommentColumn(branch);
        }
        if (xCol.equals((Object)CommitXManagerFactory.Dest_Branch_Col)) {
            return this.handleDestBranchColumn(element, branch);
        }
        if (xCol.equals((Object)CommitXManagerFactory.Dest_Branch_Create_Date_Col)) {
            return this.handleDestBranchCreationDateColumn(element, branch);
        }
        if (xCol.equals((Object)CommitXManagerFactory.Action_Col)) {
            return this.handleActionColumn(branch);
        }
        return "unhandled column";
    }

    private String handleVersionColumn(Object element) {
        if (element instanceof CommitConfigItem) {
            return ((CommitConfigItem)element).getConfigObject().getName();
        }
        return "";
    }

    private String handleArtifactTypeNameColumn(Object element) {
        if (element instanceof CommitConfigItem) {
            return ((CommitConfigItem)element).getName();
        }
        return "";
    }

    private String handleCommitDateColumn(BranchId branch) {
        TransactionRecord transactionRecord = this.getTransactionRecord(branch);
        if (transactionRecord.isValid()) {
            new DateUtil();
            return DateUtil.getMMDDYYHHMM((Date)transactionRecord.getTimeStamp());
        }
        return "Not Committed";
    }

    private String handleCommitCommentColumn(BranchId branch) {
        TransactionRecord transactionRecord = this.getTransactionRecord(branch);
        if (transactionRecord.isValid()) {
            return transactionRecord.getComment();
        }
        return "Not Committed";
    }

    private TransactionRecord getTransactionRecord(BranchId branch) {
        IAtsBranchService service = AtsApiService.get().getBranchService();
        TeamWorkFlowArtifact teamWf = this.commitXManager.getXCommitViewer().getTeamArt();
        return service.getCommitTransactionRecord((IAtsTeamWorkflow)teamWf, branch);
    }

    private String handleDestBranchColumn(Object element, BranchId branchToken) {
        BranchToken branch = BranchManager.getBranchToken((BranchId)branchToken);
        if (element instanceof CommitConfigItem) {
            CommitConfigItem configItem = (CommitConfigItem)element;
            return branch == null ? String.format("Parent Branch Not Configured for %s [%s]", configItem.getConfigObject().getArtifactType(), configItem.getConfigObject()) : branch.getShortName();
        }
        if (element instanceof TransactionRecord) {
            return branch.getShortName();
        }
        return "";
    }

    private String handleDestBranchCreationDateColumn(Object element, BranchId branch) {
        if (element instanceof CommitConfigItem) {
            CommitConfigItem configItem = (CommitConfigItem)element;
            String configType = configItem.getConfigObject().getArtifactType().getName();
            return this.getColumnText(configType, element, branch);
        }
        if (element instanceof TransactionRecord) {
            return this.getColumnText(null, element, branch);
        }
        return "";
    }

    private String getColumnText(String elementType, Object element, BranchId branch) {
        if (branch == null) {
            return "Parent Branch Not Configured for " + elementType + " [" + element + "]";
        }
        return DateUtil.getMMDDYYHHMM((Date)BranchManager.getBaseTransaction((BranchId)branch).getTimeStamp());
    }

    private String handleActionColumn(BranchId branch) {
        CommitStatus commitStatus = AtsApiService.get().getBranchService().getCommitStatus((IAtsTeamWorkflow)this.commitXManager.getXCommitViewer().getTeamArt(), branch);
        if (commitStatus == CommitStatus.Rebaseline_In_Progress) {
            return "Finish Update";
        }
        if (commitStatus == CommitStatus.Branch_Not_Configured) {
            return "Configure Branch";
        }
        if (commitStatus == CommitStatus.Branch_Commit_Disabled) {
            return "Enable Branch Commit";
        }
        if (commitStatus == CommitStatus.Commit_Needed) {
            return "Start Commit";
        }
        if (commitStatus == CommitStatus.No_Commit_Needed) {
            return CommitStatus.No_Commit_Needed.getDisplayName();
        }
        if (commitStatus == CommitStatus.Merge_In_Progress) {
            return "Merge Conflicts and Commit";
        }
        if (commitStatus == CommitStatus.Committed) {
            return "Show Change Report";
        }
        if (commitStatus == CommitStatus.Committed_With_Merge) {
            return "Show Change/Merge Report";
        }
        if (commitStatus == CommitStatus.Working_Branch_Not_Created) {
            return "Working Branch Not Created";
        }
        if (commitStatus == CommitStatus.Commit_Overridden) {
            return "None";
        }
        return "Error: Need to handle this";
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

