/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.defect;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewDefectManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectXViewer;
import org.eclipse.osee.ats.ide.util.widgets.defect.NewDefectDialog;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DefectUtil {
    private final DefectXViewer defectXViewer;
    private final IAtsPeerToPeerReview review;

    public DefectUtil(DefectXViewer defectXViewer, IAtsPeerToPeerReview review) {
        this.defectXViewer = defectXViewer;
        this.review = review;
    }

    public void handleNewDefect() {
        NewDefectDialog ed = new NewDefectDialog();
        ed.setFillVertically(true);
        if (ed.open() == 0) {
            try {
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("Add Review Defect");
                ReviewDefectItem item = new ReviewDefectItem();
                item.setUserId(AtsApiService.get().getUserService().getCurrentUserId());
                item.setDescription(ed.getEntry());
                if (ed.getSeverity() != null) {
                    item.setSeverity(ed.getSeverity());
                }
                if (Strings.isValid((String)ed.getEntry2())) {
                    item.setLocation(ed.getEntry2());
                }
                IAtsPeerReviewDefectManager defectManager = this.review.getDefectManager();
                defectManager.addOrUpdateDefectItem(item);
                defectManager.saveToArtifact(this.review, changes);
                changes.execute();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }

    public void handleDeleteDefect(boolean persist) {
        List<ReviewDefectItem> items = this.defectXViewer.getSelectedDefectItems();
        if (items.isEmpty()) {
            AWorkbench.popup((String)"ERROR", (String)"No Defects Selected");
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (ReviewDefectItem defectItem : items) {
            builder.append("\"" + defectItem.getDescription() + "\"\n");
        }
        boolean delete = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete Defects", (String)("Are You Sure You Wish to Delete the Defects(s):\n\n" + builder.toString()));
        if (delete) {
            try {
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("Delete Review Defects");
                IAtsPeerReviewDefectManager defectManager = this.review.getDefectManager();
                for (ReviewDefectItem defectItem : items) {
                    defectManager.removeDefectItem(defectItem);
                    defectManager.saveToArtifact(this.review, changes);
                }
                changes.executeIfNeeded();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }

    public void handleImportDefectsViaList() {
        try {
            EntryDialog ed = new EntryDialog(Displays.getActiveShell(), "Create Defects", null, "Enter Defect descriptions, one per line.", 3, new String[]{"OK", "Cancel"}, 0);
            ed.setFillVertically(true);
            if (ed.open() == 0) {
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("Import Review Defects");
                IAtsPeerReviewDefectManager defectManager = this.review.getDefectManager();
                String[] stringArray = ed.getEntry().split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    if (Strings.isValid((String)(str = str.replaceAll("\r", "")))) {
                        defectManager.addDefectItem(str);
                    }
                    ++n2;
                }
                defectManager.saveToArtifact(this.review, changes);
                changes.execute();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

