/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.defect;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.nebula.widgets.xviewer.XPromptChange;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.EnumStringSingleSelectionDialog;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewDefectManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsReviewHook;
import org.eclipse.osee.ats.core.review.PeerReviewDefectXViewerColumns;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectXViewer;
import org.eclipse.osee.ats.ide.util.widgets.dialog.UserListDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.Displays;

public class DefectXViewerMenu {
    private Action editSeverityAction;
    private Action editDispositionAction;
    private Action editClosedAction;
    private Action editUserAction;
    private Action editCreatedDateAction;
    private Action editInjectionAction;
    private Action editDescriptionAction;
    private Action editLocationAction;
    private Action editResolutionAction;
    private Action editNotesAction;
    private final DefectXViewer defectXViewer;
    private final IAtsPeerToPeerReview review;

    public DefectXViewerMenu(DefectXViewer defectXViewer, IAtsPeerToPeerReview review) {
        this.defectXViewer = defectXViewer;
        this.review = review;
    }

    private List<ReviewDefectItem> getSelectedDefectItems() {
        return this.defectXViewer.getSelectedDefectItems();
    }

    public void createMenuActions() {
        this.defectXViewer.setColumnMultiEditEnabled(true);
        MenuManager mm = this.defectXViewer.getMenuManager();
        mm.createContextMenu(this.defectXViewer.getControl());
        this.editSeverityAction = new Action("Edit Severity", 1){

            public void run() {
                boolean columnMultiEdit = false;
                try {
                    DefectXViewerMenu.this.promptChangeData(PeerReviewDefectXViewerColumns.Severity_Col, DefectXViewerMenu.this.getSelectedDefectItems(), columnMultiEdit);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(DefectXViewer.class, (Level)OseeLevel.SEVERE_POPUP, (String)ex.toString());
                }
            }
        };
        this.editClosedAction = new Action("Edit Closed ", 1){

            public void run() {
                boolean columnMultiEdit = false;
                try {
                    DefectXViewerMenu.this.promptChangeData(PeerReviewDefectXViewerColumns.Closed_Col, DefectXViewerMenu.this.getSelectedDefectItems(), columnMultiEdit);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(DefectXViewer.class, (Level)OseeLevel.SEVERE_POPUP, (String)ex.toString());
                }
            }
        };
        this.editCreatedDateAction = new Action("Edit Created Date ", 1){

            public void run() {
                boolean columnMultiEdit = false;
                try {
                    DefectXViewerMenu.this.promptChangeData(PeerReviewDefectXViewerColumns.Created_Date_Col, DefectXViewerMenu.this.getSelectedDefectItems(), columnMultiEdit);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(DefectXViewer.class, (Level)OseeLevel.SEVERE_POPUP, (String)ex.toString());
                }
            }
        };
        this.editDescriptionAction = new Action("Edit Description ", 1){

            public void run() {
                boolean columnMultiEdit = false;
                try {
                    DefectXViewerMenu.this.promptChangeData(PeerReviewDefectXViewerColumns.Description_Col, DefectXViewerMenu.this.getSelectedDefectItems(), columnMultiEdit);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(DefectXViewer.class, (Level)OseeLevel.SEVERE_POPUP, (String)ex.toString());
                }
            }
        };
        this.editDispositionAction = new Action("Edit Disposition ", 1){

            public void run() {
                boolean columnMultiEdit = false;
                try {
                    DefectXViewerMenu.this.promptChangeData(PeerReviewDefectXViewerColumns.Disposition_Col, DefectXViewerMenu.this.getSelectedDefectItems(), columnMultiEdit);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(DefectXViewer.class, (Level)OseeLevel.SEVERE_POPUP, (String)ex.toString());
                }
            }
        };
        this.editInjectionAction = new Action("Edit Injection ", 1){

            public void run() {
                boolean columnMultiEdit = false;
                try {
                    DefectXViewerMenu.this.promptChangeData(PeerReviewDefectXViewerColumns.Injection_Activity_Col, DefectXViewerMenu.this.getSelectedDefectItems(), columnMultiEdit);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(DefectXViewer.class, (Level)OseeLevel.SEVERE_POPUP, (String)ex.toString());
                }
            }
        };
        this.editLocationAction = new Action("Edit Location ", 1){

            public void run() {
                boolean columnMultiEdit = false;
                try {
                    DefectXViewerMenu.this.promptChangeData(PeerReviewDefectXViewerColumns.Location_Col, DefectXViewerMenu.this.getSelectedDefectItems(), columnMultiEdit);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(DefectXViewer.class, (Level)OseeLevel.SEVERE_POPUP, (String)ex.toString());
                }
            }
        };
        this.editResolutionAction = new Action("Edit Resolution ", 1){

            public void run() {
                boolean columnMultiEdit = false;
                try {
                    DefectXViewerMenu.this.promptChangeData(PeerReviewDefectXViewerColumns.Resolution_Col, DefectXViewerMenu.this.getSelectedDefectItems(), columnMultiEdit);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(DefectXViewer.class, (Level)OseeLevel.SEVERE_POPUP, (String)ex.toString());
                }
            }
        };
        this.editUserAction = new Action("Edit User ", 1){

            public void run() {
                boolean columnMultiEdit = false;
                try {
                    DefectXViewerMenu.this.promptChangeData(PeerReviewDefectXViewerColumns.User_Col, DefectXViewerMenu.this.getSelectedDefectItems(), columnMultiEdit);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(DefectXViewer.class, (Level)OseeLevel.SEVERE_POPUP, (String)ex.toString());
                }
            }
        };
        this.editNotesAction = new Action("Edit Notes ", 1){

            public void run() {
                boolean columnMultiEdit = false;
                try {
                    DefectXViewerMenu.this.promptChangeData(PeerReviewDefectXViewerColumns.Notes_Col, DefectXViewerMenu.this.getSelectedDefectItems(), columnMultiEdit);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(DefectXViewer.class, (Level)OseeLevel.SEVERE_POPUP, (String)ex.toString());
                }
            }
        };
    }

    public void updateEditMenuActions() {
        MenuManager mm = this.defectXViewer.getMenuManager();
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editSeverityAction);
        this.editSeverityAction.setEnabled(this.isEditable());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editClosedAction);
        this.editClosedAction.setEnabled(this.isEditable());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editCreatedDateAction);
        this.editCreatedDateAction.setEnabled(this.isEditable());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editDescriptionAction);
        this.editDescriptionAction.setEnabled(this.isEditable());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editDispositionAction);
        this.editDispositionAction.setEnabled(this.isEditable());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editInjectionAction);
        this.editInjectionAction.setEnabled(this.isEditable());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editLocationAction);
        this.editLocationAction.setEnabled(this.isEditable());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editResolutionAction);
        this.editResolutionAction.setEnabled(this.isEditable());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editUserAction);
        this.editUserAction.setEnabled(this.isEditable());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editNotesAction);
        this.editNotesAction.setEnabled(this.isEditable());
    }

    private boolean isEditable() {
        return this.defectXViewer.isEditable();
    }

    public boolean promptChangeData(XViewerColumn xCol, Collection<ReviewDefectItem> defectItems, boolean columnMultiEdit) {
        boolean modified = false;
        if (defectItems != null && !defectItems.isEmpty()) {
            ReviewDefectItem defectItem = (ReviewDefectItem)defectItems.toArray()[0];
            if (xCol.equals((Object)PeerReviewDefectXViewerColumns.Severity_Col)) {
                modified = this.handleSeverityCol(xCol, defectItems, columnMultiEdit, modified, defectItem);
            } else if (xCol.equals((Object)PeerReviewDefectXViewerColumns.Disposition_Col)) {
                modified = this.handleDispositionCol(xCol, defectItems, columnMultiEdit, modified, defectItem);
            } else if (xCol.equals((Object)PeerReviewDefectXViewerColumns.Created_Date_Col)) {
                modified = this.handleCreatedDateCol(xCol, defectItems, columnMultiEdit, modified, defectItem);
            } else if (xCol.equals((Object)PeerReviewDefectXViewerColumns.Closed_Col)) {
                modified = this.handleClosedCol(xCol, defectItems, columnMultiEdit, modified, defectItem);
            } else if (xCol.equals((Object)PeerReviewDefectXViewerColumns.Description_Col)) {
                modified = this.handleDescriptionCol(xCol, defectItems, columnMultiEdit, modified, defectItem);
            } else if (xCol.equals((Object)PeerReviewDefectXViewerColumns.Resolution_Col)) {
                modified = this.handleResolutionCol(xCol, defectItems, columnMultiEdit, modified, defectItem);
            } else if (xCol.equals((Object)PeerReviewDefectXViewerColumns.Location_Col)) {
                modified = this.handleLocationCol(xCol, defectItems, columnMultiEdit, modified, defectItem);
            } else if (xCol.equals((Object)PeerReviewDefectXViewerColumns.User_Col)) {
                modified = this.handleUserCol(defectItems, modified);
            } else if (xCol.equals((Object)PeerReviewDefectXViewerColumns.Injection_Activity_Col)) {
                modified = this.handleInjectionActivityCol(xCol, defectItems, columnMultiEdit, modified, defectItem);
            } else if (xCol.equals((Object)PeerReviewDefectXViewerColumns.Notes_Col)) {
                modified = this.handleNotesCol(xCol, defectItems, columnMultiEdit, modified, defectItem);
            }
            if (modified) {
                return this.executeTransaction(defectItems);
            }
        }
        return false;
    }

    private boolean handleInjectionActivityCol(XViewerColumn xCol, Collection<ReviewDefectItem> defectItems, boolean columnMultiEdit, boolean modified, ReviewDefectItem defectItem) {
        EnumStringSingleSelectionDialog enumDialog = XPromptChange.promptChangeSingleSelectEnumeration((String)xCol.getName(), (Collection)ReviewDefectItem.InjectionActivity.strValues(), columnMultiEdit ? null : defectItem.getInjectionActivity().name());
        if (enumDialog != null && enumDialog.getResult() != null) {
            modified = this.setInjectionActivity(defectItems, ReviewDefectItem.InjectionActivity.valueOf((String)((String)enumDialog.getResult()[0])));
        }
        return modified;
    }

    private boolean handleUserCol(Collection<ReviewDefectItem> defectItems, boolean modified) {
        UserListDialog dialog = new UserListDialog(Displays.getActiveShell(), "Select New User", Active.Active, true);
        int result = dialog.open();
        if (result == 0) {
            modified = this.setUser(defectItems, dialog.getSelection());
        }
        return modified;
    }

    private boolean handleLocationCol(XViewerColumn xCol, Collection<ReviewDefectItem> defectItems, boolean columnMultiEdit, boolean modified, ReviewDefectItem defectItem) {
        String loc = XPromptChange.promptChangeString((String)xCol.getName(), (String)(columnMultiEdit ? null : defectItem.getLocation()), null, (XPromptChange.Option)XPromptChange.Option.MULTI_LINE);
        if (loc != null) {
            modified = this.setLocation(defectItems, loc);
        }
        return modified;
    }

    private boolean handleResolutionCol(XViewerColumn xCol, Collection<ReviewDefectItem> defectItems, boolean columnMultiEdit, boolean modified, ReviewDefectItem defectItem) {
        String resolution = XPromptChange.promptChangeString((String)xCol.getName(), (String)(columnMultiEdit ? null : defectItem.getResolution()), null, (XPromptChange.Option)XPromptChange.Option.MULTI_LINE);
        if (resolution != null) {
            modified = this.setResolution(defectItems, resolution);
        }
        return modified;
    }

    private boolean handleDescriptionCol(XViewerColumn xCol, Collection<ReviewDefectItem> defectItems, boolean columnMultiEdit, boolean modified, ReviewDefectItem defectItem) {
        String desc = XPromptChange.promptChangeString((String)xCol.getName(), (String)(columnMultiEdit ? null : defectItem.getDescription()), null, (XPromptChange.Option)XPromptChange.Option.MULTI_LINE);
        if (desc != null) {
            modified = this.setDescription(defectItems, desc);
        }
        return modified;
    }

    private boolean handleClosedCol(XViewerColumn xCol, Collection<ReviewDefectItem> defectItems, boolean columnMultiEdit, boolean modified, ReviewDefectItem defectItem) {
        return this.setClosed(defectItems, !defectItem.isClosed());
    }

    private boolean handleCreatedDateCol(XViewerColumn xCol, Collection<ReviewDefectItem> defectItems, boolean columnMultiEdit, boolean modified, ReviewDefectItem defectItem) {
        Date selDate = XPromptChange.promptChangeDate((String)xCol.getName(), (Date)(columnMultiEdit ? defectItem.getDate() : null));
        if (selDate != null) {
            modified = this.setDate(defectItems, selDate);
        }
        return modified;
    }

    private boolean handleDispositionCol(XViewerColumn xCol, Collection<ReviewDefectItem> defectItems, boolean columnMultiEdit, boolean modified, ReviewDefectItem defectItem) {
        EnumStringSingleSelectionDialog enumDialog = XPromptChange.promptChangeSingleSelectEnumeration((String)xCol.getName(), (Collection)ReviewDefectItem.Disposition.strValues(), columnMultiEdit ? null : defectItem.getDisposition().name());
        if (enumDialog != null && enumDialog.getResult() != null) {
            modified = this.setDisposition(defectItems, ReviewDefectItem.Disposition.valueOf((String)((String)enumDialog.getResult()[0])));
        }
        return modified;
    }

    private boolean handleSeverityCol(XViewerColumn xCol, Collection<ReviewDefectItem> defectItems, boolean columnMultiEdit, boolean modified, ReviewDefectItem defectItem) {
        EnumStringSingleSelectionDialog enumDialog = XPromptChange.promptChangeSingleSelectEnumeration((String)xCol.getName(), (Collection)ReviewDefectItem.Severity.strValues(), columnMultiEdit ? null : defectItem.getSeverity().name());
        if (enumDialog != null && enumDialog.getResult() != null) {
            modified = this.setSeverity(defectItems, ReviewDefectItem.Severity.valueOf((String)((String)enumDialog.getResult()[0])));
        }
        return modified;
    }

    private boolean handleNotesCol(XViewerColumn xCol, Collection<ReviewDefectItem> defectItems, boolean columnMultiEdit, boolean modified, ReviewDefectItem defectItem) {
        String desc = XPromptChange.promptChangeString((String)xCol.getName(), (String)(columnMultiEdit ? null : defectItem.getNotes()), null, (XPromptChange.Option)XPromptChange.Option.MULTI_LINE);
        if (desc != null) {
            modified = this.setNotes(defectItems, desc);
        }
        return modified;
    }

    public boolean executeTransaction(Collection<ReviewDefectItem> defectItems) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Modify Review Defects");
        IAtsPeerReviewDefectManager defectManager = this.review.getDefectManager();
        for (ReviewDefectItem defectItem : defectItems) {
            defectManager.addOrUpdateDefectItem(defectItem);
            this.defectXViewer.update(defectItem, null);
        }
        defectManager.saveToArtifact(this.review, changes);
        changes.executeIfNeeded();
        return true;
    }

    private boolean setInjectionActivity(Collection<ReviewDefectItem> defectItems, ReviewDefectItem.InjectionActivity newInjectionActivity) {
        boolean modified = false;
        for (ReviewDefectItem defectItem : defectItems) {
            if (defectItem.getInjectionActivity().equals((Object)newInjectionActivity)) continue;
            defectItem.setInjectionActivity(newInjectionActivity);
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    private boolean setUser(Collection<ReviewDefectItem> defectItems, AtsUser user) {
        boolean modified = false;
        for (ReviewDefectItem defectItem : defectItems) {
            if (defectItem.getUserId().equals(user.getUserId())) continue;
            defectItem.setUserId(user.getUserId());
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    private boolean setLocation(Collection<ReviewDefectItem> defectItems, String loc) {
        boolean modified = false;
        for (ReviewDefectItem defectItem : defectItems) {
            if (defectItem.getLocation().equals(loc)) continue;
            defectItem.setLocation(loc);
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    private boolean setDescription(Collection<ReviewDefectItem> defectItems, String desc) {
        boolean modified = false;
        for (ReviewDefectItem defectItem : defectItems) {
            if (defectItem.toString().equals(desc)) continue;
            defectItem.setDescription(desc);
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    private boolean setNotes(Collection<ReviewDefectItem> defectItems, String desc) {
        boolean modified = false;
        for (ReviewDefectItem defectItem : defectItems) {
            if (defectItem.toString().equals(desc)) continue;
            defectItem.setNotes(desc);
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    private boolean setClosed(Collection<ReviewDefectItem> defectItems, boolean closed) {
        boolean modified = false;
        XResultData rd = new XResultData();
        for (ReviewDefectItem defectItem : defectItems) {
            if (defectItem.isClosed() == closed) continue;
            if (closed) {
                for (IAtsReviewHook provider : AtsApiService.get().getReviewService().getReviewHooks()) {
                    provider.checkDefectCanClose(defectItem, closed, rd);
                }
                if (rd.isSuccess()) {
                    defectItem.setClosed(closed);
                    defectItem.setClosedUserId(AtsApiService.get().getUserService().getCurrentUserId());
                }
            } else {
                defectItem.setClosed(closed);
                defectItem.setClosedUserId("");
            }
            if (modified) continue;
            modified = true;
        }
        if (rd.isErrors()) {
            XResultDataUI.report((XResultData)rd, (String)"Error(s) for Defect(s)");
        }
        return modified;
    }

    private boolean setSeverity(Collection<ReviewDefectItem> defectItems, ReviewDefectItem.Severity severity) {
        boolean modified = false;
        for (ReviewDefectItem defectItem : defectItems) {
            if (defectItem.getSeverity().equals((Object)severity)) continue;
            defectItem.setSeverity(severity);
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    private boolean setDisposition(Collection<ReviewDefectItem> defectItems, ReviewDefectItem.Disposition disposition) {
        boolean modified = false;
        for (ReviewDefectItem defectItem : defectItems) {
            if (defectItem.getDisposition().equals((Object)disposition)) continue;
            defectItem.setDisposition(disposition);
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    private boolean setDate(Collection<ReviewDefectItem> defectItems, Date date) {
        boolean modified = false;
        for (ReviewDefectItem defectItem : defectItems) {
            if (defectItem.getDate().equals(date)) continue;
            defectItem.setDate(date);
            if (modified) continue;
            modified = true;
        }
        return modified;
    }

    private boolean setResolution(Collection<ReviewDefectItem> defectItems, String resolution) {
        boolean modified = false;
        for (ReviewDefectItem defectItem : defectItems) {
            if (defectItem.getResolution().equals(resolution)) continue;
            defectItem.setResolution(resolution);
            if (!resolution.isBlank()) {
                defectItem.setResolvedUserId(AtsApiService.get().getUserService().getCurrentUserId());
            } else {
                defectItem.setResolvedUserId("");
            }
            if (modified) continue;
            modified = true;
        }
        return modified;
    }
}

