/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.ide.config.editor.AtsConfigContentProvider;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.AtsObjectLabelProvider;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.ToStringViewerSorter;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AtsConfigCheckTreeDialog<T>
extends FilteredCheckboxTreeDialog<T> {
    private List<T> initialConfigObjects;
    private final boolean requiredSelection;
    private final Collection<T> selectableConfigObjects;

    public AtsConfigCheckTreeDialog(String title, String message, Collection<T> selectableTeamDefs, boolean requiredSelection) {
        super(title, message, (IContentProvider)new AtsConfigContentProvider(), (IBaseLabelProvider)new AtsObjectLabelProvider(), (ViewerComparator)new ToStringViewerSorter());
        this.selectableConfigObjects = selectableTeamDefs;
        this.requiredSelection = requiredSelection;
    }

    public Collection<T> getChecked() {
        return super.getTreeViewer().getChecked();
    }

    protected Control createDialogArea(Composite container) {
        Control comp = super.createDialogArea(container);
        try {
            this.getTreeViewer().getViewer().setInput(this.selectableConfigObjects);
            if (this.getInitialConfigObjects() != null) {
                this.getTreeViewer().setInitalChecked(this.getInitialConfigObjects());
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return comp;
    }

    protected Result isComplete() {
        super.isComplete();
        Result result = Result.TrueResult;
        try {
            if (this.requiredSelection && this.getChecked().isEmpty()) {
                result = new Result("Must select Item(s)");
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return result;
    }

    public List<T> getInitialConfigObjects() {
        return this.initialConfigObjects;
    }

    public void setInitialConfigObjects(List<T> initialConfigObjects) {
        this.initialConfigObjects = initialConfigObjects;
    }
}

