/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.xviewer.column;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.config.AtsDisplayHint;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.PromptChangeUtil;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.IAttributeColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class AtsColumnUtilIde {
    public static final String INVALID_SELECTION = "Invalid Selection";
    public static final String INVALID_ATTR_TYPE = "Invalid Attribute [%s]";
    public static final String COLUMN_NOT_EDITABLE = "Column [%s] is not editable";
    public static final String ATTRIBUTE_NOT_EDITABLE = "Attribute [%s] is not editable";
    public static final String INVALID_COLUMN_FOR_SELECTED = "Column [%s] is not valid for selected";
    public static final String INAVLID_ATTR_FOR_SELECTED = "Attribute [%s] is not valid for selected";

    public static boolean handleAltLeftClick(Object columnData, Object item, boolean persist) {
        block12: {
            block9: {
                Artifact useArt;
                IAttributeColumn attrColumn;
                block14: {
                    block13: {
                        AttributeTypeToken attrType;
                        block11: {
                            block10: {
                                try {
                                    if (!(columnData instanceof IAttributeColumn)) break block9;
                                    attrColumn = (IAttributeColumn)columnData;
                                    attrType = attrColumn.getAttributeType();
                                    if (!attrType.isInvalid()) break block10;
                                    AWorkbench.popup((String)INVALID_SELECTION, (String)COLUMN_NOT_EDITABLE, (Object[])new Object[]{attrColumn.getName()});
                                    return false;
                                }
                                catch (OseeCoreException ex) {
                                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                                    return false;
                                }
                            }
                            if (attrType.getDisplayHints().contains(AtsDisplayHint.Edit)) break block11;
                            AWorkbench.popup((String)INVALID_SELECTION, (String)ATTRIBUTE_NOT_EDITABLE, (Object[])new Object[]{attrType.getUnqualifiedName()});
                            return false;
                        }
                        if (!(item instanceof Artifact)) break block12;
                        useArt = AtsApiService.get().getQueryServiceIde().getArtifact(item);
                        if (useArt.isAttributeTypeValid((AttributeTypeId)attrType)) break block13;
                        AWorkbench.popup((String)INVALID_SELECTION, (String)INAVLID_ATTR_FOR_SELECTED, (Object[])new Object[]{attrType.getUnqualifiedName()});
                        return false;
                    }
                    if (useArt.getArtifactType().getMax(attrColumn.getAttributeType()) == 1 || useArt.getAttributeCount((AttributeTypeId)attrColumn.getAttributeType()) <= 1) break block14;
                    return false;
                }
                boolean modified = PromptChangeUtil.promptChangeAttribute((AbstractWorkflowArtifact)useArt, attrColumn.getAttributeType(), true);
                if (modified && persist) {
                    useArt.persist("persist attribute via alt-left-click");
                }
                if (modified) {
                    ((XViewer)((XViewerColumn)columnData).getXViewer()).update((Object)useArt, null);
                    return true;
                }
                break block12;
            }
            if (!(columnData instanceof XViewerColumn)) break block12;
            XViewerColumn column = (XViewerColumn)columnData;
            AWorkbench.popup((String)INVALID_SELECTION, (String)COLUMN_NOT_EDITABLE, (Object[])new Object[]{column.getName()});
        }
        return false;
    }

    public static void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems, XViewer xViewer) {
        AWorkbench.popup((String)INVALID_SELECTION, (String)COLUMN_NOT_EDITABLE, (Object[])new Object[]{treeColumn.getText()});
    }

    public static void handleColumnMultiEdit(Collection<TreeItem> treeItems, AttributeTypeToken attrType, XViewer xViewer) {
        if (attrType.isInvalid()) {
            AWorkbench.popup((String)INVALID_SELECTION, (String)INVALID_ATTR_TYPE, (Object[])new Object[]{attrType.getUnqualifiedName()});
            return;
        }
        if (!attrType.getDisplayHints().contains(AtsDisplayHint.Edit)) {
            AWorkbench.popup((String)INVALID_SELECTION, (String)ATTRIBUTE_NOT_EDITABLE, (Object[])new Object[]{attrType.getUnqualifiedName()});
            return;
        }
        LinkedHashSet<AbstractWorkflowArtifact> awas = new LinkedHashSet<AbstractWorkflowArtifact>();
        for (TreeItem item : treeItems) {
            Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
            try {
                if (!(art instanceof AbstractWorkflowArtifact) || !art.isAttributeTypeValid((AttributeTypeId)attrType)) continue;
                awas.add((AbstractWorkflowArtifact)art);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        if (awas.isEmpty()) {
            AWorkbench.popup((String)INVALID_SELECTION, (String)INAVLID_ATTR_FOR_SELECTED, (Object[])new Object[]{attrType.getUnqualifiedName()});
            return;
        }
        if (PromptChangeUtil.promptChangeAttribute(awas, attrType, true)) {
            xViewer.update(awas.toArray(), null);
        }
    }
}

