/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.xviewer.column;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnUtil;
import org.eclipse.osee.ats.api.column.AtsCoreAttrTokColumnToken;
import org.eclipse.osee.ats.api.column.AtsCoreColumnToken;
import org.eclipse.osee.ats.api.config.AtsDisplayHint;
import org.eclipse.osee.ats.api.config.ColumnAlign;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.AtsColumnUtilIde;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.IAttributeColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class XViewerAtsAttrTokenXColumn
extends XViewerAtsColumn
implements IXViewerValueColumn,
IAttributeColumn {
    String booleanOnTrueShow = null;
    String booleanOnFalseShow = null;
    String booleanNotSetShow = null;
    private AtsCoreAttrTokColumnToken columnToken;
    protected AttributeTypeToken attributeType;

    protected XViewerAtsAttrTokenXColumn() {
    }

    public XViewerAtsAttrTokenXColumn(AttributeTypeToken attributeType, int width, XViewerAlign align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        super(attributeType.getName(), attributeType.getUnqualifiedName(), width, align, show, sortDataType, multiColumnEditable, description);
        this.attributeType = attributeType;
    }

    public XViewerAtsAttrTokenXColumn(AttributeTypeToken attributeType, String id, String name, int width, XViewerAlign align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        super(id, name, width, align, show, sortDataType, multiColumnEditable, description);
        this.attributeType = attributeType;
    }

    public XViewerAtsAttrTokenXColumn(AtsCoreAttrTokColumnToken columnToken) {
        super(columnToken.getId(), columnToken.getName(), columnToken.getWidth(), AtsColumnUtil.getXViewerAlign((ColumnAlign)columnToken.getAlign()), columnToken.isVisible(), AtsColumnUtil.getSortDataType((AtsCoreColumnToken)columnToken), columnToken.isColumnMultiEdit(), columnToken.getDescription());
        this.attributeType = AtsApiService.get().tokenService().getAttributeTypeOrSentinel(Long.valueOf(columnToken.getAttrTypeId()));
        this.columnToken = columnToken;
        this.setInheritParent(columnToken.isInheritParent());
        this.setActionRollup(columnToken.isActionRollup());
    }

    public XViewerAtsAttrTokenXColumn(AttributeTypeToken attrType) {
        this(new AtsCoreAttrTokColumnToken(attrType));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (element instanceof Artifact && AtsApiService.get().getQueryServiceIde().getArtifact(element).isDeleted()) {
                return "<deleted>";
            }
            if (this.isBooleanShow() && column.getSortDataType() == SortDataType.Boolean && element instanceof AbstractWorkflowArtifact) {
                if (this.attributeType.getDisplayHints().contains(DisplayHint.YesNoBoolean) && AtsApiService.get().getAttributeResolver().isAttributeTypeValid((IAtsWorkItem)element, this.attributeType)) {
                    Boolean set = (Boolean)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((ArtifactId)((Artifact)element), this.attributeType, null);
                    if (set == null) {
                        return "";
                    }
                    if (set.booleanValue()) {
                        return "Yes";
                    }
                    return "No";
                }
                Boolean value = (Boolean)((AbstractWorkflowArtifact)((Object)element)).getSoleAttributeValue((AttributeTypeId)this.attributeType, null);
                if (value == null && this.booleanNotSetShow != null) {
                    return this.booleanNotSetShow;
                }
                if (value != null) {
                    if (value.booleanValue() && this.booleanOnTrueShow != null) {
                        return this.booleanOnTrueShow;
                    }
                    if (!value.booleanValue() && this.booleanOnFalseShow != null) {
                        return this.booleanOnFalseShow;
                    }
                }
            }
            if (element instanceof AbstractWorkflowArtifact) {
                AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)((Object)element);
                if (this.attributeType.hasDisplayHint(new DisplayHint[]{AtsDisplayHint.UserArtId})) {
                    ArrayList<String> names = new ArrayList<String>();
                    for (String userArtId : awa.getAttributesToStringList((AttributeTypeId)this.attributeType)) {
                        AtsUser userById;
                        if (!Strings.isNumeric((String)userArtId) || (userById = AtsApiService.get().getUserService().getUserById(ArtifactId.valueOf((String)userArtId))) == null) continue;
                        names.add(userById.getName());
                    }
                    return Collections.toString((String)";", names);
                }
                String result = awa.getAttributesToStringUnique((AttributeTypeId)this.attributeType, ";");
                if (Strings.isValid((String)result)) {
                    return result;
                }
                if (this.isInheritParentWithDefault() && !awa.isTeamWorkflow() && awa.getParentTeamWorkflow() != null && Strings.isValid((String)(result = Collections.toString((String)"; ", (Iterable)((Artifact)awa.getParentTeamWorkflow()).getAttributesToStringList((AttributeTypeId)this.attributeType))))) {
                    return result;
                }
            }
            if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action) && this.isActionRollupWithDefault()) {
                LinkedHashSet<String> strs = new LinkedHashSet<String>();
                for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(element)) {
                    String str = this.getColumnText(team, column, columnIndex);
                    if (!Strings.isValid((String)str)) continue;
                    strs.add(str);
                }
                return Collections.toString((String)"; ", strs);
            }
        }
        catch (Exception ex) {
            return LogUtil.getCellExceptionString((Exception)ex);
        }
        return "";
    }

    private boolean isActionRollupWithDefault() {
        if (this.isActionRollup() == null) {
            return false;
        }
        return this.isActionRollup();
    }

    private boolean isInheritParentWithDefault() {
        if (this.isInheritParent() == null) {
            return false;
        }
        return this.isInheritParent();
    }

    private boolean isBooleanShow() {
        return this.booleanOnFalseShow != null || this.booleanOnTrueShow != null || this.booleanNotSetShow != null || this.attributeType != null && this.attributeType.getDisplayHints().contains(DisplayHint.YesNoBoolean);
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        if (treeColumn != null && !treeColumn.isDisposed() && treeItem != null && !treeItem.isDisposed()) {
            return AtsColumnUtilIde.handleAltLeftClick(treeColumn.getData(), treeItem.getData(), true);
        }
        return false;
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        if (treeColumn != null && !treeColumn.isDisposed()) {
            AtsColumnUtilIde.handleColumnMultiEdit(treeItems, this.attributeType, (XViewer)this.getXViewer());
        }
    }

    public XViewerAtsAttrTokenXColumn copy() {
        XViewerAtsAttrTokenXColumn newXCol = new XViewerAtsAttrTokenXColumn();
        this.copy(this, newXCol);
        newXCol.setBooleanNotSetShow(this.getBooleanNotSetShow());
        newXCol.setBooleanOnFalseShow(this.getBooleanOnFalseShow());
        newXCol.setBooleanOnTrueShow(this.getBooleanOnTrueShow());
        newXCol.setInheritParent(this.isInheritParent());
        newXCol.setActionRollup(this.isActionRollup());
        newXCol.setColumnToken(this.getColumnToken());
        return newXCol;
    }

    public String getBooleanOnTrueShow() {
        return this.booleanOnTrueShow;
    }

    public void setBooleanOnTrueShow(String booleanOnTrueShow) {
        this.booleanOnTrueShow = booleanOnTrueShow;
    }

    public String getBooleanOnFalseShow() {
        return this.booleanOnFalseShow;
    }

    public void setBooleanOnFalseShow(String booleanOnFalseShow) {
        this.booleanOnFalseShow = booleanOnFalseShow;
    }

    public String getBooleanNotSetShow() {
        return this.booleanNotSetShow;
    }

    public void setBooleanNotSetShow(String booleanNotSetShow) {
        this.booleanNotSetShow = booleanNotSetShow;
    }

    public AtsCoreAttrTokColumnToken getColumnToken() {
        return this.columnToken;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(AttributeTypeToken attributeType) {
        this.attributeType = attributeType;
    }

    public void setColumnToken(AtsCoreAttrTokColumnToken columnToken) {
        this.columnToken = columnToken;
    }
}

