/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workdef;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.commit.XCommitManager;
import org.eclipse.osee.ats.ide.workdef.WidgetPageUtil;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.hooks.IAtsWorkItemHookIde;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IDynamicWidgetLayoutListener;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class StateXWidgetPage
implements IDynamicWidgetLayoutListener,
IStateToken {
    protected SwtXWidgetRenderer dynamicXWidgetLayout;
    protected final StateDefinition stateDefinition;
    protected final WorkDefinition workDefinition;
    private final AbstractWorkflowArtifact awa;

    public StateXWidgetPage(WorkDefinition workDefinition, StateDefinition stateDefinition, IXWidgetOptionResolver optionResolver, IDynamicWidgetLayoutListener dynamicWidgetLayoutListener, AbstractWorkflowArtifact awa) {
        this.awa = awa;
        this.workDefinition = workDefinition;
        this.stateDefinition = stateDefinition;
        this.dynamicXWidgetLayout = dynamicWidgetLayoutListener == null ? new SwtXWidgetRenderer((IDynamicWidgetLayoutListener)this, optionResolver) : new SwtXWidgetRenderer(dynamicWidgetLayoutListener, optionResolver);
    }

    public StateXWidgetPage(WorkDefinition workFlowDefinition, StateDefinition stateDefinition, String xWidgetsXml, IXWidgetOptionResolver optionResolver, AbstractWorkflowArtifact awa) {
        this(workFlowDefinition, stateDefinition, xWidgetsXml, optionResolver, null, awa);
    }

    public StateXWidgetPage(WorkDefinition workDefinition, StateDefinition stateDefinition, String xWidgetsXml, IXWidgetOptionResolver optionResolver, IDynamicWidgetLayoutListener dynamicWidgetLayoutListener, AbstractWorkflowArtifact awa) {
        this(workDefinition, stateDefinition, optionResolver, dynamicWidgetLayoutListener, awa);
        try {
            if (xWidgetsXml != null) {
                this.processXmlLayoutDatas(xWidgetsXml);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error processing attributes", (Throwable)ex);
        }
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        if (art != null) {
            for (IAtsWorkItemHookIde item : AtsApiService.get().getWorkItemServiceIde().getWorkItemHooksIde()) {
                item.xWidgetCreated(xWidget, toolkit, this.stateDefinition, art, isEditable);
            }
        }
    }

    public void widgetCreating(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        if (art != null) {
            for (IAtsWorkItemHookIde item : AtsApiService.get().getWorkItemServiceIde().getWorkItemHooksIde()) {
                Result result = item.xWidgetCreating(xWidget, toolkit, this.stateDefinition, art, isEditable);
                if (!result.isFalse()) continue;
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)("Error in page creation => " + result.getText()));
            }
        }
    }

    public void dispose() {
        WidgetPageUtil.dispose(this.dynamicXWidgetLayout);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StateXWidgetPage) {
            return this.getName().equals(((StateXWidgetPage)obj).getName());
        }
        return false;
    }

    public SwtXWidgetRenderer createBody(IManagedForm managedForm, Composite parent, Artifact artifact, XModifiedListener xModListener, boolean isEditable) {
        this.dynamicXWidgetLayout.createBody(managedForm, parent, artifact, xModListener, isEditable);
        return this.dynamicXWidgetLayout;
    }

    public String getHtml(String backgroundColor, String preHtml, String postHtml) {
        return WidgetPageUtil.getHtml(backgroundColor, preHtml, postHtml, this.dynamicXWidgetLayout.getLayoutDatas(), this.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.stateDefinition.getName()) + (this.stateDefinition.getName() != null ? " (" + this.stateDefinition.getName() + ") " : "") + "\n");
        try {
            for (StateDefinition page : this.stateDefinition.getToStates()) {
                sb.append("-> " + page.getName() + "\n");
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return sb.toString();
    }

    public XWidgetRendererItem getLayoutData(String layoutName) {
        return this.dynamicXWidgetLayout.getLayoutData(layoutName);
    }

    public SwtXWidgetRenderer getDynamicXWidgetLayout() {
        return this.dynamicXWidgetLayout;
    }

    protected void processXmlLayoutDatas(String xWidgetXml) {
        this.dynamicXWidgetLayout.processlayoutDatas(xWidgetXml);
    }

    public String getName() {
        return this.stateDefinition.getName();
    }

    public StateType getStateType() {
        return this.stateDefinition.getStateType();
    }

    public boolean isCompleted() {
        return this.getStateType().isCompleted();
    }

    public boolean isCancelled() {
        return this.getStateType().isCancelled();
    }

    public boolean isWorking() {
        return this.getStateType().isWorking();
    }

    public boolean isCompletedOrCancelled() {
        return this.getStateType().isCompletedOrCancelled();
    }

    public StateDefinition getStateDefinition() {
        return this.stateDefinition;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getDescription() {
        return null;
    }

    public AbstractWorkflowArtifact getSma() {
        return this.awa;
    }

    public boolean isCurrentState(AbstractWorkflowArtifact sma) {
        return sma.isInState(new IStateToken[]{this});
    }

    public boolean isCurrentNonCompleteCancelledState(AbstractWorkflowArtifact sma) {
        return this.isCurrentState(sma) && !this.isCompletedOrCancelled();
    }

    public void createXWidgetLayoutData(XWidgetRendererItem layoutData, XWidget xWidget, FormToolkit toolkit, Artifact art, XModifiedListener xModListener, boolean isEditable) {
        if (!Strings.isValid((String)xWidget.getToolTip())) {
            String description = "";
            if (layoutData.getXWidgetName().equals(XCommitManager.class.getSimpleName())) {
                description = "Commit branches to parent and parallel branches.";
                xWidget.setToolTip(description);
                layoutData.setToolTip(description);
            } else {
                this.setAttrToolTip(xWidget, layoutData);
            }
        }
        if (xWidget.getControl() != null) {
            xWidget.getControl().setData((Object)layoutData);
        }
    }

    protected void setAttrToolTip(XWidget xWidget, XWidgetRendererItem layoutData) {
        String description = "";
        if (AttributeTypeManager.typeExists((String)layoutData.getStoreName())) {
            try {
                AttributeTypeGeneric type = null;
                if (layoutData.getStoreId() > 0L) {
                    type = AttributeTypeManager.getAttributeType((Long)layoutData.getStoreId());
                }
                if (type == null && Strings.isValid((String)layoutData.getStoreName())) {
                    type = AttributeTypeManager.getType((String)layoutData.getStoreName());
                }
                if (type != null && Strings.isValid((String)type.getDescription())) {
                    description = type.getDescription();
                }
                if (Strings.isValid((String)description)) {
                    xWidget.setToolTip(description);
                    layoutData.setToolTip(description);
                }
            }
            catch (Exception ex) {
                String msg = String.format("Error setting tooltip for widget [%s].  Error %s (see log for details)", xWidget.getLabel(), ex.getLocalizedMessage());
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)msg, (Throwable)ex);
            }
        }
    }

    public void widgetCreating(XWidget xWidget, FormToolkit toolkit, Artifact art, StateDefinition stateDefinition, XModifiedListener xModListener, boolean isEditable) {
        if (art != null) {
            for (IAtsWorkItemHookIde item : AtsApiService.get().getWorkItemServiceIde().getWorkItemHooksIde()) {
                Result result = item.xWidgetCreating(xWidget, toolkit, stateDefinition, art, isEditable);
                if (!result.isFalse()) continue;
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)("Error in page creation => " + result.getText()));
            }
        }
    }

    public void generateLayoutDatas() {
        WidgetPageUtil.generateLayoutDatas(this.awa, this.stateDefinition.getLayoutItems(), this.dynamicXWidgetLayout);
    }
}

