/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.AtsTopicEvent;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.AtsWorkItemServiceImpl;
import org.eclipse.osee.ats.ide.workflow.IAtsWorkItemServiceIde;
import org.eclipse.osee.ats.ide.workflow.hooks.IAtsWorkItemHookIde;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class AtsWorkItemServiceClientImpl
extends AtsWorkItemServiceImpl
implements IAtsWorkItemServiceIde {
    public AtsWorkItemServiceClientImpl(AtsApi atsApi, ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy) {
        super(atsApi, teamWorkflowProvidersLazy);
    }

    @Override
    public Set<IAtsWorkItemHookIde> getWorkItemHooksIde() {
        HashSet<IAtsWorkItemHookIde> hooks = new HashSet<IAtsWorkItemHookIde>();
        for (IAtsWorkItemHook hook : workflowHooks) {
            if (!(hook instanceof IAtsWorkItemHookIde)) continue;
            hooks.add((IAtsWorkItemHookIde)hook);
        }
        return hooks;
    }

    public TransitionResults transition(TransitionData transData) {
        this.populateTransitionData(transData);
        TransitionResults results = this.atsApi.getServerEndpoints().getActionEndpoint().transition(transData);
        results.setAtsApi(this.atsApi);
        if (results.isErrors()) {
            return results;
        }
        this.sortIfBacklogItemChanged(transData);
        results = this.postEventAndReturn(transData, results);
        return results;
    }

    private void sortIfBacklogItemChanged(final TransitionData transData) {
        Thread sortThread = new Thread("Sort Backlog"){

            @Override
            public void run() {
                try {
                    XResultData rd;
                    ArtifactToken backlog = ArtifactToken.SENTINEL;
                    block2: for (IAtsWorkItem workItem : transData.getWorkItems()) {
                        for (ArtifactToken goal : AtsWorkItemServiceClientImpl.this.atsApi.getRelationResolver().getRelated((IAtsObject)workItem, AtsRelationTypes.Goal_Goal)) {
                            if (!goal.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileBacklog})) continue;
                            backlog = goal;
                            continue block2;
                        }
                    }
                    if (backlog.isValid() && Strings.isValid((String)(rd = AtsWorkItemServiceClientImpl.this.atsApi.getServerEndpoints().getAgileEndpoint().sortBacklog(backlog.getToken())).getTxId())) {
                        AtsWorkItemServiceClientImpl.this.reloadBacklogIfItemChanged(transData);
                    }
                }
                catch (Exception ex) {
                    System.err.println(Lib.exceptionToString((Exception)ex));
                }
            }
        };
        sortThread.start();
    }

    private void reloadBacklogIfItemChanged(TransitionData transData) {
        try {
            ArtifactToken backlog = ArtifactToken.SENTINEL;
            block2: for (IAtsWorkItem workItem : transData.getWorkItems()) {
                for (ArtifactToken goal : this.atsApi.getRelationResolver().getRelated((IAtsObject)workItem, AtsRelationTypes.Goal_Goal)) {
                    if (!goal.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileBacklog})) continue;
                    backlog = goal;
                    continue block2;
                }
            }
            if (backlog.isValid()) {
                ((Artifact)backlog).reloadAttributesAndRelations();
                this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_MODIFIED, Collections.singleton(this.atsApi.getWorkItemService().getWorkItem(backlog)), (TransactionId)TransactionRecord.SENTINEL);
            }
        }
        catch (Exception ex) {
            System.err.println(Lib.exceptionToString((Exception)ex));
        }
    }

    private void populateTransitionData(TransitionData transData) {
        for (IAtsWorkItem workItem : transData.getWorkItems()) {
            transData.getWorkItemIds().add(workItem.getStoreObject());
        }
        if (transData.getTransitionUser() == null) {
            transData.setTransitionUser(this.atsApi.getUserService().getCurrentUser());
        }
    }

    public TransitionResults transitionValidate(TransitionData transData) {
        this.populateTransitionData(transData);
        TransitionResults results = this.atsApi.getServerEndpoints().getActionEndpoint().transitionValidate(transData);
        results.setAtsApi(this.atsApi);
        return results;
    }

    private TransitionResults postEventAndReturn(TransitionData transData, TransitionResults results) {
        Conditions.assertNotNullOrEmpty((Collection)results.getWorkItemIds(), (String)"workItemIds", (Object[])new Object[0]);
        this.atsApi.getStoreService().reload(transData.getWorkItems());
        if (results.isSuccess()) {
            this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_MODIFIED, transData.getWorkItems(), results.getTransaction());
            this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_TRANSITIONED, transData.getWorkItems(), results.getTransaction());
        } else {
            this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_TRANSITION_FAILED, transData.getWorkItems(), results.getTransaction());
        }
        return results;
    }
}

