/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.jira;

import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelValueSelection;

public abstract class XHyperlinkJiraStatusSelection
extends XHyperlinkLabelValueSelection
implements ArtifactWidget {
    protected IAtsTeamWorkflow teamWf;

    public XHyperlinkJiraStatusSelection() {
        super("JIRA Status");
    }

    public String getCurrentValue() {
        if (this.teamWf != null) {
            String status;
            if (AtsApiService.get().getAttributeResolver().hasAttribute((IAtsWorkItem)this.teamWf, new AttributeTypeToken[]{AtsAttributeTypes.JiraStoryId}) && Strings.isValid((String)(status = AtsApiService.get().getJiraService().getStatus(this.teamWf)))) {
                return status;
            }
            return "Not Linked";
        }
        return "";
    }

    public Artifact getArtifact() {
        return (Artifact)this.teamWf.getStoreObject();
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setArtifact(Artifact artifact) {
        if (artifact instanceof IAtsTeamWorkflow) {
            this.teamWf = (IAtsTeamWorkflow)artifact;
        }
    }
}

