/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.CommandGroup;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.MenuCmdDef;
import org.eclipse.osee.framework.ui.skynet.render.DefaultArtifactRenderer;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class AtsWorldEditorRenderer
extends DefaultArtifactRenderer {
    private static final String Option_WORLD_EDITOR = "world.editor.option";

    public AtsWorldEditorRenderer(RendererMap rendererOptions) {
        super(rendererOptions);
    }

    public AtsWorldEditorRenderer() {
        this(null);
    }

    public int getApplicabilityRating(PresentationType presentationType, Artifact artifact, RendererMap rendererOptions) {
        if (artifact.isHistorical() || presentationType.matches(new PresentationType[]{PresentationType.GENERALIZED_EDIT, PresentationType.PRODUCE_ATTRIBUTE})) {
            return -1;
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AtsArtifact})) {
            if (Option_WORLD_EDITOR.equals(rendererOptions.getRendererOptionValue(RendererOption.OPEN_OPTION))) {
                return 70;
            }
            return 50;
        }
        if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.UniversalGroup})) {
            if (artifact.getRelatedArtifactsCount(CoreRelationTypes.UniversalGrouping_Members) == 0) {
                return -1;
            }
            for (Artifact childArt : artifact.getRelatedArtifacts(CoreRelationTypes.UniversalGrouping_Members)) {
                if (!childArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AtsArtifact})) continue;
                return 50;
            }
        }
        return -1;
    }

    public void addMenuCommandDefinitions(ArrayList<MenuCmdDef> commands, Artifact artifact) {
        commands.add(new MenuCmdDef(CommandGroup.EDIT, PresentationType.SPECIALIZED_EDIT, "ATS World Editor", ImageManager.create((OseeImage)AtsImage.GLOBE), RendererOption.OPEN_OPTION.getKey(), Option_WORLD_EDITOR));
    }

    public String getName() {
        return "ATS World Editor";
    }

    public AtsWorldEditorRenderer newInstance() {
        return new AtsWorldEditorRenderer();
    }

    public AtsWorldEditorRenderer newInstance(RendererMap rendererOptions) {
        return new AtsWorldEditorRenderer(rendererOptions);
    }

    public void open(List<Artifact> artifacts, PresentationType presentationType) {
        AtsEditors.openInAtsWorldEditor("ATS", artifacts);
    }
}

