/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.ats.ide.world.AtsWorldEditorItems;
import org.eclipse.osee.ats.ide.world.IAtsWorldEditorItem;
import org.eclipse.osee.ats.ide.world.WorldEditorInput;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItemProvider;
import org.eclipse.osee.ats.ide.world.WorldEditorReloadProvider;
import org.eclipse.osee.ats.ide.world.search.AtsSearchGoalSearchItem;
import org.eclipse.osee.ats.ide.world.search.AtsSearchReviewSearchItem;
import org.eclipse.osee.ats.ide.world.search.AtsSearchTaskSearchItem;
import org.eclipse.osee.ats.ide.world.search.AtsSearchTeamWorkflowSearchItem;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class WorldEditorInputFactory
implements IElementFactory {
    public static final String ID = "org.eclipse.osee.ats.ide.WorldEditorInputFactory";
    public static final String ART_IDS = "org.eclipse.osee.ats.ide.WorldEditorInputFactory.artIds";
    public static final String BRANCH_KEY = "org.eclipse.osee.ats.ide.WorldEditorInputFactory.branchId";
    public static final String TITLE = "org.eclipse.osee.ats.ide.WorldEditorInputFactory.title";
    public static final String ATS_SEARCH_ID = "org.eclipse.osee.ats.ide.WorldEditorInputFactory.atsSearchId";
    private static final String ATS_SEARCH_NAMESPACE = "org.eclipse.osee.ats.ide.WorldEditorInputFactory.atsSearchNamespace";

    public IAdaptable createElement(IMemento memento) {
        long atsSearchId = 0L;
        BranchId branch = BranchId.SENTINEL;
        String title = memento.getString(TITLE);
        if (Strings.isValid((String)memento.getString(BRANCH_KEY))) {
            branch = BranchId.valueOf((String)memento.getString(BRANCH_KEY));
        }
        List artIds = Collections.fromString((String)memento.getString(ART_IDS), ArtifactId::valueOf);
        String atsSearchIdStr = memento.getString(ATS_SEARCH_ID);
        if (Strings.isNumeric((String)atsSearchIdStr)) {
            atsSearchId = Long.valueOf(atsSearchIdStr);
        }
        try {
            if (atsSearchId > 0L) {
                String namespace = memento.getString(ATS_SEARCH_NAMESPACE);
                if (Strings.isValid((String)namespace)) {
                    if ("ats.search.team".equals(namespace)) {
                        AtsSearchTeamWorkflowSearchItem searchItem = new AtsSearchTeamWorkflowSearchItem();
                        searchItem.setRestoreId(atsSearchId);
                        return new WorldEditorInput(new WorldEditorParameterSearchItemProvider(searchItem, null, new XNavigateComposite.TableLoadOption[0]));
                    }
                    if ("ats.search.task".equals(namespace)) {
                        AtsSearchTaskSearchItem searchItem = new AtsSearchTaskSearchItem();
                        searchItem.setRestoreId(atsSearchId);
                        return new WorldEditorInput(new WorldEditorParameterSearchItemProvider(searchItem, null, new XNavigateComposite.TableLoadOption[0]));
                    }
                    if ("ats.search.goal".equals(namespace)) {
                        AtsSearchGoalSearchItem searchItem = new AtsSearchGoalSearchItem();
                        searchItem.setRestoreId(atsSearchId);
                        return new WorldEditorInput(new WorldEditorParameterSearchItemProvider(searchItem, null, new XNavigateComposite.TableLoadOption[0]));
                    }
                    if ("ats.search.review".equals(namespace)) {
                        AtsSearchReviewSearchItem searchItem = new AtsSearchReviewSearchItem();
                        searchItem.setRestoreId(atsSearchId);
                        return new WorldEditorInput(new WorldEditorParameterSearchItemProvider(searchItem, null, new XNavigateComposite.TableLoadOption[0]));
                    }
                    for (IAtsWorldEditorItem item : AtsWorldEditorItems.getItems()) {
                        if (!item.isWorldEditorSearchProviderNamespaceMatch(namespace)) continue;
                        return item.getNewWorldEditorInputFromNamespace(namespace, atsSearchId);
                    }
                }
                AtsSearchWorkflowSearchItem searchItem = new AtsSearchWorkflowSearchItem();
                searchItem.setRestoreId(atsSearchId);
                return new WorldEditorInput(new WorldEditorParameterSearchItemProvider(searchItem, null, new XNavigateComposite.TableLoadOption[0]));
            }
        }
        catch (Exception exception) {}
        return new WorldEditorInput(new WorldEditorReloadProvider(title, branch, artIds));
    }

    public static void saveState(IMemento memento, WorldEditorInput input) {
        String title = input.getName();
        String artIds = input.getIdString();
        BranchId branch = input.getBranch();
        if (Strings.isValid((String)artIds) && branch.isValid() && Strings.isValid((String)title)) {
            memento.putString(BRANCH_KEY, branch.getIdString());
            memento.putString(ART_IDS, artIds);
            memento.putString(TITLE, title);
        }
        if (input.getAtsSearchId() > 0L) {
            memento.putString(ATS_SEARCH_ID, String.valueOf(input.getAtsSearchId()));
            memento.putString(ATS_SEARCH_NAMESPACE, String.valueOf(input.getAtsSearchNamespace()));
        }
    }
}

