/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerSorter;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreColumn;
import org.eclipse.osee.ats.api.column.AtsCoreColumnToken;
import org.eclipse.osee.ats.core.column.model.AtsCoreAttrTokenColumn;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;
import org.eclipse.osee.ats.ide.agile.AgileFeatureGroupColumnUI;
import org.eclipse.osee.ats.ide.agile.SprintColumnUI;
import org.eclipse.osee.ats.ide.agile.SprintOrderColumnUI;
import org.eclipse.osee.ats.ide.agile.jira.JiraAssigneeColumnUI;
import org.eclipse.osee.ats.ide.agile.jira.JiraStateColumnUI;
import org.eclipse.osee.ats.ide.agile.jira.JiraStoryLinkColumnUI;
import org.eclipse.osee.ats.ide.column.ActionableItemOwnerUI;
import org.eclipse.osee.ats.ide.column.AgileTeamPointsColumnUI;
import org.eclipse.osee.ats.ide.column.AnnualCostAvoidanceColumnUI;
import org.eclipse.osee.ats.ide.column.AssigneeColumnUI;
import org.eclipse.osee.ats.ide.column.BacklogColumnUI;
import org.eclipse.osee.ats.ide.column.BacklogOrderColumnUI;
import org.eclipse.osee.ats.ide.column.BranchStatusColumnUI;
import org.eclipse.osee.ats.ide.column.ChangeTypeColumnUI;
import org.eclipse.osee.ats.ide.column.CompletedCancelledByColumnUI;
import org.eclipse.osee.ats.ide.column.CompletedCancelledDateColumnUI;
import org.eclipse.osee.ats.ide.column.CountryColumnUI;
import org.eclipse.osee.ats.ide.column.DaysInCurrentStateColumnUI;
import org.eclipse.osee.ats.ide.column.DeadlineColumnUI;
import org.eclipse.osee.ats.ide.column.GoalOrderColumnUI;
import org.eclipse.osee.ats.ide.column.GoalOrderVoteColumnUI;
import org.eclipse.osee.ats.ide.column.GoalsColumnUI;
import org.eclipse.osee.ats.ide.column.GroupsColumnUI;
import org.eclipse.osee.ats.ide.column.ImplementorColumnUI;
import org.eclipse.osee.ats.ide.column.LastStatusedColumnUI;
import org.eclipse.osee.ats.ide.column.LastTransitionDateColumnUI;
import org.eclipse.osee.ats.ide.column.NotesColorColumnUI;
import org.eclipse.osee.ats.ide.column.NotesColumnUI;
import org.eclipse.osee.ats.ide.column.NumberOfTasksColumnUI;
import org.eclipse.osee.ats.ide.column.NumberOfTasksRemainingColumnUI;
import org.eclipse.osee.ats.ide.column.OriginatingWorkFlowColumnUI;
import org.eclipse.osee.ats.ide.column.OriginatorColumnUI;
import org.eclipse.osee.ats.ide.column.ParentAtsIdColumnUI;
import org.eclipse.osee.ats.ide.column.ParentIdColumnUI;
import org.eclipse.osee.ats.ide.column.ParentStateColumnUI;
import org.eclipse.osee.ats.ide.column.ParentTopTeamColumnUI;
import org.eclipse.osee.ats.ide.column.ParentWorkDefColumnUI;
import org.eclipse.osee.ats.ide.column.PercentCompleteReviewsColumnUI;
import org.eclipse.osee.ats.ide.column.PercentCompleteStateReviewColumnUI;
import org.eclipse.osee.ats.ide.column.PercentCompleteStateTasksColumnUI;
import org.eclipse.osee.ats.ide.column.PercentCompleteTasksColumnUI;
import org.eclipse.osee.ats.ide.column.PercentCompleteTasksReviewsColumnUI;
import org.eclipse.osee.ats.ide.column.PercentCompleteTotalColumnUI;
import org.eclipse.osee.ats.ide.column.PointsColumnUI;
import org.eclipse.osee.ats.ide.column.ProgramColumnUI;
import org.eclipse.osee.ats.ide.column.RelatedArtifactChangedColumnUI;
import org.eclipse.osee.ats.ide.column.RelatedArtifactLastModifiedByColumnUI;
import org.eclipse.osee.ats.ide.column.RelatedArtifactLastModifiedDateColumnUI;
import org.eclipse.osee.ats.ide.column.RelatedToStateColumnUI;
import org.eclipse.osee.ats.ide.column.RemainingHoursColumnUI;
import org.eclipse.osee.ats.ide.column.RemainingPointsNumericTotalColumnUI;
import org.eclipse.osee.ats.ide.column.RemainingPointsNumericWorkflowColumnUI;
import org.eclipse.osee.ats.ide.column.RemainingPointsTotalColumnUI;
import org.eclipse.osee.ats.ide.column.RemainingPointsWorkflowColumnUI;
import org.eclipse.osee.ats.ide.column.ReviewAuthorColumnUI;
import org.eclipse.osee.ats.ide.column.ReviewDeciderColumnUI;
import org.eclipse.osee.ats.ide.column.ReviewFormalTypeColumnUI;
import org.eclipse.osee.ats.ide.column.ReviewModeratorColumnUI;
import org.eclipse.osee.ats.ide.column.ReviewNumIssuesColumnUI;
import org.eclipse.osee.ats.ide.column.ReviewNumMajorDefectsColumnUI;
import org.eclipse.osee.ats.ide.column.ReviewNumMinorDefectsColumnUI;
import org.eclipse.osee.ats.ide.column.ReviewReviewerColumnUI;
import org.eclipse.osee.ats.ide.column.SiblingAtsIdColumnUI;
import org.eclipse.osee.ats.ide.column.SiblingTeamDefColumnUI;
import org.eclipse.osee.ats.ide.column.TargetedVersionColumnUI;
import org.eclipse.osee.ats.ide.column.TaskRelatedArtifactTypeColumnUI;
import org.eclipse.osee.ats.ide.column.TitleColumnUI;
import org.eclipse.osee.ats.ide.column.WebExportReviewedColumnUI;
import org.eclipse.osee.ats.ide.column.WorkDaysNeededColumnUI;
import org.eclipse.osee.ats.ide.column.WorkPackageTextColumnUI;
import org.eclipse.osee.ats.ide.column.WorkingBranchArchivedColumnUI;
import org.eclipse.osee.ats.ide.column.WorkingBranchIdColumnUI;
import org.eclipse.osee.ats.ide.column.WorkingBranchStateColumnUI;
import org.eclipse.osee.ats.ide.column.WorkingBranchTypeColumnUI;
import org.eclipse.osee.ats.ide.column.signby.ApproveRequestedByColumnUI;
import org.eclipse.osee.ats.ide.column.signby.ApproveRequestedByDateColumnUI;
import org.eclipse.osee.ats.ide.column.signby.ReviewedByColumnUI;
import org.eclipse.osee.ats.ide.column.signby.ReviewedByDateColumnUI;
import org.eclipse.osee.ats.ide.column.signby.SignedByColumnUI;
import org.eclipse.osee.ats.ide.column.signby.SignedByDateColumnUI;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttrTokenXColumn;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsCoreCodeXColumn;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.priority.PriorityColumnUI;
import org.eclipse.osee.ats.ide.world.AtsWorldEditorItems;
import org.eclipse.osee.ats.ide.world.IAtsWorldEditorItem;
import org.eclipse.osee.ats.ide.world.WorldXViewerSorter;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.IOseeTreeReportProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.SkynetXViewerFactory;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.ArtifactTokenColumn;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.ArtifactTypeColumn;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.IAttributeColumn;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.IdColumn;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.LastModifiedByColumn;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.LastModifiedCommentColumn;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.LastModifiedDateColumn;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.LastModifiedTransactionColumn;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.LastModifiedTransactionCommentColumn;

public class WorldXViewerFactory
extends SkynetXViewerFactory {
    public GoalArtifact soleGoalArtifact;
    public static final String COLUMN_NAMESPACE = "ats.column";
    public static final String NAMESPACE = "WorldXViewer";
    protected Map<String, XViewerColumn> loadedColIds;
    protected AtsApi atsApi = AtsApiService.get();

    public WorldXViewerFactory(String namespace, IOseeTreeReportProvider reportProvider) {
        super(namespace, reportProvider);
        this.registerColumnsAndSetDefaults();
    }

    public WorldXViewerFactory(IOseeTreeReportProvider reportProvider) {
        super(NAMESPACE, reportProvider);
        this.registerColumnsAndSetDefaults();
    }

    public List<AtsCoreColumnToken> getDefaultVisibleColumns() {
        return Arrays.asList(AtsColumnTokensDefault.TypeColumn, AtsColumnTokensDefault.StateColumn, AtsColumnTokensDefault.PriorityColumn, AtsColumnTokensDefault.ChangeTypeColumn, AtsColumnTokensDefault.AssigneeColumn, AtsColumnTokensDefault.TitleColumn, AtsColumnTokensDefault.ActionableItemsColumn, AtsColumnTokensDefault.AtsIdColumn, AtsColumnTokensDefault.CreatedDateColumn, AtsColumnTokensDefault.TargetedVersionColumn, AtsColumnTokensDefault.TeamColumn, AtsColumnTokensDefault.NotesColumn);
    }

    public List<Integer> getDefaultColumnWidths() {
        return Arrays.asList(150, 75, 20, 40, 100, 400, 80, 75, 80, 40, 50, 80);
    }

    protected List<XViewerColumn> getColumns(List<AtsCoreColumnToken> defaultVisibleColumns) {
        ArrayList<XViewerColumn> cols = new ArrayList<XViewerColumn>();
        for (AtsCoreColumnToken colTok : defaultVisibleColumns) {
            XViewerColumn xCol = this.loadedColIds.get(colTok.getId());
            if (xCol == null) {
                OseeLog.log(WorldXViewerFactory.class, (Level)Level.SEVERE, (String)("No registered column for " + colTok.getId()));
                continue;
            }
            cols.add(xCol);
        }
        return cols;
    }

    private synchronized void loadColumns() {
        if (this.loadedColIds == null) {
            this.loadedColIds = new HashMap<String, XViewerColumn>();
            for (XViewerColumn xCol : WorldXViewerFactory.getWorldViewIdeXColumns()) {
                XViewerColumn xColCopy = xCol.copy();
                this.loadedColIds.put(xCol.getId(), xColCopy);
            }
            XResultData loadResults = this.atsApi.getColumnService().getLoadResults();
            if (loadResults.isErrors()) {
                XResultDataUI.report((XResultData)loadResults, (String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " Load Columns"));
            }
            this.registerPluginColumns();
            for (AtsCoreColumn col : this.atsApi.getColumnService().getColumns()) {
                XViewerAtsColumn xCol;
                if (this.loadedColIds.containsKey(col.getId()) || this.isCoreColumnTypeMatch(col) || (xCol = this.createXColumn(col)) == null) continue;
                this.loadedColIds.put(xCol.getId(), xCol);
            }
        }
    }

    public void registerPluginColumns() {
        try {
            List<IAtsWorldEditorItem> worldItems = AtsWorldEditorItems.getItems();
            for (IAtsWorldEditorItem item : worldItems) {
                Collection<IUserGroupArtifactToken> itemGroups = item.getUserGroups();
                if (!AtsApiService.get().userService().isInUserGroup(itemGroups.toArray(new IUserGroupArtifactToken[itemGroups.size()]))) continue;
                for (XViewerColumn xCol : item.getXViewerColumns()) {
                    XViewerColumn xColCopy = xCol.copy();
                    this.loadedColIds.put(xCol.getId(), xColCopy);
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private boolean isCoreColumnTypeMatch(AtsCoreColumn col) {
        if (!(col instanceof AtsCoreAttrTokenColumn)) {
            return false;
        }
        for (XViewerColumn xCol : this.loadedColIds.values()) {
            AttributeTypeToken attributeType;
            if (!(xCol instanceof IAttributeColumn) || !(attributeType = ((IAttributeColumn)xCol).getAttributeType()).getId().equals(((AtsCoreAttrTokenColumn)col).getColumnToken().getAttrTypeId())) continue;
            return true;
        }
        return false;
    }

    private void registerColumnsAndSetDefaults() {
        this.loadColumns();
        ArrayList<String> registeredColIds = new ArrayList<String>();
        XResultData rd = this.atsApi.getColumnService().validateIdeColumns(WorldXViewerFactory.getWorldViewIdeXColumns());
        if (rd.isErrors()) {
            OseeLog.log(WorldXViewerFactory.class, (Level)Level.SEVERE, (String)String.format("%s: Column Errors: %s", ((Object)((Object)this)).getClass().getSimpleName(), rd.toString()));
        }
        List<XViewerColumn> columns = this.getColumns(this.getDefaultVisibleColumns());
        List<Integer> defaultColumnWidths = this.getDefaultColumnWidths();
        int colNum = 0;
        for (XViewerColumn xCol : columns) {
            xCol.setShow(true);
            int width = xCol.getWidth();
            if (defaultColumnWidths.size() > colNum) {
                width = defaultColumnWidths.get(colNum++);
            }
            xCol.setWidth(width);
            this.registerColumns(new XViewerColumn[]{xCol});
            registeredColIds.add(xCol.getId());
        }
        for (XViewerColumn xCol : this.loadedColIds.values()) {
            if (registeredColIds.contains(xCol.getId())) continue;
            xCol.setShow(false);
            this.registerColumns(new XViewerColumn[]{xCol});
            registeredColIds.add(xCol.getId());
        }
    }

    private XViewerAtsColumn createXColumn(AtsCoreColumn col) {
        if (col instanceof AtsCoreAttrTokenColumn) {
            AtsCoreAttrTokenColumn atsCoreAttrTokenColumn = (AtsCoreAttrTokenColumn)col;
            XViewerAtsAttrTokenXColumn xCol = new XViewerAtsAttrTokenXColumn(atsCoreAttrTokenColumn.getColumnToken());
            if (xCol.getAttributeType().isInvalid()) {
                OseeLog.log(WorldXViewerFactory.class, (Level)Level.SEVERE, (String)String.format("%s: Invalid Attr Type for col [%s] from [%s]", ((Object)((Object)this)).getClass().getSimpleName(), col, col.getSource()));
                return null;
            }
            if (atsCoreAttrTokenColumn.getColumnToken().isColumnMultiEdit()) {
                xCol.setMultiColumnEditable(true);
            }
            return xCol;
        }
        if (col instanceof AtsCoreCodeColumn) {
            AtsCoreCodeColumn atsCoreCodeColumn = (AtsCoreCodeColumn)col;
            XViewerAtsCoreCodeXColumn xCol = new XViewerAtsCoreCodeXColumn(atsCoreCodeColumn.getColumnToken(), this.atsApi);
            return xCol;
        }
        OseeLog.log(WorldXViewerFactory.class, (Level)Level.SEVERE, (String)String.format("%s: Unhandled col [%s]", ((Object)((Object)this)).getClass().getSimpleName(), col));
        return null;
    }

    public static final List<XViewerColumn> getWorldViewIdeXColumns() {
        return Arrays.asList(new XViewerColumn[]{ActionableItemOwnerUI.getInstance(), AgileFeatureGroupColumnUI.getInstance(), AgileTeamPointsColumnUI.getInstance(), AnnualCostAvoidanceColumnUI.getInstance(), ArtifactTokenColumn.getInstance(), ArtifactTypeColumn.getInstance(), AssigneeColumnUI.getInstance(), BacklogColumnUI.getInstance(), BacklogOrderColumnUI.getInstance(), BranchStatusColumnUI.getInstance(), ChangeTypeColumnUI.getInstance(), CompletedCancelledByColumnUI.getInstance(), CompletedCancelledDateColumnUI.getInstance(), CountryColumnUI.getInstance(), DaysInCurrentStateColumnUI.getInstance(), DeadlineColumnUI.getInstance(), GoalOrderColumnUI.getInstance(), GoalOrderVoteColumnUI.getInstance(), GoalsColumnUI.getInstance(), GroupsColumnUI.getInstance(), IdColumn.getInstance(), ImplementorColumnUI.getInstance(), JiraAssigneeColumnUI.getInstance(), JiraStateColumnUI.getInstance(), JiraStoryLinkColumnUI.getInstance(), LastModifiedByColumn.getInstance(), LastModifiedCommentColumn.getInstance(), LastModifiedDateColumn.getInstance(), LastModifiedTransactionColumn.getInstance(), LastModifiedTransactionCommentColumn.getInstance(), LastStatusedColumnUI.getInstance(), LastTransitionDateColumnUI.getInstance(), NotesColumnUI.getInstance(), NotesColorColumnUI.getInstance(), NumberOfTasksColumnUI.getInstance(), NumberOfTasksRemainingColumnUI.getInstance(), OriginatingWorkFlowColumnUI.getInstance(), OriginatorColumnUI.getInstance(), ParentAtsIdColumnUI.getInstance(), ParentIdColumnUI.getInstance(), ParentStateColumnUI.getInstance(), ParentTopTeamColumnUI.getInstance(), ParentWorkDefColumnUI.getInstance(), PercentCompleteReviewsColumnUI.getInstance(), PercentCompleteStateReviewColumnUI.getInstance(), PercentCompleteStateTasksColumnUI.getInstance(), PercentCompleteTasksColumnUI.getInstance(), PercentCompleteTasksReviewsColumnUI.getInstance(), PercentCompleteTotalColumnUI.getInstance(), PointsColumnUI.getInstance(), PriorityColumnUI.getInstance(), ProgramColumnUI.getInstance(), RelatedArtifactChangedColumnUI.getInstance(), RelatedArtifactLastModifiedByColumnUI.getInstance(), RelatedArtifactLastModifiedDateColumnUI.getInstance(), RelatedToStateColumnUI.getInstance(), RemainingHoursColumnUI.getInstance(), RemainingPointsNumericTotalColumnUI.getInstance(), RemainingPointsNumericWorkflowColumnUI.getInstance(), RemainingPointsTotalColumnUI.getInstance(), RemainingPointsWorkflowColumnUI.getInstance(), ReviewAuthorColumnUI.getInstance(), ReviewDeciderColumnUI.getInstance(), ReviewFormalTypeColumnUI.getInstance(), ReviewModeratorColumnUI.getInstance(), ReviewNumIssuesColumnUI.getInstance(), ReviewNumMajorDefectsColumnUI.getInstance(), ReviewNumMinorDefectsColumnUI.getInstance(), ReviewReviewerColumnUI.getInstance(), SiblingAtsIdColumnUI.getInstance(), SiblingTeamDefColumnUI.getInstance(), SprintColumnUI.getInstance(), SprintOrderColumnUI.getInstance(), TargetedVersionColumnUI.getInstance(), TaskRelatedArtifactTypeColumnUI.getInstance(), TitleColumnUI.getInstance(), WebExportReviewedColumnUI.getInstance(), WorkDaysNeededColumnUI.getInstance(), WorkPackageTextColumnUI.getInstance(), WorkingBranchArchivedColumnUI.getInstance(), WorkingBranchIdColumnUI.getInstance(), WorkingBranchStateColumnUI.getInstance(), WorkingBranchTypeColumnUI.getInstance(), ApproveRequestedByColumnUI.getInstance(), ApproveRequestedByDateColumnUI.getInstance(), SignedByColumnUI.getInstance(), SignedByDateColumnUI.getInstance(), ReviewedByColumnUI.getInstance(), ReviewedByDateColumnUI.getInstance()});
    }

    public XViewerSorter createNewXSorter(XViewer xViewer) {
        return new WorldXViewerSorter(xViewer);
    }

    public XViewerColumn getDefaultXViewerColumn(String id) {
        XViewerColumn xCol = super.getDefaultXViewerColumn(id);
        if (xCol == null) {
            String newId = this.getIdFromLegacyId(id);
            xCol = super.getDefaultXViewerColumn(newId);
        }
        return xCol;
    }

    private String getIdFromLegacyId(String legacyId) {
        return AtsApiService.get().getColumnService().getIdFromLegacyId(legacyId);
    }
}

