/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditor;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AtsObjectNameSorter;
import org.eclipse.osee.ats.ide.workflow.WorkflowLabelProvider;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.IWorldEditorConsumer;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.ats.ide.world.search.MultipleIdSearchData;
import org.eclipse.osee.ats.ide.world.search.MultipleIdSearchUi;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.ArtifactDecoratorPreferences;
import org.eclipse.osee.framework.ui.skynet.ArtifactLabelProvider;
import org.eclipse.osee.framework.ui.skynet.IArtifactDecoratorPreferences;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassArtifactEditor;
import org.eclipse.osee.framework.ui.skynet.cm.OseeCmEditor;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class MultipleIdSearchOperation
extends AbstractOperation
implements IWorldEditorConsumer {
    private final Set<Artifact> resultAtsArts = new HashSet<Artifact>();
    private final Set<Artifact> resultNonAtsArts = new HashSet<Artifact>();
    private final Set<Artifact> artifacts = new HashSet<Artifact>();
    private final MultipleIdSearchData data;
    private boolean multiLine;

    public MultipleIdSearchOperation(MultipleIdSearchData data) {
        super(data.getName(), "org.eclipse.osee.ats.ide");
        this.data = data;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        if (!this.data.hasValidInput()) {
            MultipleIdSearchUi ui = new MultipleIdSearchUi(this.data);
            ui.setMultiLine(this.multiLine);
            if (!ui.getInput()) {
                return;
            }
        }
        if (this.data.getIds().isEmpty()) {
            AWorkbench.popup((String)"Must Enter Valid Id");
            return;
        }
        this.searchAndSplitResults();
        if (this.resultAtsArts.isEmpty() && this.resultNonAtsArts.isEmpty()) {
            AWorkbench.popup((String)("Invalid ID/Legacy PCR Id(s): " + Collections.toString((String)", ", this.data.getIds())));
            return;
        }
        if (this.resultNonAtsArts.size() > 0) {
            MassArtifactEditor.editArtifacts((String)"Open Artifact(s)", new ArrayList<Artifact>(this.resultNonAtsArts), (XNavigateComposite.TableLoadOption[])new XNavigateComposite.TableLoadOption[0]);
        }
        if (this.resultAtsArts.size() > 0) {
            if (this.data.getWorldEditor() != null && this.data.getAtsEditor() == AtsEditor.WorldEditor) {
                this.data.getWorldEditor().getWorldComposite().load(this.getName(), this.resultAtsArts, XNavigateComposite.TableLoadOption.None);
            } else if (this.data.getAtsEditor() == AtsEditor.WorkflowEditor) {
                this.openWorkflowEditor(this.resultAtsArts);
            } else if (this.data.getAtsEditor() == AtsEditor.ChangeReport) {
                this.openChangeReport(this.resultAtsArts, this.data.getEnteredIds());
            } else if (this.data.getAtsEditor() == AtsEditor.ArtifactEditor) {
                for (Artifact artifact : this.resultAtsArts) {
                    AtsEditors.openArtifact(artifact, OseeCmEditor.ArtifactEditor);
                }
            } else {
                WorldEditor.open(new WorldEditorSimpleProvider(this.getName(), this.resultAtsArts));
            }
        }
    }

    private void openChangeReport(Set<Artifact> artifacts, final String enteredIds) {
        final HashSet<Artifact> addedArts = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)artifact)) {
                    if (!AtsApiService.get().getBranchService().isCommittedBranchExists(team) && !AtsApiService.get().getBranchService().isWorkingBranchInWork(team)) continue;
                    addedArts.add(AtsApiService.get().getQueryServiceIde().getArtifact(team));
                }
            }
            if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
            TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)artifact;
            if (!AtsApiService.get().getBranchService().isCommittedBranchExists((IAtsTeamWorkflow)teamArt) && !AtsApiService.get().getBranchService().isWorkingBranchInWork((IAtsTeamWorkflow)teamArt)) continue;
            addedArts.add(artifact);
        }
        if (addedArts.size() == 1) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (Artifact art : addedArts) {
                        if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
                        AtsApiService.get().getBranchServiceIde().showChangeReport((TeamWorkFlowArtifact)art);
                    }
                }
            });
        } else if (addedArts.size() > 0) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ArtifactDecoratorPreferences artDecorator = new ArtifactDecoratorPreferences();
                    artDecorator.setShowArtBranch(true);
                    artDecorator.setShowArtType(true);
                    artDecorator.setShowRelations(false);
                    FilteredCheckboxTreeDialog dialog = new FilteredCheckboxTreeDialog("Select Available Change Reports", "Select available Change Reports to run.", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new ArtifactLabelProvider((IArtifactDecoratorPreferences)artDecorator), (ViewerComparator)new AtsObjectNameSorter());
                    dialog.setInput((Object)addedArts);
                    if (dialog.open() == 0) {
                        if (dialog.getResult().length == 0) {
                            return;
                        }
                        Object[] objectArray = dialog.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object obj = objectArray[n2];
                            AtsApiService.get().getBranchServiceIde().showChangeReport((TeamWorkFlowArtifact)((Object)obj));
                            ++n2;
                        }
                    }
                }
            });
        } else {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Displays.getActiveShell(), (String)"Open Change Reports", (String)("No change report exists for " + enteredIds));
                }
            });
        }
    }

    private void openWorkflowEditor(final Set<Artifact> resultAtsArts) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Artifact artifact = null;
                if (resultAtsArts.size() == 1) {
                    artifact = (Artifact)resultAtsArts.iterator().next();
                } else {
                    if (MultipleIdSearchOperation.this.data.isOpenEach()) {
                        for (Artifact art : resultAtsArts) {
                            AtsEditors.openATSAction((ArtifactToken)art, AtsOpenOption.OpenOneOrPopupSelect);
                        }
                        return;
                    }
                    ListDialog ld = new ListDialog(Displays.getActiveShell());
                    ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    ld.setLabelProvider((ILabelProvider)new WorkflowLabelProvider());
                    ld.setTitle("Select Workflow");
                    ld.setMessage("Select Workflow");
                    ld.setInput((Object)resultAtsArts);
                    if (ld.open() == 0) {
                        artifact = AtsApiService.get().getQueryServiceIde().getArtifact(ld.getResult()[0]);
                    } else {
                        return;
                    }
                }
                if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                    AtsEditors.openATSAction((ArtifactToken)artifact, AtsOpenOption.OpenOneOrPopupSelect);
                } else {
                    try {
                        WorkflowEditor.editArtifact(artifact);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            }
        });
    }

    private void searchAndSplitResults() {
        List<String> validIds;
        Collection teamArts = AtsApiService.get().getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andAttr((AttributeTypeToken)AtsAttributeTypes.LegacyPcrId, this.data.getIds(), new QueryOption[0]).getItems();
        this.resultAtsArts.addAll(teamArts);
        if (this.data.isIncludeArtIds() && this.data.getBranchForIncludeArtIds() != null) {
            ArrayList<ArtifactId> artifactIds = new ArrayList<ArtifactId>();
            for (String idStr : Collections.fromString((String)this.data.getEnteredIds(), (String)",")) {
                if (!Strings.isNumeric((String)idStr)) continue;
                artifactIds.add(ArtifactId.valueOf((String)idStr));
            }
            for (Artifact art : ArtifactQuery.getArtifactListFrom(artifactIds, (BranchId)this.data.getBranchForIncludeArtIds())) {
                this.artifacts.add(art);
            }
        }
        if (!(validIds = this.data.getIds()).isEmpty()) {
            this.artifacts.addAll(Collections.castAll((Collection)AtsApiService.get().getQueryService().getArtifactsFromIds(validIds)));
        }
        for (Artifact art : this.artifacts) {
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AtsArtifact})) {
                this.resultAtsArts.add(art);
                continue;
            }
            this.resultNonAtsArts.add(art);
        }
    }

    @Override
    public void setWorldEditor(WorldEditor worldEditor) {
        this.data.setWorldEditor(worldEditor);
    }

    @Override
    public WorldEditor getWorldEditor() {
        return this.data.getWorldEditor();
    }

    public String getName() {
        if (Strings.isValid((String)this.data.getEnteredIds())) {
            return String.format("%s - [%s]", super.getName(), Strings.truncate((String)this.data.getEnteredIds(), (int)80));
        }
        return super.getName();
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }
}

